/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import java.util.concurrent.atomic.AtomicInteger;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.IdentifiedArrayReferenceValue;
import proguard.evaluation.value.IdentifiedDoubleValue;
import proguard.evaluation.value.IdentifiedFloatValue;
import proguard.evaluation.value.IdentifiedIntegerValue;
import proguard.evaluation.value.IdentifiedLongValue;
import proguard.evaluation.value.IdentifiedReferenceValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.ParticularValueFactory;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TypedReferenceValueFactory;
import proguard.evaluation.value.ValueFactory;

public class IdentifiedValueFactory
extends ParticularValueFactory {
    private final AtomicInteger integerID = new AtomicInteger(0);
    private final AtomicInteger longID = new AtomicInteger(0);
    private final AtomicInteger floatID = new AtomicInteger(0);
    private final AtomicInteger doubleID = new AtomicInteger(0);
    private static final AtomicInteger referenceIdProvider = new AtomicInteger(0);

    public IdentifiedValueFactory() {
    }

    public IdentifiedValueFactory(ValueFactory referenceValueFactory) {
        super(referenceValueFactory);
    }

    public IdentifiedValueFactory(ValueFactory arrayReferenceValueFactory, ValueFactory referenceValueFactory) {
        super(arrayReferenceValueFactory, referenceValueFactory);
    }

    @Override
    public IntegerValue createIntegerValue() {
        return new IdentifiedIntegerValue(this, this.integerID.incrementAndGet());
    }

    @Override
    public LongValue createLongValue() {
        return new IdentifiedLongValue(this, this.longID.incrementAndGet());
    }

    @Override
    public FloatValue createFloatValue() {
        return new IdentifiedFloatValue(this, this.floatID.incrementAndGet());
    }

    @Override
    public DoubleValue createDoubleValue() {
        return new IdentifiedDoubleValue(this, this.doubleID.incrementAndGet());
    }

    @Override
    public ReferenceValue createReferenceValue(String type, Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull) {
        return type == null ? TypedReferenceValueFactory.REFERENCE_VALUE_NULL : new IdentifiedReferenceValue(type, referencedClass, mayBeExtension, mayBeNull, this, IdentifiedValueFactory.generateReferenceId());
    }

    @Override
    @Deprecated
    public ReferenceValue createReferenceValue(String type, Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull, Object value) {
        return this.createReferenceValue(type, referencedClass, mayBeExtension, mayBeNull);
    }

    @Override
    public ReferenceValue createReferenceValue(String type, Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull, Clazz creationClass, Method creationMethod, int creationOffset) {
        return this.createReferenceValue(type, referencedClass, mayBeExtension, mayBeNull);
    }

    @Override
    @Deprecated
    public ReferenceValue createReferenceValue(String type, Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull, Clazz creationClass, Method creationMethod, int creationOffset, Object value) {
        return this.createReferenceValue(type, referencedClass, mayBeExtension, mayBeNull);
    }

    @Override
    public ReferenceValue createReferenceValueForId(String type, Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull, Object id) {
        return type == null ? TypedReferenceValueFactory.REFERENCE_VALUE_NULL : new IdentifiedReferenceValue(type, referencedClass, mayBeExtension, mayBeNull, this, id);
    }

    @Override
    @Deprecated
    public ReferenceValue createReferenceValueForId(String type, Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull, Object id, Object value) {
        return this.createReferenceValueForId(type, referencedClass, mayBeExtension, mayBeNull, id);
    }

    @Override
    public ReferenceValue createArrayReferenceValue(String type, Clazz referencedClass, IntegerValue arrayLength) {
        return type == null ? TypedReferenceValueFactory.REFERENCE_VALUE_NULL : new IdentifiedArrayReferenceValue('[' + type, referencedClass, false, arrayLength, this, IdentifiedValueFactory.generateReferenceId());
    }

    public static int generateReferenceId() {
        return referenceIdProvider.incrementAndGet();
    }
}

