/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import proguard.analysis.datastructure.CodeLocation;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.util.ClassUtil;
import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.object.AnalyzedObject;

public interface ValueFactory {
    public Value createValue(String var1, Clazz var2, boolean var3, boolean var4);

    public IntegerValue createIntegerValue();

    public IntegerValue createIntegerValue(int var1);

    public IntegerValue createIntegerValue(int var1, int var2);

    public LongValue createLongValue();

    public LongValue createLongValue(long var1);

    public FloatValue createFloatValue();

    public FloatValue createFloatValue(float var1);

    public DoubleValue createDoubleValue();

    public DoubleValue createDoubleValue(double var1);

    public ReferenceValue createReferenceValue();

    public ReferenceValue createReferenceValueNull();

    default public ReferenceValue createReferenceValue(Clazz clazz) {
        return this.createReferenceValue(ClassUtil.internalTypeFromClassName(clazz.getName()), clazz, ClassUtil.isExtendable(clazz), true);
    }

    @Deprecated
    default public ReferenceValue createReferenceValue(Clazz clazz, Object value) {
        return this.createReferenceValue(ClassUtil.internalTypeFromClassName(clazz.getName()), clazz, ClassUtil.isExtendable(clazz), true, value);
    }

    default public ReferenceValue createReferenceValue(Clazz clazz, @NotNull AnalyzedObject value) {
        Objects.requireNonNull(value, "The object value should not be null");
        Object valueContent = value.isModeled() ? value.getModeledValue() : value.getPreciseValue();
        return this.createReferenceValue(clazz, valueContent);
    }

    public ReferenceValue createReferenceValue(String var1, Clazz var2, boolean var3, boolean var4);

    @Deprecated
    public ReferenceValue createReferenceValue(String var1, Clazz var2, boolean var3, boolean var4, Object var5);

    default public ReferenceValue createReferenceValue(Clazz referencedClass, boolean mayBeExtension, boolean maybeNull, @NotNull AnalyzedObject value) {
        Objects.requireNonNull(value, "The object value should not be null");
        Object valueContent = value.isModeled() ? value.getModeledValue() : value.getPreciseValue();
        return this.createReferenceValue(value.getType(), referencedClass, mayBeExtension, maybeNull, valueContent);
    }

    public ReferenceValue createReferenceValue(String var1, Clazz var2, boolean var3, boolean var4, Clazz var5, Method var6, int var7);

    @Deprecated
    public ReferenceValue createReferenceValue(String var1, Clazz var2, boolean var3, boolean var4, Clazz var5, Method var6, int var7, Object var8);

    default public ReferenceValue createReferenceValue(Clazz referencedClass, boolean mayBeExtension, boolean maybeNull, CodeLocation creationLocation, @NotNull AnalyzedObject value) {
        Objects.requireNonNull(value, "The object value should not be null");
        if (!(creationLocation.member instanceof Method)) {
            throw new IllegalStateException("The creation location needs to be in a method");
        }
        Object valueContent = value.isModeled() ? value.getModeledValue() : value.getPreciseValue();
        return this.createReferenceValue(value.getType(), referencedClass, mayBeExtension, maybeNull, creationLocation.clazz, (Method)creationLocation.member, creationLocation.offset, valueContent);
    }

    public ReferenceValue createReferenceValueForId(String var1, Clazz var2, boolean var3, boolean var4, Object var5);

    @Deprecated
    public ReferenceValue createReferenceValueForId(String var1, Clazz var2, boolean var3, boolean var4, Object var5, Object var6);

    default public ReferenceValue createReferenceValueForId(Clazz referencedClass, boolean mayBeExtension, boolean maybeNull, Object id, @NotNull AnalyzedObject value) {
        Objects.requireNonNull(value, "The object value should not be null");
        Object valueContent = value.isModeled() ? value.getModeledValue() : value.getPreciseValue();
        return this.createReferenceValueForId(value.getType(), referencedClass, mayBeExtension, maybeNull, id, valueContent);
    }

    public ReferenceValue createArrayReferenceValue(String var1, Clazz var2, IntegerValue var3);

    public ReferenceValue createArrayReferenceValue(String var1, Clazz var2, IntegerValue var3, Object var4);
}

