/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value.object;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import proguard.classfile.util.ClassUtil;
import proguard.evaluation.value.object.AnalyzedObject;

class PreciseObject
implements AnalyzedObject {
    @NotNull
    private final Object value;
    @NotNull
    private final String type;

    PreciseObject(@NotNull Object object) {
        this.value = object;
        this.type = ClassUtil.internalType(object.getClass().getTypeName());
    }

    @Override
    @NotNull
    public Object getPreciseValue() {
        return this.value;
    }

    @Override
    @NotNull
    public String getType() {
        return this.type;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public boolean isModeled() {
        return false;
    }

    @Override
    public boolean isPrecise() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PreciseObject)) {
            return false;
        }
        PreciseObject that = (PreciseObject)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.format("PreciseObject(%s)", this.value);
    }
}

