/*
 * ProGuardCORE -- library to process Java bytecode.
 *
 * Copyright (c) 2002-2020 Guardsquare NV
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package proguard.classfile;

import proguard.classfile.visitor.*;

/**
 * This {@link Field} represents a field in a {@link LibraryClass}.
 *
 * @author Eric Lafortune
 */
public class LibraryField extends LibraryMember implements Field {
  /**
   * An extra field pointing to the Clazz object referenced in the descriptor string. This field is
   * filled out by the <code>{@link
   * proguard.classfile.util.ClassReferenceInitializer ClassReferenceInitializer}</code>. References
   * to primitive types are ignored.
   */
  public Clazz referencedClass;

  /** Creates an uninitialized LibraryField. */
  public LibraryField() {}

  /** Creates an initialized LibraryField. */
  public LibraryField(int u2accessFlags, String name, String descriptor) {
    super(u2accessFlags, name, descriptor);
  }

  // Implementations for LibraryMember.

  public void accept(LibraryClass libraryClass, MemberVisitor memberVisitor) {
    memberVisitor.visitLibraryField(libraryClass, this);
  }

  // Implementations for Member.

  public void referencedClassesAccept(ClassVisitor classVisitor) {
    if (referencedClass != null) {
      referencedClass.accept(classVisitor);
    }
  }
}
