/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.defaults;

import java.util.Stack;
import proguard.analysis.cpa.defaults.LatticeAbstractState;
import proguard.exception.ProguardCoreException;

public class StackAbstractState<AbstractSpaceT extends LatticeAbstractState<AbstractSpaceT>>
extends Stack<AbstractSpaceT>
implements LatticeAbstractState<StackAbstractState<AbstractSpaceT>> {
    @Override
    public StackAbstractState<AbstractSpaceT> join(StackAbstractState<AbstractSpaceT> abstractState) {
        StackAbstractState longerState;
        StackAbstractState shorterState;
        if (this == abstractState) {
            return this;
        }
        StackAbstractState<AbstractSpaceT> joinResult = new StackAbstractState<AbstractSpaceT>();
        if (this.size() > abstractState.size()) {
            shorterState = abstractState;
            longerState = this;
        } else {
            shorterState = this;
            longerState = abstractState;
        }
        joinResult.addAll(longerState);
        for (int shortIndex = 0; shortIndex < shorterState.size(); ++shortIndex) {
            int longIndex = shortIndex + longerState.size() - shorterState.size();
            joinResult.set(longIndex, ((LatticeAbstractState)shorterState.get(shortIndex)).join((LatticeAbstractState)longerState.get(longIndex)));
        }
        if (longerState.equals(joinResult)) {
            return longerState;
        }
        return joinResult;
    }

    @Override
    public boolean isLessOrEqual(StackAbstractState<AbstractSpaceT> abstractState) {
        int sizeDifference = abstractState.size() - this.size();
        if (sizeDifference < 0) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (((LatticeAbstractState)this.get(i)).isLessOrEqual((LatticeAbstractState)abstractState.get(i + sizeDifference))) continue;
            return false;
        }
        return true;
    }

    @Override
    public StackAbstractState<AbstractSpaceT> copy() {
        StackAbstractState<AbstractSpaceT> copy = new StackAbstractState<AbstractSpaceT>();
        copy.addAll(this);
        return copy;
    }

    public AbstractSpaceT popOrDefault(AbstractSpaceT defaultState) {
        return (AbstractSpaceT)(this.isEmpty() ? defaultState : (LatticeAbstractState)this.pop());
    }

    public AbstractSpaceT peek(int index) {
        int elementIndex = this.size() - 1 - index;
        if (elementIndex < 0) {
            throw new ProguardCoreException.Builder("Operand stack index is out of bounds (%d)", 9010).errorParameters(index).build();
        }
        return (AbstractSpaceT)((LatticeAbstractState)this.get(elementIndex));
    }

    public AbstractSpaceT peekOrDefault(int index, AbstractSpaceT defaultState) {
        int elementIndex = this.size() - 1 - index;
        return (AbstractSpaceT)(elementIndex < 0 ? defaultState : (LatticeAbstractState)this.get(elementIndex));
    }
}

