/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.taint;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import proguard.analysis.cpa.domain.taint.TaintSource;
import proguard.analysis.cpa.interfaces.CallEdge;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCallCfaEdge;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCfaEdge;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintSink;
import proguard.analysis.cpa.jvm.witness.JvmMemoryLocation;
import proguard.analysis.cpa.jvm.witness.JvmStackLocation;
import proguard.analysis.cpa.jvm.witness.JvmStaticFieldLocation;
import proguard.analysis.datastructure.callgraph.Call;
import proguard.classfile.Signature;
import proguard.classfile.util.ClassUtil;
import proguard.exception.ProguardCoreException;

public class JvmInvokeTaintSink
extends JvmTaintSink {
    private static final Predicate<Call> CALL_MATCHER_DEFAULT = x -> true;
    public final boolean takesInstance;
    public final Set<Integer> takesArgs;
    public final Set<String> takesGlobals;
    public final Predicate<Call> callMatcher;

    @Deprecated
    public JvmInvokeTaintSink(Signature signature, boolean takesInstance, Set<Integer> takesArgs, Set<String> takesGlobals) {
        this(signature, IS_VALID_FOR_SOURCE_DEFAULT, takesInstance, takesArgs, takesGlobals, CALL_MATCHER_DEFAULT);
    }

    @Deprecated
    public JvmInvokeTaintSink(Signature signature, Predicate<Call> callMatcher, boolean takesInstance, Set<Integer> takesArgs, Set<String> takesGlobals) {
        this(signature, IS_VALID_FOR_SOURCE_DEFAULT, takesInstance, takesArgs, takesGlobals, callMatcher);
    }

    protected JvmInvokeTaintSink(Signature signature, Predicate<TaintSource> isValidForSource, boolean takesInstance, Set<Integer> takesArgs, Set<String> takesGlobals, Predicate<Call> callMatcher) {
        super(signature, isValidForSource);
        if (!takesInstance && takesArgs.isEmpty() && takesGlobals.isEmpty()) {
            throw new ProguardCoreException.Builder("Tainted sink for method %s is missing taint", 9023).errorParameters(signature).build();
        }
        this.takesInstance = takesInstance;
        this.takesArgs = takesArgs;
        this.takesGlobals = takesGlobals;
        this.callMatcher = callMatcher;
    }

    @Override
    public Set<JvmMemoryLocation> getMemoryLocations() {
        HashSet<JvmMemoryLocation> result = new HashSet<JvmMemoryLocation>();
        String fqn = this.signature.getFqn();
        String descriptor = fqn.substring(fqn.indexOf("("));
        int parameterSize = ClassUtil.internalMethodParameterSize(descriptor);
        if (this.takesInstance) {
            result.add(new JvmStackLocation(parameterSize));
        }
        this.takesArgs.forEach(i -> result.add(new JvmStackLocation(parameterSize - ClassUtil.internalMethodVariableIndex(descriptor, true, (int)i))));
        this.takesGlobals.forEach(n -> result.add(new JvmStaticFieldLocation((String)n)));
        return result;
    }

    @Override
    public boolean matchCfaEdge(JvmCfaEdge edge) {
        if (!(edge instanceof JvmCallCfaEdge)) {
            return false;
        }
        CallEdge callEdge = (CallEdge)((Object)edge);
        return this.signature.equals(callEdge.getCall().getTarget()) && this.callMatcher.test(callEdge.getCall());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JvmInvokeTaintSink)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JvmInvokeTaintSink taintSink = (JvmInvokeTaintSink)o;
        return this.takesInstance == taintSink.takesInstance && Objects.equals(this.takesArgs, taintSink.takesArgs) && Objects.equals(this.takesGlobals, taintSink.takesGlobals) && Objects.equals(this.callMatcher, taintSink.callMatcher);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.takesInstance, this.takesArgs, this.takesGlobals, this.callMatcher);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder("[JvmInvokeTaintSink] ").append(this.signature);
        if (this.takesInstance) {
            result.append(", takes instance");
        }
        if (!this.takesArgs.isEmpty()) {
            result.append(", takes args (").append(this.takesArgs.stream().map(Objects::toString).sorted().collect(Collectors.joining(", "))).append(")");
        }
        if (!this.takesGlobals.isEmpty()) {
            result.append(", takes globals (").append(this.takesGlobals.stream().sorted().collect(Collectors.joining(", "))).append(")");
        }
        if (!IS_VALID_FOR_SOURCE_DEFAULT.equals(this.isValidForSource)) {
            result.append(", filtered by source ").append(this.isValidForSource);
        }
        if (!CALL_MATCHER_DEFAULT.equals(this.callMatcher)) {
            result.append(", filtered by call ").append(this.callMatcher);
        }
        return result.toString();
    }

    static /* synthetic */ Predicate access$000() {
        return IS_VALID_FOR_SOURCE_DEFAULT;
    }

    static /* synthetic */ Predicate access$100() {
        return CALL_MATCHER_DEFAULT;
    }

    public static class Builder {
        protected Predicate<TaintSource> isValidForSource = JvmInvokeTaintSink.access$000();
        protected Predicate<Call> callMatcher = JvmInvokeTaintSink.access$100();
        protected boolean takesInstance = false;
        protected Set<Integer> takesArgs = new HashSet<Integer>();
        protected Set<String> takesGlobals = new HashSet<String>();
        protected final Signature signature;

        public Builder(Signature signature) {
            this.signature = signature;
        }

        public JvmInvokeTaintSink build() {
            return new JvmInvokeTaintSink(this.signature, this.isValidForSource, this.takesInstance, this.takesArgs, this.takesGlobals, this.callMatcher);
        }

        public Builder setIsValidForSource(Predicate<TaintSource> isValidForSource) {
            this.isValidForSource = isValidForSource;
            return this;
        }

        public Builder setTakesInstance(boolean takesInstance) {
            this.takesInstance = takesInstance;
            return this;
        }

        public Builder setTakesArgs(Set<Integer> takesArgs) {
            this.takesArgs = takesArgs;
            return this;
        }

        public Builder setTakesGlobals(Set<String> takesGlobals) {
            this.takesGlobals = takesGlobals;
            return this;
        }

        public Builder setCallMatcher(Predicate<Call> callMatcher) {
            this.callMatcher = callMatcher;
            return this;
        }
    }
}

