/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.taint;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import proguard.analysis.cpa.bam.ExpandOperator;
import proguard.analysis.cpa.bam.ReduceOperator;
import proguard.analysis.cpa.defaults.SetAbstractState;
import proguard.analysis.cpa.defaults.SimpleCpa;
import proguard.analysis.cpa.interfaces.AbortOperator;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.jvm.cfa.JvmCfa;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCfaEdge;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.domain.reference.Reference;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintCpa;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintExpandOperator;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintReduceOperator;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintSource;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintTransformer;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.analysis.cpa.jvm.state.JvmFrameAbstractState;
import proguard.analysis.cpa.jvm.state.heap.HeapModel;
import proguard.analysis.cpa.jvm.state.heap.JvmForgetfulHeapAbstractState;
import proguard.analysis.cpa.jvm.util.JvmBamCpaRun;
import proguard.analysis.cpa.jvm.witness.JvmMemoryLocation;
import proguard.analysis.cpa.state.HashMapAbstractStateFactory;
import proguard.analysis.cpa.state.MapAbstractStateFactory;
import proguard.analysis.datastructure.callgraph.Call;
import proguard.classfile.MethodSignature;
import proguard.exception.ProguardCoreException;

public class JvmTaintBamCpaRun<OuterAbstractStateT extends AbstractState>
extends JvmBamCpaRun<SimpleCpa, SetAbstractState<JvmTaintSource>, OuterAbstractStateT> {
    private final Set<? extends JvmTaintSource> taintSources;
    private final MethodSignature mainMethodSignature;
    private final MapAbstractStateFactory<String, SetAbstractState<JvmTaintSource>> staticFieldMapAbstractStateFactory;
    private final MapAbstractStateFactory<String, SetAbstractState<Reference>> principalHeapNodeMapAbstractStateFactory;
    private final MapAbstractStateFactory<String, SetAbstractState<JvmTaintSource>> followerHeapNodeMapAbstractStateFactory;
    private final Map<MethodSignature, JvmTaintTransformer> taintTransformers;
    private final Map<Call, Set<JvmMemoryLocation>> extraTaintPropagationLocations;

    protected JvmTaintBamCpaRun(JvmCfa cfa, Set<? extends JvmTaintSource> taintSources, MethodSignature mainMethodSignature, int maxCallStackDepth, HeapModel heapModel, AbortOperator abortOperator, boolean reduceHeap, MapAbstractStateFactory<String, SetAbstractState<JvmTaintSource>> staticFieldMapAbstractStateFactory, MapAbstractStateFactory<String, SetAbstractState<Reference>> principalHeapNodeMapAbstractStateFactory, MapAbstractStateFactory<String, SetAbstractState<JvmTaintSource>> followerHeapNodeMapAbstractStateFactory, Map<MethodSignature, JvmTaintTransformer> taintTransformers, Map<Call, Set<JvmMemoryLocation>> extraTaintPropagationLocations) {
        super(cfa, maxCallStackDepth, heapModel, abortOperator, reduceHeap);
        this.taintSources = taintSources;
        this.mainMethodSignature = mainMethodSignature;
        this.staticFieldMapAbstractStateFactory = staticFieldMapAbstractStateFactory;
        this.principalHeapNodeMapAbstractStateFactory = principalHeapNodeMapAbstractStateFactory;
        this.followerHeapNodeMapAbstractStateFactory = followerHeapNodeMapAbstractStateFactory;
        this.taintTransformers = taintTransformers;
        this.extraTaintPropagationLocations = extraTaintPropagationLocations;
    }

    @Override
    public SimpleCpa createIntraproceduralCPA() {
        switch (this.heapModel) {
            case FORGETFUL: {
                return new JvmTaintCpa(this.taintSources, this.taintTransformers, this.extraTaintPropagationLocations);
            }
        }
        throw new ProguardCoreException.Builder("Heap model %s is not supported by %s", 9024).errorParameters(this.heapModel.name(), this.getClass().getName()).build();
    }

    @Override
    public ReduceOperator<JvmCfaNode, JvmCfaEdge, MethodSignature> createReduceOperator() {
        switch (this.heapModel) {
            case FORGETFUL: {
                return new JvmTaintReduceOperator(this.reduceHeap, JvmTaintCpa.createSourcesMap(this.taintSources));
            }
        }
        return super.createReduceOperator();
    }

    @Override
    public ExpandOperator<JvmCfaNode, JvmCfaEdge, MethodSignature> createExpandOperator() {
        JvmTaintExpandOperator jvmExpandOperator = new JvmTaintExpandOperator(this.cfa, JvmTaintCpa.createSourcesMap(this.taintSources), this.reduceHeap);
        switch (this.heapModel) {
            case FORGETFUL: {
                return jvmExpandOperator;
            }
        }
        throw new ProguardCoreException.Builder("Heap model %s is not supported by %s", 9025).errorParameters(this.heapModel.name(), this.getClass().getName()).build();
    }

    @Override
    public MethodSignature getMainSignature() {
        return this.mainMethodSignature;
    }

    @Override
    public Collection<OuterAbstractStateT> getInitialStates() {
        switch (this.heapModel) {
            case FORGETFUL: {
                return Collections.singleton(new JvmAbstractState<SetAbstractState<JvmTaintSource>>((JvmCfaNode)this.cfa.getFunctionEntryNode(this.mainMethodSignature), new JvmFrameAbstractState(), new JvmForgetfulHeapAbstractState<SetAbstractState>(SetAbstractState.bottom), this.staticFieldMapAbstractStateFactory.createMapAbstractState()));
            }
        }
        throw new ProguardCoreException.Builder("Invalid heap model: %s", 9026).errorParameters(this.heapModel.name()).build();
    }

    public static class Builder
    extends JvmBamCpaRun.Builder {
        protected MethodSignature mainSignature;
        protected Set<? extends JvmTaintSource> taintSources = Collections.emptySet();
        protected MapAbstractStateFactory<String, SetAbstractState<JvmTaintSource>> staticFieldMapAbstractStateFactory = HashMapAbstractStateFactory.getInstance();
        protected MapAbstractStateFactory<String, SetAbstractState<Reference>> principalHeapNodeMapAbstractStateFactory = HashMapAbstractStateFactory.getInstance();
        protected MapAbstractStateFactory<String, SetAbstractState<JvmTaintSource>> followerHeapNodeMapAbstractStateFactory = HashMapAbstractStateFactory.getInstance();
        protected Map<MethodSignature, JvmTaintTransformer> taintTransformers = Collections.emptyMap();
        protected Map<Call, Set<JvmMemoryLocation>> extraTaintPropagationLocations = Collections.emptyMap();

        @Override
        public JvmTaintBamCpaRun<?> build() {
            if (this.cfa == null || this.mainSignature == null) {
                throw new ProguardCoreException.Builder("CFA and the main signature must be set", 9027).build();
            }
            return new JvmTaintBamCpaRun(this.cfa, this.taintSources, this.mainSignature, this.maxCallStackDepth, this.heapModel, this.abortOperator, this.reduceHeap, this.staticFieldMapAbstractStateFactory, this.principalHeapNodeMapAbstractStateFactory, this.followerHeapNodeMapAbstractStateFactory, this.taintTransformers, this.extraTaintPropagationLocations);
        }

        @Override
        public Builder setMaxCallStackDepth(int maxCallStackDepth) {
            return (Builder)super.setMaxCallStackDepth(maxCallStackDepth);
        }

        @Override
        public Builder setAbortOperator(AbortOperator abortOperator) {
            return (Builder)super.setAbortOperator(abortOperator);
        }

        @Override
        public Builder setReduceHeap(boolean reduceHeap) {
            return (Builder)super.setReduceHeap(reduceHeap);
        }

        @Override
        public Builder setCfa(JvmCfa cfa) {
            return (Builder)super.setCfa(cfa);
        }

        @Override
        public Builder setHeapModel(HeapModel heapModel) {
            return (Builder)super.setHeapModel(heapModel);
        }

        public Builder setTaintSources(Set<? extends JvmTaintSource> taintSources) {
            this.taintSources = taintSources;
            return this;
        }

        public Builder setMainSignature(MethodSignature mainSignature) {
            this.mainSignature = mainSignature;
            return this;
        }

        public Builder setStaticFieldMapAbstractStateFactory(MapAbstractStateFactory<String, SetAbstractState<JvmTaintSource>> staticFieldMapAbstractStateFactory) {
            this.staticFieldMapAbstractStateFactory = staticFieldMapAbstractStateFactory;
            return this;
        }

        public Builder setPrincipalHeapNodeMapAbstractStateFactory(MapAbstractStateFactory<String, SetAbstractState<Reference>> principalHeapNodeMapAbstractStateFactory) {
            this.principalHeapNodeMapAbstractStateFactory = principalHeapNodeMapAbstractStateFactory;
            return this;
        }

        public Builder setFollowerHeapNodeMapAbstractStateFactory(MapAbstractStateFactory<String, SetAbstractState<JvmTaintSource>> followerHeapNodeMapAbstractStateFactory) {
            this.followerHeapNodeMapAbstractStateFactory = followerHeapNodeMapAbstractStateFactory;
            return this;
        }

        public Builder setTaintTransformers(Map<MethodSignature, JvmTaintTransformer> taintTransformers) {
            this.taintTransformers = taintTransformers;
            return this;
        }

        public Builder setExtraTaintPropagationLocations(Map<Call, Set<JvmMemoryLocation>> extraTaintPropagationLocations) {
            this.extraTaintPropagationLocations = extraTaintPropagationLocations;
            return this;
        }
    }
}

