/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.taint;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import proguard.analysis.cpa.defaults.MapAbstractState;
import proguard.analysis.cpa.defaults.SetAbstractState;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintAbstractState;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintSource;
import proguard.analysis.cpa.jvm.operators.JvmDefaultReduceOperator;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.analysis.cpa.jvm.state.JvmFrameAbstractState;
import proguard.analysis.cpa.jvm.state.heap.JvmHeapAbstractState;
import proguard.classfile.Signature;

public class JvmTaintReduceOperator
extends JvmDefaultReduceOperator<SetAbstractState<JvmTaintSource>> {
    private final Map<Signature, Set<JvmTaintSource>> taintSourcesTaintArgs;

    public JvmTaintReduceOperator(boolean reduceHeap) {
        super(reduceHeap);
        this.taintSourcesTaintArgs = new HashMap<Signature, Set<JvmTaintSource>>();
    }

    public JvmTaintReduceOperator(boolean reduceHeap, Map<Signature, Set<JvmTaintSource>> taintSources) {
        super(reduceHeap);
        this.taintSourcesTaintArgs = taintSources;
    }

    public JvmTaintAbstractState createJvmAbstractState(JvmCfaNode programLocation, JvmFrameAbstractState<SetAbstractState<JvmTaintSource>> frame, JvmHeapAbstractState<SetAbstractState<JvmTaintSource>> heap, MapAbstractState<String, SetAbstractState<JvmTaintSource>> staticFields) {
        return new JvmTaintAbstractState(programLocation, frame, heap, staticFields);
    }

    @Override
    public AbstractState onMethodEntry(AbstractState reducedState, boolean isCallStatic) {
        if (reducedState instanceof JvmAbstractState) {
            JvmAbstractState jvmAbstractState = (JvmAbstractState)reducedState;
            JvmFrameAbstractState<SetAbstractState<JvmTaintSource>> frame = jvmAbstractState.getFrame();
            JvmCfaNode programLocation = jvmAbstractState.getProgramLocation();
            if (this.taintSourcesTaintArgs.containsKey(programLocation.getSignature())) {
                this.taintSourcesTaintArgs.get(programLocation.getSignature()).forEach(source -> source.taintsArgs.forEach(index -> this.updateTaintState(frame, isCallStatic ? index - 1 : index, (JvmTaintSource)source)));
            }
            return new JvmTaintAbstractState(programLocation, frame, jvmAbstractState.getHeap(), jvmAbstractState.getStaticFields());
        }
        return reducedState;
    }

    private void updateTaintState(JvmFrameAbstractState<SetAbstractState<JvmTaintSource>> frame, int index, JvmTaintSource source) {
        SetAbstractState<JvmTaintSource> oldState = frame.getLocalVariables().getOrDefault(index, SetAbstractState.bottom);
        SetAbstractState<JvmTaintSource> newState = oldState.join(new SetAbstractState<JvmTaintSource>(source));
        frame.getLocalVariables().set(index, newState, SetAbstractState.bottom);
    }
}

