/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.value;

import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.analysis.cpa.defaults.LatticeAbstractState;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.evaluation.value.BasicValueFactory;
import proguard.evaluation.value.IdentifiedReferenceValue;
import proguard.evaluation.value.TypedReferenceValue;
import proguard.evaluation.value.Value;
import proguard.exception.ProguardCoreException;

public class ValueAbstractState
implements LatticeAbstractState<ValueAbstractState> {
    private static final Logger logger = LogManager.getLogger(ValueAbstractState.class);
    public static final ValueAbstractState UNKNOWN = new ValueAbstractState(BasicValueFactory.UNKNOWN_VALUE);
    private Value value;

    public ValueAbstractState(Value value) {
        this.value = value;
    }

    public Value getValue() {
        return this.value;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    @Override
    public ValueAbstractState join(ValueAbstractState abstractState) {
        if (this.value.computationalType() != abstractState.value.computationalType()) {
            return UNKNOWN;
        }
        ValueAbstractState result = abstractState.equals(this) ? this : new ValueAbstractState(this.value.generalize(abstractState.value));
        logger.trace("join({}, {}) = {}", (Object)this, (Object)abstractState, (Object)result);
        return result;
    }

    @Override
    public boolean isLessOrEqual(ValueAbstractState abstractState) {
        return abstractState == UNKNOWN || this.join(abstractState).equals(abstractState);
    }

    @Override
    public AbstractState copy() {
        return new ValueAbstractState(this.value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueAbstractState that = (ValueAbstractState)o;
        if (this.value.internalType() != null) {
            switch (this.value.internalType()) {
                case "Ljava/lang/String;": {
                    if (!this.value.isParticular() || !that.value.isParticular()) break;
                    Object stringA = this.value.referenceValue().value();
                    Object objectB = that.value.referenceValue().value();
                    return Objects.equals(stringA, objectB);
                }
                case "Ljava/lang/StringBuilder;": 
                case "Ljava/lang/StringBuffer;": {
                    if (this.value instanceof TypedReferenceValue && that.value instanceof TypedReferenceValue && ((TypedReferenceValue)this.value).isNull() == 1 && ((TypedReferenceValue)that.value).isNull() == 1) {
                        return true;
                    }
                    if (!this.value.isParticular() || !that.value.isParticular() || !(this.value instanceof IdentifiedReferenceValue) || !(that.value instanceof IdentifiedReferenceValue)) break;
                    Object idA = ((IdentifiedReferenceValue)this.value).id;
                    Object idB = ((IdentifiedReferenceValue)that.value).id;
                    Object objectA = this.value.referenceValue().value();
                    Object objectB = that.value.referenceValue().value();
                    if (objectA == null && objectB == null) {
                        throw new ProguardCoreException.Builder("This condition should already have been checked", 9031).build();
                    }
                    if (objectA == null || objectB == null) {
                        return false;
                    }
                    return idA.equals(idB) && objectA.toString().equals(objectB.toString());
                }
            }
        }
        return this.value.equals(that.value);
    }

    @Override
    public int hashCode() {
        if (this.value.internalType() != null) {
            switch (this.value.internalType()) {
                case "Ljava/lang/String;": {
                    if (!this.value.isParticular()) break;
                    return this.value.referenceValue().value().hashCode();
                }
                case "Ljava/lang/StringBuilder;": 
                case "Ljava/lang/StringBuffer;": {
                    if (!this.value.isSpecific()) break;
                    return Objects.hash(this.value.internalType(), ((IdentifiedReferenceValue)this.value).id);
                }
            }
        }
        return Objects.hash(this.value);
    }

    public String toString() {
        return "ValueAbstractState(" + this.value + ")";
    }
}

