/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.operators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import proguard.analysis.cpa.bam.ExpandOperator;
import proguard.analysis.cpa.defaults.LatticeAbstractState;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.interfaces.CallEdge;
import proguard.analysis.cpa.jvm.cfa.JvmCfa;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCfaEdge;
import proguard.analysis.cpa.jvm.cfa.edges.JvmInstructionCfaEdge;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCatchCfaNode;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.analysis.cpa.jvm.state.JvmAbstractStateFactory;
import proguard.analysis.cpa.jvm.state.JvmFrameAbstractState;
import proguard.analysis.cpa.jvm.state.heap.JvmHeapAbstractState;
import proguard.analysis.cpa.jvm.util.InstructionClassifier;
import proguard.analysis.datastructure.callgraph.Call;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.MethodSignature;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.instruction.Instruction;
import proguard.exception.ProguardCoreException;

public class JvmDefaultExpandOperator<StateT extends LatticeAbstractState<StateT>>
implements ExpandOperator<JvmCfaNode, JvmCfaEdge, MethodSignature>,
JvmAbstractStateFactory<StateT> {
    private final JvmCfa cfa;
    private final boolean expandHeap;

    public JvmDefaultExpandOperator(JvmCfa cfa) {
        this(cfa, true);
    }

    public JvmDefaultExpandOperator(JvmCfa cfa, boolean expandHeap) {
        this.cfa = cfa;
        this.expandHeap = expandHeap;
    }

    public JvmAbstractState<StateT> expand(AbstractState expandedInitialState, AbstractState reducedExitState, JvmCfaNode blockEntryNode, Call call) {
        if (!(expandedInitialState instanceof JvmAbstractState)) {
            throw new ProguardCoreException.Builder("The operator works on JVM states, states of type %s are not supported", 9032).errorParameters(expandedInitialState.getClass().getName()).build();
        }
        if (!(reducedExitState instanceof JvmAbstractState)) {
            throw new ProguardCoreException.Builder("The operator works on JVM states, states of type %s are not supported", 9033).errorParameters(reducedExitState.getClass().getName()).build();
        }
        JvmCfaNode exitNode = ((JvmAbstractState)reducedExitState).getProgramLocation();
        if (exitNode.isReturnExitNode()) {
            JvmCfaNode nextNode = ((JvmCfaNode)this.cfa.getFunctionNode((MethodSignature)call.caller.signature, call.caller.offset)).getLeavingEdges().stream().filter(edge -> !(edge instanceof CallEdge)).findFirst().get().getTarget();
            JvmAbstractState<StateT> returnState = this.createJvmAbstractState(nextNode, ((JvmAbstractState)expandedInitialState).getFrame().copy(), ((JvmAbstractState)reducedExitState).getHeap().copy(), ((JvmAbstractState)reducedExitState).getStaticFields().copy());
            int elementsToPop = call.getJvmArgumentSize();
            for (int i = 0; i < elementsToPop; ++i) {
                Object StateT = returnState.pop();
            }
            JvmCfaEdge returnEdge = exitNode.getEnteringEdges().get(0);
            if (!InstructionClassifier.isReturn(((JvmInstructionCfaEdge)returnEdge).getInstruction().opcode)) {
                throw new ProguardCoreException.Builder("The entering edges into the return node should be return instructions", 9038).build();
            }
            Instruction returnInstruction = ((JvmInstructionCfaEdge)returnEdge).getInstruction();
            returnState.pushAll(this.calculateReturnValues(reducedExitState, returnInstruction, call));
            if (this.expandHeap) {
                this.expandHeap(returnState.getHeap(), ((JvmAbstractState)expandedInitialState).getHeap());
            }
            return returnState;
        }
        if (exitNode.isExceptionExitNode()) {
            CallerExceptionHandlerFinder finder = new CallerExceptionHandlerFinder(call, this.cfa);
            call.caller.member.accept(call.caller.clazz, new AllAttributeVisitor(finder));
            JvmHeapAbstractState heap = ((JvmAbstractState)reducedExitState).getHeap();
            if (this.expandHeap) {
                this.expandHeap(heap, ((JvmAbstractState)expandedInitialState).getHeap());
            }
            JvmAbstractState returnState = this.createJvmAbstractState(finder.nextNode, new JvmFrameAbstractState(((JvmAbstractState)expandedInitialState).getFrame().getLocalVariables(), ((JvmAbstractState)reducedExitState).getFrame().getOperandStack()), heap, ((JvmAbstractState)reducedExitState).getStaticFields());
            return returnState;
        }
        throw new ProguardCoreException.Builder("The node of %s at offset %d is not an exit node", 9039).errorParameters(exitNode.getSignature(), exitNode.getOffset()).build();
    }

    protected List<StateT> calculateReturnValues(AbstractState reducedExitState, Instruction returnInstruction, Call call) {
        ArrayList returnValues = new ArrayList();
        for (int i = 0; i < returnInstruction.stackPopCount(null); ++i) {
            Object returnByte = ((JvmAbstractState)reducedExitState).peek(i);
            returnValues.add(0, returnByte);
        }
        return returnValues;
    }

    protected void expandHeap(JvmHeapAbstractState<StateT> heap, JvmHeapAbstractState<StateT> callerHeap) {
        heap.expand(callerHeap);
    }

    private class CallerExceptionHandlerFinder
    implements AttributeVisitor {
        private final Call call;
        private final JvmCfa cfa;
        public JvmCfaNode nextNode;

        public CallerExceptionHandlerFinder(Call call, JvmCfa cfa) {
            this.call = call;
            this.cfa = cfa;
        }

        @Override
        public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
        }

        @Override
        public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
            Optional<Object> firstCatch = Optional.empty();
            if (codeAttribute.exceptionTable != null) {
                firstCatch = Arrays.stream(codeAttribute.exceptionTable).filter(e -> e.isApplicable(this.call.caller.offset)).findFirst();
            }
            if (firstCatch.isPresent()) {
                JvmCatchCfaNode firstCatchNode = this.cfa.getFunctionCatchNode((MethodSignature)this.call.caller.signature, ((ExceptionInfo)firstCatch.get()).u2handlerPC);
                if (firstCatchNode == null) {
                    throw new ProguardCoreException.Builder("Missing expected catch node in CFA for method %s", 9040).errorParameters(this.call.caller.signature).build();
                }
                this.nextNode = firstCatchNode;
            } else {
                this.nextNode = this.cfa.getFunctionExceptionExitNode((MethodSignature)this.call.caller.signature, clazz);
            }
        }
    }
}

