/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.witness;

import java.util.Comparator;
import java.util.Objects;
import java.util.stream.Collectors;
import proguard.analysis.cpa.defaults.LatticeAbstractState;
import proguard.analysis.cpa.defaults.SetAbstractState;
import proguard.analysis.cpa.jvm.domain.reference.Reference;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.analysis.cpa.jvm.witness.JvmMemoryLocation;

public class JvmHeapLocation
extends JvmMemoryLocation {
    public final SetAbstractState<Reference> reference;
    public final String field;

    public JvmHeapLocation(SetAbstractState<Reference> reference, String field) {
        this.reference = reference;
        this.field = field;
    }

    @Override
    public <T extends LatticeAbstractState<T>> T extractValueOrDefault(JvmAbstractState<T> jvmState, T defaultValue) {
        return jvmState.getHeap().getFieldOrDefault(this.reference, this.field, (SetAbstractState<Reference>)defaultValue);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof JvmHeapLocation)) {
            return false;
        }
        JvmHeapLocation other = (JvmHeapLocation)obj;
        return this.reference.equals(other.reference);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.reference.hashCode());
    }

    @Override
    public String toString() {
        return "JvmHeapLocation(" + this.reference.stream().sorted(Comparator.comparingInt(Reference::hashCode)).collect(Collectors.toList()) + (this.field.length() > 0 ? ", " + this.field + ")" : "");
    }
}

