/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.witness;

import java.util.Objects;
import proguard.analysis.cpa.defaults.LatticeAbstractState;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.analysis.cpa.jvm.witness.JvmMemoryLocation;

public class JvmStackLocation
extends JvmMemoryLocation {
    public final int index;

    public JvmStackLocation(int index) {
        this.index = index;
    }

    @Override
    public <T extends LatticeAbstractState<T>> T extractValueOrDefault(JvmAbstractState<T> jvmState, T defaultValue) {
        return jvmState.peekOrDefault(this.index, defaultValue);
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof JvmStackLocation)) {
            return false;
        }
        JvmStackLocation other = (JvmStackLocation)obj;
        return this.index == other.index;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.index);
    }

    @Override
    public String toString() {
        return "JvmStackLocation(" + this.index + ")";
    }
}

