/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.executor;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import proguard.classfile.ClassConstants;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.MethodSignature;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassVisitor;
import proguard.evaluation.MethodResult;
import proguard.evaluation.ValueCalculator;
import proguard.evaluation.executor.Executor;
import proguard.evaluation.executor.MethodExecutionInfo;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TypedReferenceValue;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.object.model.ClassModel;
import proguard.exception.ProguardCoreException;

public class JavaReflectionApiExecutor
implements Executor {
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final Set<MethodSignature> supportedMethodSignatures;

    private JavaReflectionApiExecutor(ClassPool programClassPool, ClassPool libraryClassPool) {
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
        this.supportedMethodSignatures = new HashSet<MethodSignature>(Arrays.asList(ClassConstants.CLASS_GET_NAME_SIGNATURE, ClassConstants.CLASS_GET_SIMPLE_NAME_SIGNATURE, ClassConstants.CLASS_GET_TYPE_NAME_SIGNATURE, ClassConstants.CLASS_GET_PACKAGE_NAME_SIGNATURE, ClassConstants.CLASS_GET_SUPERCLASS_SIGNATURE, ClassConstants.CLASS_GET_CANONICAL_NAME_SIGNATURE, ClassConstants.CLASSLOADER_LOAD_CLASS_SIGNATURE, ClassConstants.CLASSLOADER_LOAD_CLASS_SIGNATURE2, ClassConstants.CLASSLOADER_FIND_LOADED_CLASS_SIGNATURE, ClassConstants.CLASS_FOR_NAME_SIGNATURE, ClassConstants.CLASS_FOR_NAME_SIGNATURE2));
        ClassVisitor getClassSignatureCollector = clazz -> this.supportedMethodSignatures.add(new MethodSignature(clazz.getName(), "getClass", "()Ljava/lang/Class;"));
        programClassPool.classesAccept(getClassSignatureCollector);
        libraryClassPool.classesAccept(getClassSignatureCollector);
    }

    @Override
    public MethodResult getMethodResult(MethodExecutionInfo methodExecutionInfo, ValueCalculator valueCalculator) {
        TypedReferenceValue typedInstance;
        ReferenceValue instance;
        MethodSignature target = methodExecutionInfo.getSignature();
        if (target.equals(ClassConstants.CLASS_FOR_NAME_SIGNATURE) || target.equals(ClassConstants.CLASS_FOR_NAME_SIGNATURE2) || target.equals(ClassConstants.CLASSLOADER_LOAD_CLASS_SIGNATURE) || target.equals(ClassConstants.CLASSLOADER_LOAD_CLASS_SIGNATURE2) || target.equals(ClassConstants.CLASSLOADER_FIND_LOADED_CLASS_SIGNATURE)) {
            Value className = methodExecutionInfo.getParameters().get(0);
            if (!className.isParticular()) {
                return MethodResult.invalidResult();
            }
            Optional<Clazz> clazz = this.findReferencedClazz((String)className.referenceValue().getValue().getPreciseValue());
            if (clazz.isPresent()) {
                return JavaReflectionApiExecutor.createResult(methodExecutionInfo, valueCalculator, new ClassModel(clazz.get()));
            }
            return MethodResult.invalidResult();
        }
        if ("getClass".equals(target.getMethodName())) {
            instance = methodExecutionInfo.getInstanceNonStatic();
            if (!(instance instanceof TypedReferenceValue)) {
                return MethodResult.invalidResult();
            }
            typedInstance = (TypedReferenceValue)instance;
            if (typedInstance.getType() == null) {
                return MethodResult.invalidResult();
            }
            Optional<Clazz> clazz = this.findReferencedClazz(ClassUtil.internalClassNameFromType(typedInstance.getType()));
            if (clazz.isPresent()) {
                return JavaReflectionApiExecutor.createResult(methodExecutionInfo, valueCalculator, new ClassModel(clazz.get()));
            }
        }
        if (target.equals(ClassConstants.CLASS_GET_NAME_SIGNATURE) || target.equals(ClassConstants.CLASS_GET_TYPE_NAME_SIGNATURE) || target.equals(ClassConstants.CLASS_GET_SIMPLE_NAME_SIGNATURE) || target.equals(ClassConstants.CLASS_GET_CANONICAL_NAME_SIGNATURE) || target.equals(ClassConstants.CLASS_GET_PACKAGE_NAME_SIGNATURE) || target.equals(ClassConstants.CLASS_GET_SUPERCLASS_SIGNATURE)) {
            instance = methodExecutionInfo.getInstanceNonStatic();
            if (!(instance instanceof TypedReferenceValue)) {
                return MethodResult.invalidResult();
            }
            typedInstance = (TypedReferenceValue)instance;
            if (!typedInstance.isParticular() || typedInstance.isNull() == 1) {
                return MethodResult.invalidResult();
            }
            ClassModel modeledValue = (ClassModel)typedInstance.referenceValue().getValue().getModeledValue();
            if (modeledValue.getClazz() == null) {
                return MethodResult.invalidResult();
            }
            String externalClassName = ClassUtil.externalClassName(modeledValue.getClazz().getName());
            Object concreteValue = null;
            if (target.equals(ClassConstants.CLASS_GET_NAME_SIGNATURE) || target.equals(ClassConstants.CLASS_GET_TYPE_NAME_SIGNATURE)) {
                concreteValue = externalClassName;
            } else if (target.equals(ClassConstants.CLASS_GET_SIMPLE_NAME_SIGNATURE)) {
                concreteValue = ClassUtil.internalSimpleClassName(modeledValue.getClazz().getName());
            } else if (target.equals(ClassConstants.CLASS_GET_CANONICAL_NAME_SIGNATURE)) {
                concreteValue = ClassUtil.canonicalClassName(externalClassName);
            } else if (target.equals(ClassConstants.CLASS_GET_PACKAGE_NAME_SIGNATURE)) {
                concreteValue = ClassUtil.externalPackageName(externalClassName);
            } else if (target.equals(ClassConstants.CLASS_GET_SUPERCLASS_SIGNATURE)) {
                concreteValue = new ClassModel(modeledValue.getClazz().getSuperClass());
            }
            return JavaReflectionApiExecutor.createResult(methodExecutionInfo, valueCalculator, concreteValue);
        }
        throw new ProguardCoreException(9047, String.format("%s is not a supported method signature.", methodExecutionInfo.getSignature()), new Object[0]);
    }

    @Override
    public Set<MethodSignature> getSupportedMethodSignatures() {
        return this.supportedMethodSignatures;
    }

    private Optional<Clazz> findReferencedClazz(@Nullable String className) {
        if (className == null) {
            return Optional.empty();
        }
        Clazz result = this.programClassPool.getClass(className = ClassUtil.internalClassName(className));
        return result != null ? Optional.of(result) : Optional.ofNullable(this.libraryClassPool.getClass(className));
    }

    private static MethodResult createResult(MethodExecutionInfo executionInfo, ValueCalculator valueCalculator, @Nullable Object concreteValue) {
        Value returnValue = valueCalculator.apply(executionInfo.getReturnType(), executionInfo.getReturnClass(), true, concreteValue, false, null);
        return new MethodResult.Builder().setReturnValue(returnValue).build();
    }

    public static class Builder
    implements Executor.Builder<JavaReflectionApiExecutor> {
        private final ClassPool programClassPool;
        private final ClassPool libraryClassPool;
        private JavaReflectionApiExecutor javaReflectionApiExecutor = null;

        public Builder(@NotNull ClassPool programClassPool, @NotNull ClassPool libraryClassPool) {
            this.programClassPool = programClassPool;
            this.libraryClassPool = libraryClassPool;
        }

        @Override
        public JavaReflectionApiExecutor build() {
            if (this.javaReflectionApiExecutor == null) {
                this.javaReflectionApiExecutor = new JavaReflectionApiExecutor(this.programClassPool, this.libraryClassPool);
            }
            return this.javaReflectionApiExecutor;
        }
    }
}

