/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.executor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import proguard.analysis.datastructure.CodeLocation;
import proguard.analysis.datastructure.callgraph.ConcreteCall;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.MethodSignature;
import proguard.classfile.Signature;
import proguard.classfile.constant.AnyMethodrefConstant;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ReferencedClassesExtractor;
import proguard.evaluation.value.IdentifiedReferenceValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.Value;

public class MethodExecutionInfo {
    private final MethodSignature signature;
    private final CodeLocation caller;
    private final boolean isConstructor;
    private final boolean isStatic;
    @NotNull
    private final Clazz targetClass;
    private final Clazz returnClass;
    private final List<Clazz> parametersClasses;
    @Nullable
    private final ReferenceValue instance;
    private final List<Value> parameters;
    @Nullable
    private MethodSignature resolvedTargetSignature = null;

    public MethodExecutionInfo(@NotNull Clazz clazz, @NotNull Method method, @Nullable CodeLocation caller, Value ... parameters) {
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(method);
        Objects.requireNonNull(parameters);
        this.targetClass = clazz;
        this.signature = (MethodSignature)Signature.of(clazz, method);
        this.caller = caller;
        this.isConstructor = this.signature.method.equals("<init>");
        this.isStatic = (method.getAccessFlags() & 8) != 0;
        ReferencedClassesExtractor referencedClassesExtractor = new ReferencedClassesExtractor();
        method.accept(clazz, referencedClassesExtractor);
        this.returnClass = referencedClassesExtractor.getReturnClass();
        this.parametersClasses = Collections.unmodifiableList(Arrays.asList(referencedClassesExtractor.getParameterClasses()));
        ReferenceValue instanceParameter = null;
        if (!this.isStatic) {
            Value instanceValue = parameters[0];
            if (!(instanceValue instanceof ReferenceValue)) {
                throw new IllegalArgumentException("Methods should not be executed with ExecutingInvocationUnit if the instance is unknown");
            }
            instanceParameter = parameters[0].referenceValue();
        }
        int parametersOffset = this.isStatic ? 0 : 1;
        List nonInstanceParameters = Arrays.stream(parameters).skip(parametersOffset).collect(Collectors.toList());
        this.instance = instanceParameter;
        this.parameters = Collections.unmodifiableList(nonInstanceParameters);
        if (this.parametersClasses.size() != this.parameters.size()) {
            throw new IllegalStateException("parametersClasses should be the same size as the non-instance parameters");
        }
    }

    public MethodExecutionInfo(AnyMethodrefConstant anyMethodrefConstant, CodeLocation caller, Value ... parameters) {
        this(anyMethodrefConstant.referencedClass, anyMethodrefConstant.referencedMethod, caller, parameters);
    }

    public MethodExecutionInfo(ConcreteCall call, Value ... parameters) {
        this(call.getTargetClass(), call.getTargetMethod(), call.caller, parameters);
    }

    public MethodSignature getSignature() {
        return this.signature;
    }

    @Nullable
    public CodeLocation getCaller() {
        return this.caller;
    }

    public boolean isConstructor() {
        return this.isConstructor;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isInstanceMethod() {
        return !this.isConstructor && !this.isStatic;
    }

    @Nullable
    public Clazz getReturnClass() {
        return this.returnClass;
    }

    public List<Clazz> getParametersClasses() {
        return this.parametersClasses;
    }

    @NotNull
    public Clazz getTargetClass() {
        return this.targetClass;
    }

    @NotNull
    public String getTargetType() {
        return ClassUtil.internalMethodReturnType(ClassUtil.internalTypeFromClassName(this.targetClass.getName()));
    }

    public String getReturnType() {
        return ClassUtil.internalMethodReturnType(this.signature.descriptor.toString());
    }

    public Optional<String> getInstanceType() {
        return this.instance != null ? Optional.of(this.instance.internalType()) : Optional.empty();
    }

    public boolean returnsSameTypeAsInstance() {
        if (!this.isInstanceMethod()) {
            return false;
        }
        Optional<String> instanceType = this.getInstanceType();
        if (!instanceType.isPresent()) {
            throw new IllegalStateException("Instance type should be present for instance methods");
        }
        return instanceType.get().equals(this.getReturnType());
    }

    public boolean returnsVoid() {
        return this.getReturnType().charAt(0) == 'V';
    }

    @NotNull
    public ReferenceValue getInstanceNonStatic() {
        if (this.isStatic) {
            throw new IllegalStateException("Do not try to retrieve the instance of a static method");
        }
        Objects.requireNonNull(this.instance);
        return this.instance;
    }

    @NotNull
    public IdentifiedReferenceValue getSpecificInstance() {
        if (this.isStatic) {
            throw new IllegalStateException("Do not try to retrieve the instance of a static method");
        }
        Objects.requireNonNull(this.instance);
        if (!this.instance.isSpecific()) {
            throw new IllegalStateException("You should not use this method for instances that might be non specific");
        }
        Objects.requireNonNull(this.instance);
        return (IdentifiedReferenceValue)this.instance;
    }

    @Nullable
    public ReferenceValue getInstanceOrNullIfStatic() {
        return this.instance;
    }

    public List<Value> getParameters() {
        return this.parameters;
    }

    public MethodSignature getResolvedTargetSignature() {
        if (this.resolvedTargetSignature == null) {
            throw new IllegalStateException("The dynamic target signature has not been initialized yet");
        }
        return this.resolvedTargetSignature;
    }

    public void setResolvedTargetSignature(@NotNull MethodSignature resolvedTargetSignature) {
        Objects.requireNonNull(resolvedTargetSignature);
        this.resolvedTargetSignature = resolvedTargetSignature;
    }
}

