/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value.object.model;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import proguard.classfile.Clazz;
import proguard.evaluation.MethodResult;
import proguard.evaluation.ValueCalculator;
import proguard.evaluation.executor.MethodExecutionInfo;
import proguard.evaluation.value.object.model.reflective.ModelHelper;
import proguard.evaluation.value.object.model.reflective.ModeledInstanceMethod;
import proguard.evaluation.value.object.model.reflective.ReflectiveModel;

public class ClassModel
implements ReflectiveModel<ClassModel> {
    private final Clazz clazz;

    private ClassModel() {
        this.clazz = null;
    }

    public ClassModel(Clazz clazz) {
        this.clazz = clazz;
    }

    @Override
    @NotNull
    public String getType() {
        return "Ljava/lang/Class;";
    }

    @Override
    public MethodResult init(MethodExecutionInfo methodExecutionInfo, ValueCalculator valueCalculator) {
        throw new UnsupportedOperationException("Constructors invocation is not supported in ClassModel");
    }

    @Override
    public MethodResult invokeStatic(MethodExecutionInfo methodExecutionInfo, ValueCalculator valueCalculator) {
        throw new UnsupportedOperationException("Static method invocation is not supported in ClassModel");
    }

    @ModeledInstanceMethod(name="getSuperclass", descriptor="()Ljava/lang/Class;")
    private MethodResult getSuperclass(ModelHelper.MethodExecutionContext context) {
        if (this.clazz == null) {
            return MethodResult.invalidResult();
        }
        Clazz superClass = this.clazz.getSuperClass();
        if (superClass == null) {
            return MethodResult.invalidResult();
        }
        return ModelHelper.createDefaultReturnResult(context, new ClassModel(this.clazz.getSuperClass()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassModel that = (ClassModel)o;
        return Objects.equals(this.clazz, that.clazz);
    }

    public int hashCode() {
        return Objects.hashCode(this.clazz);
    }

    public String toString() {
        return String.format("ClassModel{%s}", this.clazz.getName());
    }

    public Clazz getClazz() {
        return this.clazz;
    }
}

