/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis;

import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import proguard.analysis.Metrics;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.MethodSignature;
import proguard.classfile.constant.AnyMethodrefConstant;

public class CallUtil {
    private CallUtil() {
    }

    public static Set<String> resolveVirtual(Clazz callingClass, Clazz thisPointerType, AnyMethodrefConstant ref) {
        return CallUtil.resolveVirtual(thisPointerType, ref.getName(callingClass), ref.getType(callingClass));
    }

    public static Set<String> resolveVirtual(Clazz thisPointerType, String methodName, String descriptor) {
        if (thisPointerType == null) {
            return Collections.emptySet();
        }
        return CallUtil.resolveFromSuperclasses(thisPointerType, methodName, descriptor).map(Collections::singleton).orElseGet(() -> CallUtil.resolveFromSuperinterfaces(thisPointerType, methodName, descriptor));
    }

    public static Set<MethodSignature> resolveVirtualSignatures(Clazz thisPointerType, String methodName, String descriptor) {
        return CallUtil.resolveVirtual(thisPointerType, methodName, descriptor).stream().map(className -> new MethodSignature((String)className, methodName, descriptor)).collect(Collectors.toSet());
    }

    public static Optional<String> resolveFromSuperclasses(Clazz start, String name, String descriptor) {
        for (Clazz curr = start; curr != null; curr = curr.getSuperClass()) {
            Method targetMethod = curr.findMethod(name, descriptor);
            if (targetMethod == null || (targetMethod.getAccessFlags() & 0x400) != 0) continue;
            return Optional.of(curr.getName());
        }
        return Optional.empty();
    }

    public static Set<String> resolveFromSuperinterfaces(Clazz start, String name, String descriptor) {
        HashSet<Clazz> superInterfaces = new HashSet<Clazz>();
        CallUtil.getSuperinterfaces(start, superInterfaces);
        Set applicableInterfaces = superInterfaces.stream().filter(i -> {
            Method m = i.findMethod(name, descriptor);
            return m != null && (m.getAccessFlags() & 0x40A) == 0;
        }).collect(Collectors.toSet());
        for (Clazz iface : new HashSet(applicableInterfaces)) {
            superInterfaces.clear();
            CallUtil.getSuperinterfaces(iface, superInterfaces);
            superInterfaces.forEach(applicableInterfaces::remove);
        }
        return applicableInterfaces.stream().map(Clazz::getName).collect(Collectors.toSet());
    }

    public static void getSuperinterfaces(Clazz start, Set<Clazz> accumulator) {
        for (int i = 0; i < start.getInterfaceCount(); ++i) {
            Clazz iface = start.getInterface(i);
            if (iface == null) {
                Metrics.increaseCount(Metrics.MetricType.MISSING_CLASS);
                continue;
            }
            accumulator.add(iface);
            CallUtil.getSuperinterfaces(iface, accumulator);
        }
        if (start.getSuperClass() != null) {
            CallUtil.getSuperinterfaces(start.getSuperClass(), accumulator);
        }
    }
}

