/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.cfa;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import proguard.analysis.cpa.defaults.Cfa;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCallCfaEdge;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCfaEdge;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCatchCfaNode;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmUnknownCfaNode;
import proguard.analysis.datastructure.callgraph.Call;
import proguard.analysis.datastructure.callgraph.ConcreteCall;
import proguard.classfile.Clazz;
import proguard.classfile.MethodSignature;

public class JvmCfa
extends Cfa<JvmCfaNode, JvmCfaEdge, MethodSignature> {
    private final Map<MethodSignature, Map<Integer, JvmCatchCfaNode>> functionCatchNodes = new HashMap<MethodSignature, Map<Integer, JvmCatchCfaNode>>();

    @Override
    public Stream<JvmCfaNode> getAllNodes() {
        return Stream.of(this.functionNodes.values(), this.functionCatchNodes.values()).flatMap(Collection::stream).flatMap(it -> it.values().stream());
    }

    public Collection<JvmCatchCfaNode> getFunctionCatchNodes(MethodSignature signature) {
        return this.functionCatchNodes.getOrDefault(signature, Collections.emptyMap()).values();
    }

    public JvmCatchCfaNode getFunctionCatchNode(MethodSignature signature, int offset) {
        return this.functionCatchNodes.getOrDefault(signature, Collections.emptyMap()).getOrDefault(offset, null);
    }

    public void addFunctionCatchNode(MethodSignature signature, JvmCatchCfaNode node, int offset) {
        this.functionCatchNodes.computeIfAbsent(signature, x -> new HashMap()).put(offset, node);
    }

    public boolean containsFunctionCatchNode(MethodSignature signature, int offset) {
        return this.functionCatchNodes.containsKey(signature) && this.functionCatchNodes.get(signature).containsKey(offset);
    }

    public JvmCfaNode getFunctionReturnExitNode(MethodSignature signature, Clazz clazz) {
        JvmCfaNode exitNode = (JvmCfaNode)this.getFunctionNode(signature, -1);
        if (exitNode == null) {
            exitNode = new JvmCfaNode(signature, -1, clazz);
            this.addFunctionNode(signature, exitNode, -1);
        }
        return exitNode;
    }

    public JvmCfaNode getFunctionExceptionExitNode(MethodSignature signature, Clazz clazz) {
        JvmCfaNode exitNode = (JvmCfaNode)this.getFunctionNode(signature, -2);
        if (exitNode == null) {
            exitNode = new JvmCfaNode(signature, -2, clazz);
            this.addFunctionNode(signature, exitNode, -2);
        }
        return exitNode;
    }

    public JvmCfaNode addNodeIfAbsent(MethodSignature signature, int offset, Clazz clazz) {
        JvmCfaNode node = (JvmCfaNode)this.getFunctionNode(signature, offset);
        if (node == null) {
            node = new JvmCfaNode(signature, offset, clazz);
            if (offset == 0) {
                this.addFunctionEntryNode(signature, node);
            } else {
                this.addFunctionNode(signature, node, offset);
            }
        }
        return node;
    }

    public void addInterproceduralEdge(Call call) {
        JvmCfaNode callNode = this.addNodeIfAbsent((MethodSignature)call.caller.signature, call.caller.offset, call.caller.clazz);
        JvmCfaNode calledNode = this.addNodeIfAbsent(call.getTarget(), 0, call instanceof ConcreteCall ? ((ConcreteCall)call).getTargetClass() : null);
        new JvmCallCfaEdge(callNode, calledNode, call);
    }

    public void addUnknownTargetInterproceduralEdge(Call call) {
        JvmCfaNode callNode = this.addNodeIfAbsent((MethodSignature)call.caller.signature, call.caller.offset, call.caller.clazz);
        JvmUnknownCfaNode calledNode = JvmUnknownCfaNode.INSTANCE;
        new JvmCallCfaEdge(callNode, calledNode, call);
    }

    public void clear() {
        List<JvmCfaEdge> unknownEnteringEdges = JvmUnknownCfaNode.INSTANCE.getEnteringEdges();
        if (!unknownEnteringEdges.isEmpty()) {
            Set edges = this.getAllNodes().flatMap(it -> it.getLeavingEdges().stream()).filter(e -> e.getTarget() == JvmUnknownCfaNode.INSTANCE).collect(Collectors.toSet());
            unknownEnteringEdges.removeAll(edges);
        }
        this.functionCatchNodes.clear();
        this.functionNodes.clear();
    }
}

