/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.memory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.analysis.cpa.bam.BamCache;
import proguard.analysis.cpa.bam.BamCpa;
import proguard.analysis.cpa.bam.BlockAbstraction;
import proguard.analysis.cpa.bam.ExpandOperator;
import proguard.analysis.cpa.bam.ReduceOperator;
import proguard.analysis.cpa.defaults.ProgramLocationDependentReachedSet;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.interfaces.CallEdge;
import proguard.analysis.cpa.interfaces.Precision;
import proguard.analysis.cpa.interfaces.TransferRelation;
import proguard.analysis.cpa.jvm.cfa.JvmCfa;
import proguard.analysis.cpa.jvm.cfa.edges.JvmAssumeExceptionCfaEdge;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCallCfaEdge;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCfaEdge;
import proguard.analysis.cpa.jvm.cfa.edges.JvmInstructionCfaEdge;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmUnknownCfaNode;
import proguard.analysis.cpa.jvm.domain.memory.JvmMemoryLocationAbstractState;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.analysis.cpa.jvm.util.ConstantLookupVisitor;
import proguard.analysis.cpa.jvm.util.InstructionClassifier;
import proguard.analysis.cpa.jvm.witness.JvmLocalVariableLocation;
import proguard.analysis.cpa.jvm.witness.JvmMemoryLocation;
import proguard.analysis.cpa.jvm.witness.JvmStackLocation;
import proguard.analysis.cpa.jvm.witness.JvmStaticFieldLocation;
import proguard.analysis.datastructure.callgraph.Call;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.exception.ProguardCoreException;

public class JvmMemoryLocationTransferRelation<ContentT extends AbstractState<ContentT>>
implements TransferRelation<JvmMemoryLocationAbstractState<ContentT>> {
    private static final Logger log = LogManager.getLogger(JvmMemoryLocationTransferRelation.class);
    private final ContentT threshold;
    private final JvmCfa cfa;
    private final BamCache<ContentT> cache;
    private final ReduceOperator<ContentT> tracedCpaReduceOperator;
    private final ExpandOperator<ContentT> tracedCpaExpandOperator;
    private final Map<Call, Set<JvmMemoryLocation>> extraTaintPropagationLocations;

    public JvmMemoryLocationTransferRelation(ContentT threshold, BamCpa<ContentT> bamCpa, Map<Call, Set<JvmMemoryLocation>> extraTaintPropagationLocations) {
        this.threshold = threshold;
        this.cfa = bamCpa.getCfa();
        this.cache = bamCpa.getCache();
        this.tracedCpaReduceOperator = bamCpa.getReduceOperator();
        this.tracedCpaExpandOperator = bamCpa.getExpandOperator();
        this.extraTaintPropagationLocations = extraTaintPropagationLocations;
    }

    @Override
    public Collection<JvmMemoryLocationAbstractState<ContentT>> generateAbstractSuccessors(JvmMemoryLocationAbstractState<ContentT> abstractState, Precision precision) {
        AbstractState state = abstractState.copy();
        JvmCfaNode programLocation = ((JvmMemoryLocationAbstractState)state).getProgramLocation();
        Collection<JvmCfaEdge> intraproceduralEdges = programLocation.getEnteringIntraproceduralEdges();
        ArrayList<JvmMemoryLocationAbstractState<ContentT>> successors = new ArrayList<JvmMemoryLocationAbstractState<ContentT>>();
        if (!intraproceduralEdges.isEmpty()) {
            for (JvmCfaEdge edge : intraproceduralEdges) {
                JvmCfaNode intraproceduralParentNode = edge.getSource();
                Optional intraproceduralParentState = this.getAnalysisAbstractState(((JvmMemoryLocationAbstractState)state).getSourceReachedSet(), intraproceduralParentNode);
                if (!intraproceduralParentState.isPresent()) continue;
                Collection<JvmCallCfaEdge> interproceduralCallEdges = intraproceduralParentNode.getKnownMethodCallEdges();
                boolean shouldAnalyzeIntraproceduralCallEdge = intraproceduralParentNode.getLeavingEdges().stream().anyMatch(e -> e instanceof JvmCallCfaEdge && e.getTarget() instanceof JvmUnknownCfaNode);
                boolean interproceduralSuccessorFound = false;
                if (!(((JvmMemoryLocationAbstractState)state).getLocationDependentMemoryLocation().getMemoryLocation() instanceof JvmLocalVariableLocation)) {
                    JvmAbstractState currentState = this.getAnalysisAbstractState(((JvmMemoryLocationAbstractState)state).getSourceReachedSet(), programLocation).get();
                    for (JvmCallCfaEdge callEdge2 : interproceduralCallEdges) {
                        if (((JvmMemoryLocationAbstractState)state).callStackContains(callEdge2.getTarget().getSignature())) {
                            shouldAnalyzeIntraproceduralCallEdge = true;
                            continue;
                        }
                        JvmAbstractState<ContentT> reducedEntryState = this.tracedCpaReduceOperator.reduce(intraproceduralParentState.get(), callEdge2.getTarget(), callEdge2.getCall());
                        BlockAbstraction<ContentT> calleeAbstraction = this.cache.get(reducedEntryState, precision, callEdge2.getTarget().getSignature());
                        if (calleeAbstraction != null) {
                            JvmStackLocation stackLocation;
                            int index;
                            if (((JvmMemoryLocationAbstractState)state).getLocationDependentMemoryLocation().getMemoryLocation() instanceof JvmStackLocation && (index = (stackLocation = (JvmStackLocation)((JvmMemoryLocationAbstractState)state).getLocationDependentMemoryLocation().getMemoryLocation()).getIndex()) > ClassUtil.internalTypeSize(callEdge2.getTarget().getSignature().descriptor.returnType)) continue;
                            JvmCfaNode calleeExitNode = this.cfa.getFunctionReturnExitNode(callEdge2.getTarget().getSignature(), callEdge2.getTarget().getClazz());
                            Optional<JvmAbstractState<ContentT>> returnState = this.getAnalysisAbstractState(calleeAbstraction.getReachedSet(), calleeExitNode);
                            if (!returnState.isPresent()) {
                                shouldAnalyzeIntraproceduralCallEdge = true;
                                continue;
                            }
                            ContentT value = ((JvmMemoryLocationAbstractState)state).getLocationDependentMemoryLocation().getMemoryLocation().extractValueOrDefault(returnState.get(), this.threshold);
                            if (value.isLessOrEqual(this.threshold) || !this.tracedCpaExpandOperator.expand(intraproceduralParentState.get(), returnState.get(), callEdge2.getTarget(), callEdge2.getCall()).isLessOrEqual(currentState)) continue;
                            LinkedList callStack = ((JvmMemoryLocationAbstractState)state).copyStack();
                            callStack.push(new JvmMemoryLocationAbstractState.StackEntry(calleeExitNode.getSignature(), ((JvmMemoryLocationAbstractState)state).getSourceReachedSet(), intraproceduralParentState.get()));
                            JvmMemoryLocation successorLocation = ((JvmMemoryLocationAbstractState)state).getLocationDependentMemoryLocation().getMemoryLocation();
                            successors.add(new JvmMemoryLocationAbstractState<ContentT>(successorLocation, calleeExitNode, calleeAbstraction.getReachedSet(), callStack));
                            interproceduralSuccessorFound = true;
                            continue;
                        }
                        shouldAnalyzeIntraproceduralCallEdge = true;
                    }
                }
                if (!interproceduralSuccessorFound) {
                    shouldAnalyzeIntraproceduralCallEdge = true;
                }
                ArrayList<JvmMemoryLocation> intraproceduralSuccessorMemoryLocations = new ArrayList<JvmMemoryLocation>();
                if (edge instanceof JvmInstructionCfaEdge && (!InstructionClassifier.isInvoke(((JvmInstructionCfaEdge)edge).getInstruction().opcode) || shouldAnalyzeIntraproceduralCallEdge)) {
                    intraproceduralSuccessorMemoryLocations.addAll(this.getSuccessorMemoryLocationsForInstruction((JvmMemoryLocationAbstractState<ContentT>)state, intraproceduralParentState.get(), ((JvmInstructionCfaEdge)edge).getInstruction(), ((JvmMemoryLocationAbstractState)state).getProgramLocation().getClazz(), ((JvmMemoryLocationAbstractState)state).getProgramLocation().getSignature().getReferencedMethod(), ((JvmMemoryLocationAbstractState)state).getProgramLocation().getOffset()));
                } else if (edge instanceof JvmAssumeExceptionCfaEdge) {
                    intraproceduralSuccessorMemoryLocations.add(((JvmMemoryLocationAbstractState)state).getLocationDependentMemoryLocation().getMemoryLocation());
                }
                successors.addAll(this.getSuccessorsFromMemoryLocations(intraproceduralSuccessorMemoryLocations, intraproceduralParentState.get(), ((JvmMemoryLocationAbstractState)state).getSourceReachedSet(), ((JvmMemoryLocationAbstractState)state).copyStack()));
            }
        }
        if (programLocation.isEntryNode()) {
            JvmMemoryLocationAbstractState.StackEntry currentEntry = ((JvmMemoryLocationAbstractState)state).peekCallStack();
            Optional<JvmMemoryLocation> callerMemoryLocation = this.createCallerLocation((JvmMemoryLocationAbstractState<ContentT>)state);
            if (callerMemoryLocation.isPresent()) {
                if (currentEntry == null) {
                    Optional calledState = this.getAnalysisAbstractState(((JvmMemoryLocationAbstractState)state).getSourceReachedSet(), programLocation);
                    if (!calledState.isPresent()) {
                        return Collections.emptyList();
                    }
                    programLocation.getEnteringEdges().stream().filter(CallEdge.class::isInstance).map(callEdge -> this.getCallersInfo((JvmCallCfaEdge)callEdge, programLocation, (JvmAbstractState)calledState.get())).flatMap(Collection::stream).forEach(callerInfo -> this.getSuccessorsFromMemoryLocations(Collections.singletonList(callerMemoryLocation.get()), callerInfo.state, callerInfo.reachedSet, new LinkedList<JvmMemoryLocationAbstractState.StackEntry<ContentT>>()).stream().findFirst().ifPresent(successors::add));
                } else {
                    LinkedList successorStack = ((JvmMemoryLocationAbstractState)state).copyStack();
                    successorStack.pop();
                    successors.addAll(this.getSuccessorsFromMemoryLocations(Collections.singletonList(callerMemoryLocation.get()), currentEntry.callerState, currentEntry.reachedSet, successorStack));
                }
            }
        }
        successors.forEach(successor -> abstractState.addSourceLocation(successor.getLocationDependentMemoryLocation()));
        return successors;
    }

    protected List<JvmMemoryLocation> processCall(JvmMemoryLocation memoryLocation, ConstantInstruction callInstruction, Clazz clazz, JvmCfaNode parentNode) {
        ArrayList<JvmMemoryLocation> successors = new ArrayList<JvmMemoryLocation>(this.backtraceStackLocation(memoryLocation, callInstruction, clazz));
        successors.addAll(this.handleExtraPropagation(memoryLocation, callInstruction, clazz, parentNode));
        return successors;
    }

    private Collection<? extends JvmMemoryLocation> handleExtraPropagation(JvmMemoryLocation memoryLocation, ConstantInstruction callInstruction, Clazz clazz, JvmCfaNode parentNode) {
        if (parentNode.getLeavingEdges().stream().noneMatch(edge -> this.shouldEdgePropagateTaint((JvmCfaEdge)edge, memoryLocation))) {
            return Collections.emptyList();
        }
        return this.getPoppedLocations(callInstruction.stackPopCount(clazz));
    }

    private boolean shouldEdgePropagateTaint(JvmCfaEdge jvmCfaEdge, JvmMemoryLocation memoryLocation) {
        if (!(jvmCfaEdge instanceof JvmCallCfaEdge)) {
            return false;
        }
        Call call = ((JvmCallCfaEdge)jvmCfaEdge).getCall();
        return this.extraTaintPropagationLocations.containsKey(call) && this.extraTaintPropagationLocations.get(call).contains(memoryLocation);
    }

    private Optional<JvmAbstractState<ContentT>> getAnalysisAbstractState(ProgramLocationDependentReachedSet<JvmAbstractState<ContentT>> reachedSet, JvmCfaNode location) {
        Collection<JvmAbstractState<ContentT>> states = reachedSet.getReached(location);
        if (states.isEmpty()) {
            log.info(String.format("Missing entry state in the cache for method %s at offset %d", location.getSignature().getFqn(), location.getOffset()));
            return Optional.empty();
        }
        return states.stream().findFirst();
    }

    private List<JvmMemoryLocation> getSuccessorMemoryLocationsForInstruction(JvmMemoryLocationAbstractState<ContentT> abstractState, JvmAbstractState<ContentT> parentState, Instruction instruction, Clazz clazz, Method method, int offset) {
        ArrayList<JvmMemoryLocation> answer = new ArrayList<JvmMemoryLocation>();
        instruction.accept(clazz, method, null, offset, new InstructionAbstractInterpreter(answer, abstractState.getLocationDependentMemoryLocation().getMemoryLocation(), parentState));
        return answer;
    }

    private Collection<CallerInfo<ContentT>> getCallersInfo(JvmCallCfaEdge callEdge, JvmCfaNode calledLocation, JvmAbstractState<ContentT> calledState) {
        JvmCfaNode callerLocation = callEdge.getSource();
        Collection<BlockAbstraction<ContentT>> callerCacheEntries = this.cache.get(callerLocation.getSignature());
        ArrayList<CallerInfo<ContentT>> callerInfos = new ArrayList<CallerInfo<ContentT>>();
        for (BlockAbstraction<ContentT> cacheEntry : callerCacheEntries) {
            Optional<JvmAbstractState<ContentT>> callerState = cacheEntry.getReachedSet().getReached(callerLocation).stream().findFirst();
            if (!callerState.isPresent() || !this.tracedCpaReduceOperator.reduce(callerState.get(), calledLocation, callEdge.getCall()).equals(calledState)) continue;
            callerInfos.add(new CallerInfo<ContentT>(cacheEntry.getReachedSet(), callerState.get()));
        }
        return callerInfos;
    }

    private Optional<JvmMemoryLocation> createCallerLocation(JvmMemoryLocationAbstractState<ContentT> currentState) {
        JvmMemoryLocation memoryLocation = currentState.getLocationDependentMemoryLocation().getMemoryLocation();
        if (memoryLocation instanceof JvmLocalVariableLocation) {
            JvmLocalVariableLocation argumentLocation = (JvmLocalVariableLocation)memoryLocation;
            String currentDescriptor = currentState.getProgramLocation().getSignature().descriptor.toString();
            boolean isStatic = (currentState.getProgramLocation().getClazz().findMethod(currentState.getProgramLocation().getSignature().method, currentDescriptor).getAccessFlags() & 8) != 0;
            int parameterNumber = ClassUtil.internalMethodParameterNumber(currentDescriptor, isStatic, argumentLocation.index);
            int parameterIndex = isStatic || parameterNumber == 0 ? parameterNumber : parameterNumber - 1;
            int parameterSize = ClassUtil.internalMethodParameterSize(currentDescriptor, isStatic);
            String internalType = ClassUtil.internalMethodParameterType(currentDescriptor, parameterIndex);
            boolean isCategory2 = ClassUtil.isInternalCategory2Type(internalType);
            return Optional.of(new JvmStackLocation(parameterSize - argumentLocation.index - (isCategory2 ? 2 : 1)));
        }
        if (memoryLocation instanceof JvmStaticFieldLocation) {
            return Optional.of(memoryLocation);
        }
        if (memoryLocation instanceof JvmStackLocation) {
            return Optional.empty();
        }
        throw new ProguardCoreException.Builder("Unsupported memory location type %s", 9014).errorParameters(memoryLocation.getClass().getCanonicalName()).build();
    }

    private Collection<JvmMemoryLocationAbstractState<ContentT>> getSuccessorsFromMemoryLocations(List<JvmMemoryLocation> successorMemoryLocations, JvmAbstractState<ContentT> parentState, ProgramLocationDependentReachedSet<JvmAbstractState<ContentT>> successorsReachedSet, LinkedList<JvmMemoryLocationAbstractState.StackEntry<ContentT>> callStack) {
        ArrayList<JvmMemoryLocation> resultMemoryLocations = new ArrayList<JvmMemoryLocation>();
        for (JvmMemoryLocation location2 : successorMemoryLocations) {
            if (location2.extractValueOrDefault(parentState, this.threshold).isLessOrEqual(this.threshold)) continue;
            resultMemoryLocations.add(location2);
        }
        return resultMemoryLocations.stream().map(location -> new JvmMemoryLocationAbstractState((JvmMemoryLocation)location, parentState.getProgramLocation(), successorsReachedSet, callStack)).collect(Collectors.toList());
    }

    private List<JvmMemoryLocation> backtraceStackLocation(JvmMemoryLocation memoryLocation, Instruction instruction, Clazz clazz) {
        ArrayList<JvmMemoryLocation> result = new ArrayList<JvmMemoryLocation>();
        if (!(memoryLocation instanceof JvmStackLocation)) {
            result.add(memoryLocation);
            return result;
        }
        int index = ((JvmStackLocation)memoryLocation).getIndex();
        int pushCount = instruction.stackPushCount(clazz);
        int popCount = instruction.stackPopCount(clazz);
        if (index >= pushCount) {
            result.add(new JvmStackLocation(index - pushCount + popCount));
            return result;
        }
        result.addAll(this.getPoppedLocations(popCount));
        return result;
    }

    private List<JvmMemoryLocation> getPoppedLocations(int popCount) {
        ArrayList<JvmMemoryLocation> result = new ArrayList<JvmMemoryLocation>();
        for (int i = 0; i < popCount; ++i) {
            result.add(new JvmStackLocation(i));
        }
        return result;
    }

    private class InstructionAbstractInterpreter
    implements InstructionVisitor {
        private final List<JvmMemoryLocation> answer;
        private final JvmMemoryLocation memoryLocation;
        private final JvmAbstractState<ContentT> parentState;
        private final ConstantLookupVisitor constantLookupVisitor = new ConstantLookupVisitor();

        public InstructionAbstractInterpreter(List<JvmMemoryLocation> answer, JvmMemoryLocation memoryLocation, JvmAbstractState<ContentT> parentState) {
            this.answer = answer;
            this.memoryLocation = memoryLocation;
            this.parentState = parentState;
        }

        @Override
        public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
            if (!(this.memoryLocation instanceof JvmStackLocation) || InstructionClassifier.isReturn(simpleInstruction.opcode)) {
                this.answer.add(this.memoryLocation);
                return;
            }
            int index = ((JvmStackLocation)this.memoryLocation).getIndex();
            if (this.isStackLocationTooDeep((JvmStackLocation)this.memoryLocation, simpleInstruction, clazz)) {
                this.answer.addAll(JvmMemoryLocationTransferRelation.this.backtraceStackLocation(this.memoryLocation, simpleInstruction, clazz));
                return;
            }
            switch (simpleInstruction.opcode) {
                case 89: {
                    this.answer.add(new JvmStackLocation(0));
                    break;
                }
                case 90: {
                    this.answer.add(index == 2 ? new JvmStackLocation(0) : this.memoryLocation);
                    break;
                }
                case 91: {
                    this.answer.add(index == 3 ? new JvmStackLocation(0) : this.memoryLocation);
                    break;
                }
                case 92: {
                    this.answer.add(index > 1 ? new JvmStackLocation(index - 2) : this.memoryLocation);
                    break;
                }
                case 93: {
                    this.answer.add(index > 2 ? new JvmStackLocation(index - 3) : this.memoryLocation);
                    break;
                }
                case 94: {
                    this.answer.add(index > 3 ? new JvmStackLocation(index - 4) : this.memoryLocation);
                    break;
                }
                case 95: {
                    this.answer.add(new JvmStackLocation(1 - index));
                    break;
                }
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: {
                    this.answer.add(new JvmStackLocation(0));
                    this.answer.add(new JvmStackLocation(1));
                    break;
                }
                default: {
                    this.answer.addAll(JvmMemoryLocationTransferRelation.this.backtraceStackLocation(this.memoryLocation, simpleInstruction, clazz));
                }
            }
        }

        @Override
        public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
            if (variableInstruction.opcode == -124) {
                this.answer.add(this.memoryLocation);
                return;
            }
            if (variableInstruction.isLoad()) {
                this.answer.addAll(JvmMemoryLocationTransferRelation.this.backtraceStackLocation(this.memoryLocation, variableInstruction, clazz));
                if (this.memoryLocation instanceof JvmStackLocation && !this.isStackLocationTooDeep((JvmStackLocation)this.memoryLocation, variableInstruction, clazz)) {
                    this.answer.add(new JvmLocalVariableLocation(variableInstruction.variableIndex + ((JvmStackLocation)this.memoryLocation).index));
                }
                return;
            }
            if (!(this.memoryLocation instanceof JvmLocalVariableLocation) || ((JvmLocalVariableLocation)this.memoryLocation).index != variableInstruction.variableIndex) {
                this.answer.add(this.memoryLocation);
                return;
            }
            this.answer.add(new JvmStackLocation(0));
            if (variableInstruction.isCategory2()) {
                this.answer.add(new JvmStackLocation(1));
            }
        }

        @Override
        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
            switch (constantInstruction.opcode) {
                case -78: {
                    this.constantLookupVisitor.isStatic = true;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.constantLookupVisitor);
                    this.answer.addAll(JvmMemoryLocationTransferRelation.this.backtraceStackLocation(this.memoryLocation, constantInstruction, clazz));
                    if (!(this.memoryLocation instanceof JvmStackLocation) || this.isStackLocationTooDeep((JvmStackLocation)this.memoryLocation, constantInstruction, clazz)) break;
                    this.answer.add(new JvmStaticFieldLocation(this.constantLookupVisitor.result));
                    break;
                }
                case -77: {
                    this.constantLookupVisitor.isStatic = true;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.constantLookupVisitor);
                    if (this.memoryLocation instanceof JvmStackLocation) {
                        this.answer.add(new JvmStackLocation(((JvmStackLocation)this.memoryLocation).getIndex() + this.constantLookupVisitor.resultSize));
                        break;
                    }
                    if (this.memoryLocation instanceof JvmStaticFieldLocation) {
                        if (this.constantLookupVisitor.result.equals(((JvmStaticFieldLocation)this.memoryLocation).fqn)) {
                            this.answer.add(new JvmStackLocation(0));
                            if (this.constantLookupVisitor.resultSize != 2) break;
                            this.answer.add(new JvmStackLocation(1));
                            break;
                        }
                        this.answer.add(this.memoryLocation);
                        break;
                    }
                    this.answer.add(this.memoryLocation);
                    break;
                }
                case -76: {
                    this.constantLookupVisitor.isStatic = false;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.constantLookupVisitor);
                    this.answer.addAll(JvmMemoryLocationTransferRelation.this.backtraceStackLocation(this.memoryLocation, constantInstruction, clazz));
                    break;
                }
                case -75: {
                    this.constantLookupVisitor.isStatic = false;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.constantLookupVisitor);
                    if (this.memoryLocation instanceof JvmStackLocation) {
                        this.answer.add(new JvmStackLocation(((JvmStackLocation)this.memoryLocation).index + this.constantLookupVisitor.resultSize + 1));
                        break;
                    }
                    this.answer.add(this.memoryLocation);
                    break;
                }
                case -74: 
                case -73: 
                case -72: 
                case -71: 
                case -70: {
                    this.answer.addAll(JvmMemoryLocationTransferRelation.this.processCall(this.memoryLocation, constantInstruction, clazz, this.parentState.getProgramLocation()));
                    break;
                }
                default: {
                    this.answer.addAll(JvmMemoryLocationTransferRelation.this.backtraceStackLocation(this.memoryLocation, constantInstruction, clazz));
                }
            }
        }

        @Override
        public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
            this.answer.addAll(JvmMemoryLocationTransferRelation.this.backtraceStackLocation(this.memoryLocation, branchInstruction, clazz));
        }

        @Override
        public void visitAnySwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SwitchInstruction switchInstruction) {
            this.answer.addAll(JvmMemoryLocationTransferRelation.this.backtraceStackLocation(this.memoryLocation, switchInstruction, clazz));
        }

        private boolean isStackLocationTooDeep(JvmStackLocation stackLocation, Instruction instruction, Clazz clazz) {
            return stackLocation.index >= instruction.stackPushCount(clazz);
        }
    }

    private static class CallerInfo<ContentT extends AbstractState<ContentT>> {
        public final ProgramLocationDependentReachedSet<JvmAbstractState<ContentT>> reachedSet;
        public final JvmAbstractState<ContentT> state;

        public CallerInfo(ProgramLocationDependentReachedSet<JvmAbstractState<ContentT>> reachedSet, JvmAbstractState<ContentT> state) {
            this.reachedSet = reachedSet;
            this.state = state;
        }
    }
}

