/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.taint;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import proguard.analysis.cpa.defaults.MapAbstractState;
import proguard.analysis.cpa.defaults.SetAbstractState;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintSource;
import proguard.analysis.cpa.jvm.operators.DefaultReduceOperator;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.analysis.cpa.jvm.state.JvmFrameAbstractState;
import proguard.analysis.cpa.jvm.state.heap.JvmHeapAbstractState;
import proguard.classfile.Signature;

public class TaintReduceOperator
extends DefaultReduceOperator<SetAbstractState<JvmTaintSource>> {
    private final Map<Signature, Set<JvmTaintSource>> taintSourcesTaintArgs;

    public TaintReduceOperator(boolean reduceHeap) {
        super(reduceHeap);
        this.taintSourcesTaintArgs = new HashMap<Signature, Set<JvmTaintSource>>();
    }

    public TaintReduceOperator(boolean reduceHeap, Map<Signature, Set<JvmTaintSource>> taintSources) {
        super(reduceHeap);
        this.taintSourcesTaintArgs = taintSources;
    }

    @Override
    protected JvmAbstractState<SetAbstractState<JvmTaintSource>> createJvmAbstractState(JvmCfaNode programLocation, JvmFrameAbstractState<SetAbstractState<JvmTaintSource>> frame, JvmHeapAbstractState<SetAbstractState<JvmTaintSource>> heap, MapAbstractState<String, SetAbstractState<JvmTaintSource>> staticFields) {
        return new JvmAbstractState<SetAbstractState<JvmTaintSource>>(programLocation, frame, heap, staticFields);
    }

    @Override
    public JvmAbstractState<SetAbstractState<JvmTaintSource>> onMethodEntry(JvmAbstractState<SetAbstractState<JvmTaintSource>> reducedState, boolean isCallStatic) {
        JvmFrameAbstractState<SetAbstractState<JvmTaintSource>> frame = reducedState.getFrame();
        JvmCfaNode programLocation = reducedState.getProgramLocation();
        if (this.taintSourcesTaintArgs.containsKey(programLocation.getSignature())) {
            this.taintSourcesTaintArgs.get(programLocation.getSignature()).forEach(source -> source.taintsArgs.forEach(index -> this.updateTaintState(frame, isCallStatic ? index - 1 : index, (JvmTaintSource)source)));
        }
        return new JvmAbstractState<SetAbstractState<JvmTaintSource>>(programLocation, frame, reducedState.getHeap(), reducedState.getStaticFields());
    }

    private void updateTaintState(JvmFrameAbstractState<SetAbstractState<JvmTaintSource>> frame, int index, JvmTaintSource source) {
        SetAbstractState<JvmTaintSource> oldState = frame.getLocalVariables().getOrDefault(index, SetAbstractState.bottom());
        SetAbstractState<JvmTaintSource> newState = oldState.join(new SetAbstractState<JvmTaintSource>(source));
        frame.getLocalVariables().set(index, newState, SetAbstractState.bottom());
    }
}

