/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.state;

import java.util.List;
import proguard.analysis.cpa.defaults.MapAbstractState;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.interfaces.ProgramLocationDependent;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.state.JvmFrameAbstractState;
import proguard.analysis.cpa.jvm.state.heap.JvmHeapAbstractState;
import proguard.classfile.Clazz;

public class JvmAbstractState<ContentT extends AbstractState<ContentT>>
implements AbstractState<JvmAbstractState<ContentT>>,
ProgramLocationDependent {
    public static final String DEFAULT_FIELD = "";
    protected final JvmFrameAbstractState<ContentT> frame;
    protected final JvmHeapAbstractState<ContentT> heap;
    protected final MapAbstractState<String, ContentT> staticFields;
    protected JvmCfaNode programLocation;
    protected static final JvmCfaNode topLocation = new JvmCfaNode(null, -1, null);

    public JvmAbstractState(JvmCfaNode programLocation, JvmFrameAbstractState<ContentT> frame, JvmHeapAbstractState<ContentT> heap, MapAbstractState<String, ContentT> staticFields) {
        this.programLocation = programLocation;
        this.frame = frame;
        this.heap = heap;
        this.staticFields = staticFields;
    }

    @Override
    public JvmAbstractState<ContentT> join(JvmAbstractState<ContentT> abstractState) {
        JvmAbstractState<ContentT> answer = new JvmAbstractState<ContentT>(this.programLocation.equals(abstractState.programLocation) ? this.programLocation : topLocation, this.frame.join(abstractState.frame), this.heap.join(abstractState.heap), this.staticFields.join(abstractState.staticFields));
        return this.equals(answer) ? this : answer;
    }

    @Override
    public boolean isLessOrEqual(JvmAbstractState<ContentT> abstractState) {
        return (this.programLocation.equals(abstractState.programLocation) || abstractState.programLocation.equals(topLocation)) && this.frame.isLessOrEqual(abstractState.frame) && this.heap.isLessOrEqual(abstractState.heap) && this.staticFields.isLessOrEqual(abstractState.staticFields);
    }

    @Override
    public JvmCfaNode getProgramLocation() {
        return this.programLocation;
    }

    @Override
    public void setProgramLocation(JvmCfaNode programLocation) {
        this.programLocation = programLocation;
    }

    @Override
    public JvmAbstractState<ContentT> copy() {
        return new JvmAbstractState<ContentT>(this.programLocation, this.frame.copy(), this.heap.copy(), this.staticFields.copy());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JvmAbstractState)) {
            return false;
        }
        JvmAbstractState other = (JvmAbstractState)obj;
        return this.programLocation.equals(other.programLocation) && this.frame.equals(other.frame) && this.heap.equals(other.heap) && this.staticFields.equals(other.staticFields);
    }

    @Override
    public int hashCode() {
        return this.programLocation.hashCode();
    }

    public ContentT peek() {
        return this.peek(0);
    }

    public ContentT peek(int index) {
        return this.frame.peek(index);
    }

    public ContentT peekOrDefault(ContentT defaultState) {
        return this.peekOrDefault(0, defaultState);
    }

    public ContentT peekOrDefault(int index, ContentT defaultState) {
        return this.frame.peekOrDefault(index, defaultState);
    }

    public ContentT pop() {
        return this.frame.pop();
    }

    public ContentT popOrDefault(ContentT defaultState) {
        return this.frame.popOrDefault(defaultState);
    }

    public ContentT push(ContentT state) {
        return this.frame.push(state);
    }

    public List<ContentT> pushAll(List<ContentT> states) {
        states.forEach(this.frame::push);
        return states;
    }

    public void clearOperandStack() {
        this.frame.getOperandStack().clear();
    }

    public ContentT getVariableOrDefault(int index, ContentT defaultState) {
        return this.frame.getVariableOrDefault(index, defaultState);
    }

    public ContentT setVariable(int index, ContentT state, ContentT defaultState) {
        return this.frame.setVariable(index, state, defaultState);
    }

    public ContentT getStaticOrDefault(String fqn, ContentT defaultState) {
        return (ContentT)((AbstractState)this.staticFields.getOrDefault(fqn, defaultState));
    }

    public void setStatic(String fqn, ContentT value, ContentT defaultState) {
        if (value.equals(defaultState)) {
            return;
        }
        this.staticFields.put(fqn, value);
    }

    public <T> ContentT getFieldOrDefault(T object, String descriptor, ContentT defaultValue) {
        return this.heap.getFieldOrDefault(object, descriptor, defaultValue);
    }

    public <T> ContentT getFieldOrDefault(T object, ContentT defaultValue) {
        return this.getFieldOrDefault(object, DEFAULT_FIELD, defaultValue);
    }

    public <T> void setField(T object, String descriptor, ContentT value) {
        this.heap.setField(object, descriptor, value);
    }

    public <T> void setField(T object, ContentT value) {
        this.setField(object, DEFAULT_FIELD, value);
    }

    public JvmFrameAbstractState<ContentT> getFrame() {
        return this.frame;
    }

    public MapAbstractState<String, ContentT> getStaticFields() {
        return this.staticFields;
    }

    public JvmHeapAbstractState<ContentT> getHeap() {
        return this.heap;
    }

    public ContentT newArray(String type, List<ContentT> dimensions) {
        return this.heap.newArray(type, dimensions, this.programLocation);
    }

    public ContentT newObject(String className) {
        return this.heap.newObject(className, this.programLocation);
    }

    public ContentT newObject(Clazz clazz) {
        return this.heap.newObject(clazz, this.programLocation);
    }

    public <T> ContentT getArrayElementOrDefault(T array, ContentT index, ContentT abstractDefault) {
        return this.heap.getArrayElementOrDefault(array, index, abstractDefault);
    }

    public <T> void setArrayElement(T array, ContentT index, ContentT value) {
        this.heap.setArrayElement(array, index, value);
    }
}

