/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.transfer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import proguard.analysis.CallResolver;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.interfaces.Precision;
import proguard.analysis.cpa.interfaces.ProgramLocationDependentForwardTransferRelation;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCallCfaEdge;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCfaEdge;
import proguard.analysis.cpa.jvm.cfa.edges.JvmInstructionCfaEdge;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.analysis.cpa.jvm.transfer.JvmTransferRelation;
import proguard.analysis.cpa.jvm.util.ConstantLookupVisitor;
import proguard.analysis.cpa.jvm.util.InstructionClassifier;
import proguard.analysis.datastructure.CodeLocation;
import proguard.analysis.datastructure.callgraph.Call;
import proguard.analysis.datastructure.callgraph.SymbolicCall;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.MethodSignature;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.DoubleConstant;
import proguard.classfile.constant.FloatConstant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.LongConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionUtil;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.exception.ProguardCoreException;

public abstract class JvmTransferRelation<ContentT extends AbstractState<ContentT>>
implements ProgramLocationDependentForwardTransferRelation<ContentT> {
    @Override
    public Collection<JvmAbstractState<ContentT>> generateEdgeAbstractSuccessors(JvmAbstractState<ContentT> abstractState, JvmCfaEdge edge, Precision precision) {
        return this.wrapAbstractSuccessorInCollection(this.generateEdgeAbstractSuccessor(abstractState, edge, precision));
    }

    public JvmAbstractState<ContentT> generateEdgeAbstractSuccessor(JvmAbstractState<ContentT> abstractState, JvmCfaEdge edge, Precision precision) {
        JvmAbstractState<ContentT> successor = abstractState.copy();
        if (edge instanceof JvmCallCfaEdge) {
            successor.setProgramLocation(edge.getSource().getLeavingInvokeEdge().get().getTarget());
            this.processCall(successor, ((JvmCallCfaEdge)edge).getCall());
        } else {
            if (edge instanceof JvmInstructionCfaEdge) {
                boolean isInterproceduralInvoke;
                Instruction instruction = ((JvmInstructionCfaEdge)edge).getInstruction();
                boolean bl = isInterproceduralInvoke = InstructionClassifier.isInvoke(instruction.opcode) && !abstractState.getProgramLocation().getLeavingInterproceduralEdges().isEmpty();
                if (isInterproceduralInvoke) {
                    return null;
                }
                successor = this.getAbstractSuccessorForInstruction(successor, instruction, abstractState.getProgramLocation().getClazz(), precision);
            }
            successor.setProgramLocation(edge.getTarget());
        }
        return successor;
    }

    protected JvmAbstractState<ContentT> getAbstractSuccessorForInstruction(JvmAbstractState<ContentT> abstractState, Instruction instruction, Clazz clazz, Precision precision) {
        instruction.accept(clazz, null, null, 0, new InstructionAbstractInterpreter(abstractState));
        return abstractState;
    }

    protected ContentT calculateArithmeticInstruction(Instruction instruction, List<ContentT> operands) {
        return (ContentT)((AbstractState)operands.stream().reduce(this.getAbstractDefault(), AbstractState::join));
    }

    protected ContentT computeIncrement(ContentT state, int value) {
        return state.join(this.getAbstractIntegerConstant(value));
    }

    public ContentT getAbstractByteConstant(byte b) {
        return this.getAbstractDefault();
    }

    public abstract ContentT getAbstractDefault();

    public List<ContentT> getAbstractDoubleConstant(double d) {
        return Arrays.asList(this.getAbstractDefault(), this.getAbstractDefault());
    }

    public ContentT getAbstractFloatConstant(float f) {
        return this.getAbstractDefault();
    }

    public ContentT getAbstractIntegerConstant(int i) {
        return this.getAbstractDefault();
    }

    public List<ContentT> getAbstractLongConstant(long l) {
        return Arrays.asList(this.getAbstractDefault(), this.getAbstractDefault());
    }

    public ContentT getAbstractNull() {
        return this.getAbstractDefault();
    }

    public ContentT getAbstractShortConstant(short s) {
        return this.getAbstractDefault();
    }

    public ContentT getAbstractReferenceValue(String className, Clazz referencedClazz, boolean mayBeExtension, boolean mayBeNull, Clazz creationClass, Method creationMethod, int creationOffset, Object value) {
        return this.getAbstractDefault();
    }

    protected void processCall(JvmAbstractState<ContentT> state, Call call) {
        LinkedList<ContentT> operands = new LinkedList<ContentT>();
        if (call.getTarget().descriptor.argumentTypes != null) {
            List<String> argumentTypes = call.getTarget().descriptor.argumentTypes;
            for (int i = argumentTypes.size() - 1; i >= 0; --i) {
                boolean isCategory2 = ClassUtil.isInternalCategory2Type(argumentTypes.get(i));
                if (isCategory2) {
                    ContentT higherByte = state.pop();
                    operands.offerFirst(state.pop());
                    operands.offerFirst(higherByte);
                    continue;
                }
                operands.offerFirst(state.pop());
            }
        }
        if (!call.isStatic()) {
            operands.offerFirst(state.pop());
        }
        this.invokeMethod(state, call, (List)operands);
    }

    public void invokeMethod(JvmAbstractState<ContentT> state, Call call, List<ContentT> operands) {
        int pushCount = ClassUtil.internalTypeSize(call.getTarget().descriptor.returnType == null ? "?" : call.getTarget().descriptor.returnType);
        AbstractState answerContent = (AbstractState)operands.stream().reduce(this.getAbstractDefault(), AbstractState::join);
        for (int i = 0; i < pushCount; ++i) {
            state.push(answerContent);
        }
    }

    protected ContentT isInstanceOf(ContentT state, String type) {
        return this.getAbstractDefault();
    }

    protected ContentT handleCheckCast(ContentT state, String typeName) {
        return state;
    }

    protected class InstructionAbstractInterpreter
    implements InstructionVisitor {
        protected final JvmAbstractState<ContentT> abstractState;
        protected final ConstantLookupVisitor constantLookupVisitor = new ConstantLookupVisitor();
        private final proguard.analysis.cpa.jvm.transfer.JvmTransferRelation$InstructionAbstractInterpreter.LdcConstantValueStatePusher constantValueStatePusher = new LdcConstantValueStatePusher();

        public InstructionAbstractInterpreter(JvmAbstractState<ContentT> abstractState) {
            this.abstractState = abstractState;
        }

        @Override
        public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
            switch (simpleInstruction.opcode) {
                case 1: {
                    this.abstractState.push(JvmTransferRelation.this.getAbstractNull());
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    this.abstractState.push(JvmTransferRelation.this.getAbstractIntegerConstant(simpleInstruction.constant));
                    break;
                }
                case 9: 
                case 10: {
                    this.abstractState.pushAll(JvmTransferRelation.this.getAbstractLongConstant(simpleInstruction.constant));
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    this.abstractState.push(JvmTransferRelation.this.getAbstractFloatConstant(simpleInstruction.constant));
                    break;
                }
                case 14: 
                case 15: {
                    this.abstractState.pushAll(JvmTransferRelation.this.getAbstractDoubleConstant(simpleInstruction.constant));
                    break;
                }
                case 46: 
                case 48: 
                case 50: 
                case 51: 
                case 52: 
                case 53: {
                    Object index = this.abstractState.pop();
                    this.abstractState.push(this.abstractState.getArrayElementOrDefault(this.abstractState.pop(), index, JvmTransferRelation.this.getAbstractDefault()));
                    break;
                }
                case 47: 
                case 49: {
                    Object index = this.abstractState.pop();
                    Object array = this.abstractState.pop();
                    this.abstractState.push(JvmTransferRelation.this.getAbstractDefault());
                    this.abstractState.push(this.abstractState.getArrayElementOrDefault(array, index, JvmTransferRelation.this.getAbstractDefault()));
                    break;
                }
                case 79: 
                case 81: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    Object value = this.abstractState.pop();
                    Object index = this.abstractState.pop();
                    this.abstractState.setArrayElement(this.abstractState.pop(), index, value);
                    break;
                }
                case 80: 
                case 82: {
                    Object value = this.abstractState.pop();
                    this.abstractState.pop();
                    Object index = this.abstractState.pop();
                    this.abstractState.setArrayElement(this.abstractState.pop(), index, value);
                    break;
                }
                case 16: {
                    this.abstractState.push(JvmTransferRelation.this.getAbstractByteConstant((byte)simpleInstruction.constant));
                    break;
                }
                case 17: {
                    this.abstractState.push(JvmTransferRelation.this.getAbstractShortConstant((short)simpleInstruction.constant));
                    break;
                }
                case -62: 
                case -61: 
                case 87: {
                    this.abstractState.pop();
                    break;
                }
                case 88: {
                    this.abstractState.pop();
                    this.abstractState.pop();
                    break;
                }
                case 89: {
                    this.abstractState.push(this.abstractState.peek());
                    break;
                }
                case 90: {
                    Object state1 = this.abstractState.pop();
                    Object state2 = this.abstractState.pop();
                    this.abstractState.push(state1);
                    this.abstractState.push(state2);
                    this.abstractState.push(state1);
                    break;
                }
                case 91: {
                    Object state1 = this.abstractState.pop();
                    Object state2 = this.abstractState.pop();
                    Object state3 = this.abstractState.pop();
                    this.abstractState.push(state1);
                    this.abstractState.push(state3);
                    this.abstractState.push(state2);
                    this.abstractState.push(state1);
                    break;
                }
                case 92: {
                    Object state1 = this.abstractState.peek();
                    Object state2 = this.abstractState.peek(1);
                    this.abstractState.push(state2);
                    this.abstractState.push(state1);
                    break;
                }
                case 93: {
                    Object state1 = this.abstractState.pop();
                    Object state2 = this.abstractState.pop();
                    Object state3 = this.abstractState.pop();
                    this.abstractState.push(state2);
                    this.abstractState.push(state1);
                    this.abstractState.push(state3);
                    this.abstractState.push(state2);
                    this.abstractState.push(state1);
                    break;
                }
                case 94: {
                    Object state1 = this.abstractState.pop();
                    Object state2 = this.abstractState.pop();
                    Object state3 = this.abstractState.pop();
                    Object state4 = this.abstractState.pop();
                    this.abstractState.push(state2);
                    this.abstractState.push(state1);
                    this.abstractState.push(state4);
                    this.abstractState.push(state3);
                    this.abstractState.push(state2);
                    this.abstractState.push(state1);
                    break;
                }
                case 95: {
                    Object state1 = this.abstractState.pop();
                    Object state2 = this.abstractState.pop();
                    this.abstractState.push(state1);
                    this.abstractState.push(state2);
                    break;
                }
                case -84: 
                case -83: 
                case -82: 
                case -81: 
                case -80: 
                case -79: {
                    break;
                }
                case -65: {
                    Object exceptionState = this.abstractState.pop();
                    this.abstractState.clearOperandStack();
                    this.abstractState.push(exceptionState);
                    break;
                }
                case -66: {
                    this.abstractState.pop();
                    this.abstractState.push(JvmTransferRelation.this.getAbstractDefault());
                    break;
                }
                default: {
                    ArrayList operands = new ArrayList(simpleInstruction.stackPopCount(clazz));
                    if (InstructionClassifier.isLongShift(simpleInstruction.opcode)) {
                        operands.add(this.abstractState.pop());
                        Object higherByte = this.abstractState.pop();
                        operands.add(this.abstractState.pop());
                        operands.add(higherByte);
                    } else {
                        for (int i = 0; i < simpleInstruction.stackPopCount(clazz) / (simpleInstruction.isCategory2() ? 2 : 1); ++i) {
                            if (simpleInstruction.isCategory2()) {
                                Object higherByte = this.abstractState.pop();
                                operands.add(this.abstractState.pop());
                                operands.add(higherByte);
                                continue;
                            }
                            operands.add(this.abstractState.pop());
                        }
                    }
                    int resultCount = simpleInstruction.stackPushCount(clazz);
                    if (resultCount > 2) {
                        throw new ProguardCoreException.Builder("No instruction with push count higher than 2 should be handled here. Instruction: %s", 9042).errorParameters(simpleInstruction).build();
                    }
                    if (resultCount == 2) {
                        this.abstractState.push(JvmTransferRelation.this.getAbstractDefault());
                    }
                    if (resultCount <= 0) break;
                    Collections.reverse(operands);
                    this.abstractState.push(JvmTransferRelation.this.calculateArithmeticInstruction(simpleInstruction, operands));
                }
            }
        }

        @Override
        public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
            if (variableInstruction.opcode == -124) {
                this.abstractState.setVariable(variableInstruction.variableIndex, JvmTransferRelation.this.computeIncrement(this.abstractState.getVariableOrDefault(variableInstruction.variableIndex, JvmTransferRelation.this.getAbstractDefault()), variableInstruction.constant), JvmTransferRelation.this.getAbstractDefault());
                return;
            }
            if (variableInstruction.isLoad()) {
                if (variableInstruction.isCategory2()) {
                    this.abstractState.push(this.abstractState.getVariableOrDefault(variableInstruction.variableIndex + 1, JvmTransferRelation.this.getAbstractDefault()));
                }
                this.abstractState.push(this.abstractState.getVariableOrDefault(variableInstruction.variableIndex, JvmTransferRelation.this.getAbstractDefault()));
                return;
            }
            this.abstractState.setVariable(variableInstruction.variableIndex, this.abstractState.pop(), JvmTransferRelation.this.getAbstractDefault());
            if (variableInstruction.isCategory2()) {
                this.abstractState.setVariable(variableInstruction.variableIndex + 1, this.abstractState.pop(), JvmTransferRelation.this.getAbstractDefault());
            }
        }

        @Override
        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
            this.constantLookupVisitor.resetResult();
            switch (constantInstruction.opcode) {
                case 18: 
                case 19: 
                case 20: {
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, (ConstantVisitor)this.constantValueStatePusher);
                    break;
                }
                case -78: {
                    this.constantLookupVisitor.isStatic = true;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.constantLookupVisitor);
                    if (this.constantLookupVisitor.resultSize > 1) {
                        this.abstractState.push(JvmTransferRelation.this.getAbstractDefault());
                    }
                    this.abstractState.push(this.abstractState.getStaticOrDefault(this.constantLookupVisitor.result, JvmTransferRelation.this.getAbstractDefault()));
                    break;
                }
                case -77: {
                    this.constantLookupVisitor.isStatic = true;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.constantLookupVisitor);
                    Object value = this.abstractState.pop();
                    if (this.constantLookupVisitor.resultSize > 1) {
                        this.abstractState.pop();
                    }
                    this.abstractState.setStatic(this.constantLookupVisitor.result, value, JvmTransferRelation.this.getAbstractDefault());
                    break;
                }
                case -76: {
                    this.constantLookupVisitor.isStatic = false;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.constantLookupVisitor);
                    Object result = this.abstractState.getFieldOrDefault(this.abstractState.pop(), this.constantLookupVisitor.result, JvmTransferRelation.this.getAbstractDefault());
                    if (this.constantLookupVisitor.resultSize > 1) {
                        this.abstractState.push(JvmTransferRelation.this.getAbstractDefault());
                    }
                    this.abstractState.push(result);
                    break;
                }
                case -75: {
                    this.constantLookupVisitor.isStatic = false;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.constantLookupVisitor);
                    Object value = this.abstractState.pop();
                    if (this.constantLookupVisitor.resultSize > 1) {
                        this.abstractState.pop();
                    }
                    this.abstractState.setField(this.abstractState.pop(), this.constantLookupVisitor.result, value);
                    break;
                }
                case -74: 
                case -73: 
                case -72: 
                case -71: 
                case -70: {
                    MethodSignature calleeSignature = CallResolver.quickResolve(constantInstruction, (ProgramClass)clazz);
                    if (calleeSignature.equals(MethodSignature.UNKNOWN)) {
                        throw new ProguardCoreException.Builder("Unexpected unknown signature", 9043).build();
                    }
                    JvmTransferRelation.this.processCall(this.abstractState, new SymbolicCall(new CodeLocation(clazz, method, offset), calleeSignature, 0, constantInstruction, false, false));
                    break;
                }
                case -63: {
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.constantLookupVisitor);
                    this.abstractState.push(JvmTransferRelation.this.isInstanceOf(this.abstractState.pop(), this.constantLookupVisitor.result));
                    break;
                }
                case -69: {
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.constantLookupVisitor);
                    this.abstractState.push(this.constantLookupVisitor.resultClazz != null ? this.abstractState.newObject(this.constantLookupVisitor.resultClazz) : this.abstractState.newObject(this.constantLookupVisitor.result));
                    break;
                }
                case -68: {
                    this.abstractState.push(this.abstractState.newArray(String.valueOf(InstructionUtil.internalTypeFromArrayType((byte)constantInstruction.constant)), Collections.singletonList(this.abstractState.pop())));
                    break;
                }
                case -67: {
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.constantLookupVisitor);
                    this.abstractState.push(this.abstractState.newArray(this.constantLookupVisitor.result, Collections.singletonList(this.abstractState.pop())));
                    break;
                }
                case -59: {
                    ArrayList dimensions = new ArrayList(constantInstruction.constant);
                    for (int i = 0; i < constantInstruction.stackPopCount(clazz); ++i) {
                        dimensions.add(this.abstractState.pop());
                    }
                    Collections.reverse(dimensions);
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.constantLookupVisitor);
                    this.abstractState.push(this.abstractState.newArray(this.constantLookupVisitor.result, dimensions));
                    break;
                }
                case -64: {
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.constantLookupVisitor);
                    this.abstractState.push(JvmTransferRelation.this.handleCheckCast(this.abstractState.pop(), this.constantLookupVisitor.result));
                    break;
                }
                default: {
                    throw new ProguardCoreException.Builder("The opcode %02X is not supported by the constant instruction visitor", 9044).errorParameters(constantInstruction.opcode).build();
                }
            }
        }

        @Override
        public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
            int i;
            for (i = 0; i < branchInstruction.stackPopCount(clazz); ++i) {
                this.abstractState.pop();
            }
            for (i = 0; i < branchInstruction.stackPushCount(clazz); ++i) {
                this.abstractState.push(JvmTransferRelation.this.getAbstractDefault());
            }
        }

        @Override
        public void visitAnySwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SwitchInstruction switchInstruction) {
            for (int i = 0; i < switchInstruction.stackPopCount(clazz); ++i) {
                this.abstractState.pop();
            }
        }

        private class LdcConstantValueStatePusher
        implements ConstantVisitor {
            private LdcConstantValueStatePusher() {
            }

            @Override
            public void visitAnyConstant(Clazz clazz, Constant constant) {
                InstructionAbstractInterpreter.this.abstractState.push(JvmTransferRelation.this.getAbstractDefault());
            }

            @Override
            public void visitLongConstant(Clazz clazz, LongConstant longConstant) {
                InstructionAbstractInterpreter.this.abstractState.pushAll(JvmTransferRelation.this.getAbstractLongConstant(longConstant.u8value));
            }

            @Override
            public void visitDoubleConstant(Clazz clazz, DoubleConstant doubleConstant) {
                InstructionAbstractInterpreter.this.abstractState.pushAll(JvmTransferRelation.this.getAbstractDoubleConstant(doubleConstant.f8value));
            }

            @Override
            public void visitIntegerConstant(Clazz clazz, IntegerConstant integerConstant) {
                InstructionAbstractInterpreter.this.abstractState.push(JvmTransferRelation.this.getAbstractIntegerConstant(integerConstant.u4value));
            }

            @Override
            public void visitFloatConstant(Clazz clazz, FloatConstant floatConstant) {
                InstructionAbstractInterpreter.this.abstractState.push(JvmTransferRelation.this.getAbstractFloatConstant(floatConstant.f4value));
            }

            @Override
            public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
                JvmCfaNode programLocation = InstructionAbstractInterpreter.this.abstractState.getProgramLocation();
                InstructionAbstractInterpreter.this.abstractState.push(JvmTransferRelation.this.getAbstractReferenceValue("Ljava/lang/String;", stringConstant.javaLangStringClass, false, false, programLocation.getClazz(), programLocation.getSignature().getReferencedMethod(), programLocation.getOffset(), stringConstant.getString(clazz)));
            }

            @Override
            public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
                InstructionAbstractInterpreter.this.abstractState.push(JvmTransferRelation.this.getAbstractDefault());
            }
        }
    }
}

