/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.signature.ast.signature;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import proguard.classfile.attribute.signature.ast.ASTStructureException;
import proguard.classfile.attribute.signature.ast.signature.SuperclassSignatureNode;
import proguard.classfile.attribute.signature.ast.signature.SuperinterfaceSignatureNode;
import proguard.classfile.attribute.signature.ast.signature.TypeParameterNode;
import proguard.classfile.attribute.signature.ast.visitor.ASTNodeVisitor;

public class ClassSignatureNode {
    @NotNull
    private List<TypeParameterNode> typeParameters;
    @NotNull
    private SuperclassSignatureNode superclassSignature;
    @NotNull
    private List<SuperinterfaceSignatureNode> superinterfaceSignatures;

    public ClassSignatureNode(@NotNull List<TypeParameterNode> typeParameters, @NotNull SuperclassSignatureNode superclassSignature, @NotNull List<SuperinterfaceSignatureNode> superinterfaceSignatures) {
        this.typeParameters = typeParameters;
        this.superclassSignature = superclassSignature;
        this.superinterfaceSignatures = superinterfaceSignatures;
    }

    @NotNull
    public List<TypeParameterNode> getTypeParameters() {
        return this.typeParameters;
    }

    public void setTypeParameters(@NotNull List<TypeParameterNode> typeParameters) {
        if (typeParameters == null) {
            throw new ASTStructureException("Argument must not be null.");
        }
        this.typeParameters = typeParameters;
    }

    @NotNull
    public SuperclassSignatureNode getSuperclassSignature() {
        return this.superclassSignature;
    }

    public void setSuperclassSignature(@NotNull SuperclassSignatureNode superclassSignature) {
        if (superclassSignature == null) {
            throw new ASTStructureException("Argument must not be null.");
        }
        this.superclassSignature = superclassSignature;
    }

    @NotNull
    public List<SuperinterfaceSignatureNode> getSuperinterfaceSignatures() {
        return this.superinterfaceSignatures;
    }

    public void setSuperinterfaceSignatures(@NotNull List<SuperinterfaceSignatureNode> superinterfaceSignatures) {
        if (superinterfaceSignatures == null) {
            throw new ASTStructureException("Argument must not be null.");
        }
        this.superinterfaceSignatures = superinterfaceSignatures;
    }

    public <R, P> R accept(ASTNodeVisitor<R, P> visitor, P arg) {
        return visitor.visit(this, arg);
    }

    @NotNull
    public String toString() {
        @NotNull StringBuilder sb = new StringBuilder();
        if (!this.typeParameters.isEmpty()) {
            sb.append('<');
            for (TypeParameterNode typeParameterNode : this.typeParameters) {
                sb.append(typeParameterNode.toString());
            }
            sb.append('>');
        }
        sb.append(this.superclassSignature.toString());
        for (SuperinterfaceSignatureNode superinterfaceSignatureNode : this.superinterfaceSignatures) {
            sb.append(superinterfaceSignatureNode.toString());
        }
        return sb.toString();
    }
}

