/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.signature.parsing;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import proguard.classfile.attribute.signature.parsing.Parser;

public final class Combinators {
    public static <A, B, R> Parser<R> chain(Parser<A> aParser, Parser<B> bParser, BiCombinator<A, B, R> combinator) {
        return ctx -> {
            ctx.snapshot();
            Object a = aParser.parse(ctx);
            if (a == null) {
                ctx.revert();
                return null;
            }
            Object b = bParser.parse(ctx);
            if (b == null) {
                ctx.revert();
                return null;
            }
            ctx.commit();
            return combinator.combine(a, b);
        };
    }

    public static <A, B, C, R> Parser<R> chain(Parser<A> aParser, Parser<B> bParser, Parser<C> cParser, TerCombinator<A, B, C, R> combinator) {
        return ctx -> {
            ctx.snapshot();
            Object a = aParser.parse(ctx);
            if (a == null) {
                ctx.revert();
                return null;
            }
            Object b = bParser.parse(ctx);
            if (b == null) {
                ctx.revert();
                return null;
            }
            Object c = cParser.parse(ctx);
            if (c == null) {
                ctx.revert();
                return null;
            }
            ctx.commit();
            return combinator.combine(a, b, c);
        };
    }

    public static <A, B, C, D, R> Parser<R> chain(Parser<A> aParser, Parser<B> bParser, Parser<C> cParser, Parser<D> dParser, QuaterCombinator<A, B, C, D, R> combinator) {
        return ctx -> {
            ctx.snapshot();
            Object a = aParser.parse(ctx);
            if (a == null) {
                ctx.revert();
                return null;
            }
            Object b = bParser.parse(ctx);
            if (b == null) {
                ctx.revert();
                return null;
            }
            Object c = cParser.parse(ctx);
            if (c == null) {
                ctx.revert();
                return null;
            }
            Object d = dParser.parse(ctx);
            if (d == null) {
                ctx.revert();
                return null;
            }
            ctx.commit();
            return combinator.combine(a, b, c, d);
        };
    }

    public static <A, B, C, D, E, R> Parser<R> chain(Parser<A> aParser, Parser<B> bParser, Parser<C> cParser, Parser<D> dParser, Parser<E> eParser, PentaCombinator<A, B, C, D, E, R> combinator) {
        return ctx -> {
            ctx.snapshot();
            Object a = aParser.parse(ctx);
            if (a == null) {
                ctx.revert();
                return null;
            }
            Object b = bParser.parse(ctx);
            if (b == null) {
                ctx.revert();
                return null;
            }
            Object c = cParser.parse(ctx);
            if (c == null) {
                ctx.revert();
                return null;
            }
            Object d = dParser.parse(ctx);
            if (d == null) {
                ctx.revert();
                return null;
            }
            Object e = eParser.parse(ctx);
            if (e == null) {
                ctx.revert();
                return null;
            }
            ctx.commit();
            return combinator.combine(a, b, c, d, e);
        };
    }

    public static <T> Parser<List<T>> repeat(Parser<T> parser) {
        return context -> {
            Object res;
            ArrayList result = new ArrayList();
            while ((res = parser.parse(context)) != null) {
                result.add(res);
            }
            return result;
        };
    }

    public static <T> Parser<Optional<T>> optional(Parser<T> parser) {
        return context -> Optional.ofNullable(parser.parse(context));
    }

    @SafeVarargs
    public static <T> Parser<T> oneOf(Parser<? extends T> ... parsers) {
        return ctx -> {
            for (Parser parser : parsers) {
                Object r = parser.parse(ctx);
                if (r == null) continue;
                return r;
            }
            return null;
        };
    }

    public static interface PentaCombinator<A, B, C, D, E, R> {
        public R combine(A var1, B var2, C var3, D var4, E var5);
    }

    public static interface QuaterCombinator<A, B, C, D, R> {
        public R combine(A var1, B var2, C var3, D var4);
    }

    public static interface TerCombinator<A, B, C, R> {
        public R combine(A var1, B var2, C var3);
    }

    public static interface BiCombinator<A, B, R> {
        public R combine(A var1, B var2);
    }
}

