/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value.object.model;

import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import proguard.evaluation.MethodResult;
import proguard.evaluation.ValueCalculator;
import proguard.evaluation.executor.MethodExecutionInfo;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.object.model.Model;
import proguard.util.ArrayUtil;

public class ArrayModel
implements Model {
    private final Value[] values;
    private final String type;

    public ArrayModel(Value[] values, String type) {
        this.values = values;
        this.type = type;
    }

    public Value[] getValues() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    @Override
    @NotNull
    public String getType() {
        return this.type;
    }

    @Override
    public MethodResult init(MethodExecutionInfo methodExecutionInfo, ValueCalculator valueCalculator) {
        throw new UnsupportedOperationException("Constructors invocation is not supported in ArrayModel");
    }

    @Override
    public MethodResult invoke(MethodExecutionInfo methodExecutionInfo, ValueCalculator valueCalculator) {
        throw new UnsupportedOperationException("Instance method invocation is not supported in ArrayModel");
    }

    @Override
    public MethodResult invokeStatic(MethodExecutionInfo methodExecutionInfo, ValueCalculator valueCalculator) {
        throw new UnsupportedOperationException("Static method invocation is not supported in ArrayModel");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayModel)) {
            return false;
        }
        ArrayModel that = (ArrayModel)o;
        return Objects.equals(this.type, that.type) && ArrayUtil.equalOrNull(this.values, that.values);
    }

    public int hashCode() {
        int result = Objects.hash(this.type);
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }

    public String toString() {
        if (this.values == null) {
            return " null";
        }
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append("ArrayModel{");
        for (int index = 0; index < this.values.length; ++index) {
            builder.append(this.values[index]);
            builder.append(index < this.values.length - 1 ? (char)',' : '}');
        }
        return builder.toString();
    }
}

