/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.datastructure.callgraph;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import proguard.analysis.datastructure.callgraph.Call;
import proguard.analysis.datastructure.callgraph.Node;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.MethodSignature;
import proguard.util.CallGraphWalker;

public class CallGraph {
    private static final transient Logger log = LogManager.getLogger(CallGraph.class);
    public final Map<MethodSignature, Set<Call>> incoming;
    public final Map<MethodSignature, Set<Call>> outgoing;
    private final boolean concurrent;

    public CallGraph() {
        this(new HashMap<MethodSignature, Set<Call>>(), new HashMap<MethodSignature, Set<Call>>(), false);
    }

    protected CallGraph(Map<MethodSignature, Set<Call>> incoming, Map<MethodSignature, Set<Call>> outgoing, boolean concurrent) {
        this.incoming = incoming;
        this.outgoing = outgoing;
        this.concurrent = concurrent;
    }

    public static CallGraph concurrentCallGraph() {
        return new CallGraph(new ConcurrentHashMap<MethodSignature, Set<Call>>(), new ConcurrentHashMap<MethodSignature, Set<Call>>(), true);
    }

    public void addCall(Call call) {
        if (!(call.caller.signature instanceof MethodSignature)) {
            log.warn("Location of call {} is not a method", (Object)call);
            return;
        }
        if (call.getTarget() == null) {
            log.warn("Target of call {} is null", (Object)call);
            return;
        }
        this.outgoing.computeIfAbsent((MethodSignature)call.caller.signature, e -> this.newCallSet()).add(call);
        this.incoming.computeIfAbsent(call.getTarget(), e -> this.newCallSet()).add(call);
    }

    private Set<Call> newCallSet() {
        return this.concurrent ? Collections.synchronizedSet(new LinkedHashSet()) : new LinkedHashSet();
    }

    public void clear() {
        this.incoming.clear();
        this.outgoing.clear();
    }

    public Node reconstructCallGraph(ClassPool programClassPool, MethodSignature start, Set<MethodSignature> stopMethods) {
        return CallGraphWalker.predecessorPathsAccept(this, start, n -> this.handleUntil(programClassPool, (Node)n, stopMethods, null));
    }

    public Node reconstructCallGraph(ClassPool programClassPool, MethodSignature start, int maxDepth, int maxWidth, Set<MethodSignature> stopMethods) {
        return CallGraphWalker.predecessorPathsAccept(this, start, n -> this.handleUntil(programClassPool, (Node)n, stopMethods, null), maxDepth, maxWidth);
    }

    public Node reconstructCallGraph(ClassPool programClassPool, MethodSignature start, Set<MethodSignature> stopMethods, Set<MethodSignature> reachedMethods) {
        return CallGraphWalker.predecessorPathsAccept(this, start, n -> this.handleUntil(programClassPool, (Node)n, stopMethods, reachedMethods));
    }

    private boolean handleUntil(ClassPool programClassPool, Node current, Set<MethodSignature> stopMethods, @Nullable Set<MethodSignature> reachedMethods) {
        MethodSignature currentSignature = current.signature;
        String currentClassName = currentSignature.getClassName();
        Clazz currentClass = programClassPool.getClass(currentClassName);
        if (currentClass == null) {
            log.warn("Could not find class {} in class pool", (Object)currentClassName);
            current.isTruncated = true;
            return false;
        }
        if (stopMethods.contains(currentSignature)) {
            if (reachedMethods != null) {
                reachedMethods.add(currentSignature);
            }
            return false;
        }
        return true;
    }
}

