/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.signature.ast.signature;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import proguard.classfile.attribute.signature.ast.ASTStructureException;
import proguard.classfile.attribute.signature.ast.signature.AnyTypeArgumentNode;
import proguard.classfile.attribute.signature.ast.signature.BoundedTypeArgumentNode;
import proguard.classfile.attribute.signature.ast.visitor.ASTNodeVisitor;

public class TypeArgumentNode {
    @Nullable
    private AnyTypeArgumentNode anyTypeArg;
    @Nullable
    private BoundedTypeArgumentNode boundedTypeArg;

    public TypeArgumentNode(@NotNull AnyTypeArgumentNode anyTypeArg) {
        if (anyTypeArg == null) {
            throw new ASTStructureException("Argument must not be null.");
        }
        this.anyTypeArg = anyTypeArg;
        this.boundedTypeArg = null;
    }

    public TypeArgumentNode(@NotNull BoundedTypeArgumentNode boundedTypeArg) {
        if (boundedTypeArg == null) {
            throw new ASTStructureException("Argument must not be null.");
        }
        this.boundedTypeArg = boundedTypeArg;
        this.anyTypeArg = null;
    }

    public void changeToAnyTypeArgument() {
        this.anyTypeArg = AnyTypeArgumentNode.INSTANCE;
        this.boundedTypeArg = null;
    }

    public boolean isBounded() {
        return this.boundedTypeArg != null;
    }

    @Nullable
    public BoundedTypeArgumentNode getBoundedTypeArg() {
        return this.boundedTypeArg;
    }

    public void changeToBoundedTypeArgument(@NotNull BoundedTypeArgumentNode boundedTypeArg) {
        if (boundedTypeArg == null) {
            throw new ASTStructureException("Argument must not be null.");
        }
        this.boundedTypeArg = boundedTypeArg;
        this.anyTypeArg = null;
    }

    public <R, P> R accept(ASTNodeVisitor<R, P> visitor, P arg) {
        return visitor.visit(this, arg);
    }

    public String toString() {
        if (this.anyTypeArg != null) {
            return this.anyTypeArg.toString();
        }
        if (this.boundedTypeArg != null) {
            return this.boundedTypeArg.toString();
        }
        throw new ASTStructureException("At least one of the fields must be non-null");
    }
}

