/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.signature.ast.signature;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import proguard.classfile.attribute.signature.ast.ASTStructureException;
import proguard.classfile.attribute.signature.ast.descriptor.BaseTypeNode;
import proguard.classfile.attribute.signature.ast.signature.ReferenceTypeSignatureNode;
import proguard.classfile.attribute.signature.ast.visitor.ASTNodeVisitor;

public class TypeSignatureNode {
    @Nullable
    private ReferenceTypeSignatureNode referenceTypeSignature;
    @Nullable
    private BaseTypeNode baseType;

    public TypeSignatureNode(@NotNull BaseTypeNode baseType) {
        if (baseType == null) {
            throw new ASTStructureException("Argument must not be null.");
        }
        this.referenceTypeSignature = null;
        this.baseType = baseType;
    }

    public TypeSignatureNode(@NotNull ReferenceTypeSignatureNode referenceTypeSignature) {
        if (referenceTypeSignature == null) {
            throw new ASTStructureException("Argument must not be null.");
        }
        this.referenceTypeSignature = referenceTypeSignature;
        this.baseType = null;
    }

    public boolean isReferenceType() {
        return this.referenceTypeSignature != null;
    }

    @Nullable
    public ReferenceTypeSignatureNode getReferenceTypeSignature() {
        return this.referenceTypeSignature;
    }

    public void changeToReferenceType(@NotNull ReferenceTypeSignatureNode node) {
        if (node == null) {
            throw new ASTStructureException("Argument must not be null.");
        }
        this.referenceTypeSignature = node;
        this.baseType = null;
    }

    public boolean isBaseType() {
        return this.baseType != null;
    }

    @Nullable
    public BaseTypeNode getBaseType() {
        return this.baseType;
    }

    public void changeToBaseType(@NotNull BaseTypeNode node) {
        if (node == null) {
            throw new ASTStructureException("Argument must not be null.");
        }
        this.baseType = node;
        this.referenceTypeSignature = null;
    }

    public <R, P> R accept(ASTNodeVisitor<R, P> visitor, P arg) {
        return visitor.visit(this, arg);
    }

    public String toString() {
        if (this.referenceTypeSignature != null) {
            return this.referenceTypeSignature.toString();
        }
        if (this.baseType != null) {
            return this.baseType.toString();
        }
        throw new ASTStructureException("At least one of the fields must be non-null.");
    }
}

