/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.signature.grammars;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import proguard.classfile.attribute.signature.ast.signature.AnyTypeArgumentNode;
import proguard.classfile.attribute.signature.ast.signature.ArrayTypeSignatureNode;
import proguard.classfile.attribute.signature.ast.signature.BoundedTypeArgumentNode;
import proguard.classfile.attribute.signature.ast.signature.ClassTypeSignatureNode;
import proguard.classfile.attribute.signature.ast.signature.PackageSpecifierNode;
import proguard.classfile.attribute.signature.ast.signature.ReferenceTypeSignatureNode;
import proguard.classfile.attribute.signature.ast.signature.SimpleClassTypeSignatureNode;
import proguard.classfile.attribute.signature.ast.signature.TypeArgumentNode;
import proguard.classfile.attribute.signature.ast.signature.TypeSignatureNode;
import proguard.classfile.attribute.signature.ast.signature.TypeVariableSignatureNode;
import proguard.classfile.attribute.signature.ast.signature.WildcardIndicatorNode;
import proguard.classfile.attribute.signature.grammars.CommonTerminals;
import proguard.classfile.attribute.signature.parsing.Combinators;
import proguard.classfile.attribute.signature.parsing.LazyParser;
import proguard.classfile.attribute.signature.parsing.Parser;
import proguard.classfile.attribute.signature.parsing.Parsers;

public final class TypeSignatureGrammar {
    static final Parser<WildcardIndicatorNode> WILDCARD_INDICATOR = Combinators.oneOf(Parsers.fixedChar('+'), Parsers.fixedChar('-')).map(str -> {
        switch (str.charValue()) {
            case '+': {
                return WildcardIndicatorNode.PLUS;
            }
            case '-': {
                return WildcardIndicatorNode.MINUS;
            }
        }
        return null;
    });
    static LazyParser<ReferenceTypeSignatureNode> REFERENCE_TYPE_SIGNATURE = new LazyParser();
    static final Parser<PackageSpecifierNode> PACKAGE_SPECIFIER = Combinators.repeat(Combinators.chain(CommonTerminals.IDENTIFIER, Parsers.fixedChar('/'), (id, nothing) -> id)).map(PackageSpecifierNode::new);
    static final Parser<TypeArgumentNode> TYPE_ARGUMENT = Combinators.oneOf(Combinators.chain(Combinators.optional(WILDCARD_INDICATOR), REFERENCE_TYPE_SIGNATURE, (wildcard, reference) -> new TypeArgumentNode(new BoundedTypeArgumentNode(wildcard.orElse(null), (ReferenceTypeSignatureNode)reference))), Parsers.fixedChar('*').map(nothing -> new TypeArgumentNode(AnyTypeArgumentNode.INSTANCE)));
    static final Parser<List<TypeArgumentNode>> TYPE_ARGUMENTS = Combinators.chain(Parsers.fixedChar('<'), TYPE_ARGUMENT, Combinators.repeat(TYPE_ARGUMENT), Parsers.fixedChar('>'), (nothing, args1, otherArgs, nothing2) -> Stream.concat(Stream.of(args1), otherArgs.stream()).collect(Collectors.toList()));
    static final Parser<SimpleClassTypeSignatureNode> SIMPLE_CLASS_TYPE_SIGNATURE = Combinators.chain(CommonTerminals.IDENTIFIER, Combinators.optional(TYPE_ARGUMENTS), (id, args) -> new SimpleClassTypeSignatureNode((String)id, args.orElseGet(Collections::emptyList)));
    static final Parser<SimpleClassTypeSignatureNode> CLASS_TYPE_SIGNATURE_SUFFIX = Combinators.chain(Parsers.fixedChar('.'), SIMPLE_CLASS_TYPE_SIGNATURE, (nothing, signature) -> signature);
    static final Parser<TypeVariableSignatureNode> TYPE_VARIABLE_SIGNATURE = Combinators.chain(Parsers.fixedChar('T'), CommonTerminals.IDENTIFIER, Parsers.fixedChar(';'), (nothing, identifier, nothing2) -> new TypeVariableSignatureNode((String)identifier));
    static final Parser<TypeSignatureNode> JAVA_TYPE_SIGNATURE = Combinators.oneOf(REFERENCE_TYPE_SIGNATURE.map(TypeSignatureNode::new), CommonTerminals.BASE_TYPE.map(TypeSignatureNode::new));
    static final Parser<ArrayTypeSignatureNode> ARRAY_TYPE_SIGNATURE = Combinators.chain(Parsers.fixedChar('['), JAVA_TYPE_SIGNATURE, (nothing, signature) -> new ArrayTypeSignatureNode((TypeSignatureNode)signature));
    static final Parser<ClassTypeSignatureNode> CLASS_TYPE_SIGNATURE = Combinators.chain(Parsers.fixedChar('L'), Combinators.optional(PACKAGE_SPECIFIER), SIMPLE_CLASS_TYPE_SIGNATURE, Combinators.repeat(CLASS_TYPE_SIGNATURE_SUFFIX), Parsers.fixedChar(';'), (n1, pkg, name, suffix, n2) -> new ClassTypeSignatureNode(pkg.orElseGet(PackageSpecifierNode::new), (SimpleClassTypeSignatureNode)name, (List<SimpleClassTypeSignatureNode>)suffix));

    private TypeSignatureGrammar() {
    }

    @Nullable
    public static TypeSignatureNode parse(@NotNull String input) {
        return JAVA_TYPE_SIGNATURE.parse(input);
    }

    static {
        REFERENCE_TYPE_SIGNATURE.setDelegate(Combinators.oneOf(CLASS_TYPE_SIGNATURE.map(ReferenceTypeSignatureNode::new), TYPE_VARIABLE_SIGNATURE.map(ReferenceTypeSignatureNode::new), ARRAY_TYPE_SIGNATURE.map(ReferenceTypeSignatureNode::new)));
    }
}

