/*
 * Decompiled with CFR 0.152.
 */
package proguard.gradle.plugin.android;

import com.android.build.api.transform.Transform;
import com.android.build.gradle.AppExtension;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.api.ApplicationVariant;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.LibraryVariant;
import com.android.build.gradle.internal.res.LinkApplicationAndroidResourcesTask;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskOutputs;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import proguard.gradle.plugin.android.AndroidPlugin;
import proguard.gradle.plugin.android.AndroidPluginKt;
import proguard.gradle.plugin.android.AndroidProjectType;
import proguard.gradle.plugin.android.ProGuardTransform;
import proguard.gradle.plugin.android.dsl.ProGuardAndroidExtension;
import proguard.gradle.plugin.android.dsl.ProGuardConfiguration;
import proguard.gradle.plugin.android.dsl.UserProGuardConfiguration;
import proguard.gradle.plugin.android.dsl.VariantConfiguration;
import proguard.gradle.plugin.android.tasks.CollectConsumerRulesTask;
import proguard.gradle.plugin.android.tasks.PrepareProguardConfigDirectoryTask;
import proguard.gradle.plugin.android.transforms.AndroidConsumerRulesTransform;
import proguard.gradle.plugin.android.transforms.ArchiveConsumerRulesTransform;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001%B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u001e\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J.\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u001b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J0\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00132\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010#\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010$\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lproguard/gradle/plugin/android/AndroidPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "androidExtension", "Lcom/android/build/gradle/BaseExtension;", "(Lcom/android/build/gradle/BaseExtension;)V", "apply", "", "project", "checkConfigurationFile", "files", "", "Lproguard/gradle/plugin/android/dsl/ProGuardConfiguration;", "configureAapt", "copyConfigurationAttributes", "destConfiguration", "Lorg/gradle/api/artifacts/Configuration;", "srcConfiguration", "createCollectConsumerRulesTask", "Lorg/gradle/api/tasks/TaskProvider;", "Lproguard/gradle/plugin/android/tasks/CollectConsumerRulesTask;", "variant", "Lcom/android/build/gradle/api/BaseVariant;", "inputConfiguration", "outputDir", "Ljava/io/File;", "createConsumerRulesConfiguration", "disableAaptOutputCaching", "registerDependencyTransforms", "setupVariant", "Lproguard/gradle/plugin/android/dsl/VariantConfiguration;", "proguardBlock", "Lproguard/gradle/plugin/android/dsl/ProGuardAndroidExtension;", "collectConsumerRulesTask", "Lorg/gradle/api/Task;", "verifyNotMinified", "warnOldProguardVersion", "Companion", "gradle"})
public final class AndroidPlugin
implements Plugin<Project> {
    private final BaseExtension androidExtension;
    @NotNull
    public static final String COLLECT_CONSUMER_RULES_TASK_NAME = "collectConsumerRules";
    private static final String CONSUMER_RULES_PRO = "consumer-rules.pro";
    private static final String ARTIFACT_TYPE_CONSUMER_RULES = "proguard-consumer-rules";
    private static final Attribute<String> ATTRIBUTE_ARTIFACT_TYPE;
    public static final Companion Companion;

    public void apply(@NotNull Project project) {
        AndroidProjectType androidProjectType;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        TaskProvider collectConsumerRulesTask = project.getTasks().register(COLLECT_CONSUMER_RULES_TASK_NAME);
        this.registerDependencyTransforms(project);
        ProGuardAndroidExtension proguardBlock = (ProGuardAndroidExtension)project.getExtensions().create("proguard", ProGuardAndroidExtension.class, new Object[]{project});
        BaseExtension baseExtension = this.androidExtension;
        if (baseExtension instanceof AppExtension) {
            androidProjectType = AndroidProjectType.ANDROID_APPLICATION;
        } else if (baseExtension instanceof LibraryExtension) {
            androidProjectType = AndroidProjectType.ANDROID_LIBRARY;
        } else {
            throw (Throwable)new GradleException("The ProGuard Gradle plugin can only be used on Android application and library projects");
        }
        AndroidProjectType projectType = androidProjectType;
        this.configureAapt(project);
        this.warnOldProguardVersion(project);
        ProGuardAndroidExtension proGuardAndroidExtension = proguardBlock;
        Intrinsics.checkExpressionValueIsNotNull((Object)proGuardAndroidExtension, (String)"proguardBlock");
        Transform transform = new ProGuardTransform(project, proGuardAndroidExtension, projectType, this.androidExtension);
        Object[] objectArray = new Object[1];
        TaskProvider taskProvider = collectConsumerRulesTask;
        Intrinsics.checkExpressionValueIsNotNull((Object)taskProvider, (String)"collectConsumerRulesTask");
        objectArray[0] = taskProvider;
        this.androidExtension.registerTransform(transform, objectArray);
        project.afterEvaluate((Action)new Action<Project>(this, proguardBlock, collectConsumerRulesTask, project){
            final /* synthetic */ AndroidPlugin this$0;
            final /* synthetic */ ProGuardAndroidExtension $proguardBlock;
            final /* synthetic */ TaskProvider $collectConsumerRulesTask;
            final /* synthetic */ Project $project;

            public final void execute(Project it) {
                if (this.$proguardBlock.getConfigurations().isEmpty()) {
                    throw (Throwable)new GradleException("There are no configured variants in the 'proguard' block");
                }
                boolean bl = false;
                List matchedConfigurations = new ArrayList<E>();
                Object object = AndroidPlugin.access$getAndroidExtension$p(this.this$0);
                if (object instanceof AppExtension) {
                    ((AppExtension)AndroidPlugin.access$getAndroidExtension$p(this.this$0)).getApplicationVariants().all((Action)new Action<ApplicationVariant>(this, matchedConfigurations){
                        final /* synthetic */ apply.1 this$0;
                        final /* synthetic */ List $matchedConfigurations;

                        public final void execute(ApplicationVariant applicationVariant) {
                            block0: {
                                AndroidPlugin androidPlugin = this.this$0.this$0;
                                ProGuardAndroidExtension proGuardAndroidExtension = this.this$0.$proguardBlock;
                                Intrinsics.checkExpressionValueIsNotNull((Object)proGuardAndroidExtension, (String)"proguardBlock");
                                ApplicationVariant applicationVariant2 = applicationVariant;
                                Intrinsics.checkExpressionValueIsNotNull((Object)applicationVariant2, (String)"applicationVariant");
                                BaseVariant baseVariant = (BaseVariant)applicationVariant2;
                                TaskProvider taskProvider = this.this$0.$collectConsumerRulesTask;
                                Intrinsics.checkExpressionValueIsNotNull((Object)taskProvider, (String)"collectConsumerRulesTask");
                                VariantConfiguration variantConfiguration = AndroidPlugin.access$setupVariant(androidPlugin, proGuardAndroidExtension, baseVariant, taskProvider, this.this$0.$project);
                                if (variantConfiguration == null) break block0;
                                VariantConfiguration variantConfiguration2 = variantConfiguration;
                                boolean bl = false;
                                boolean bl2 = false;
                                VariantConfiguration it = variantConfiguration2;
                                boolean bl3 = false;
                                this.$matchedConfigurations.add(it);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$matchedConfigurations = list;
                        }
                    });
                } else if (object instanceof LibraryExtension) {
                    ((LibraryExtension)AndroidPlugin.access$getAndroidExtension$p(this.this$0)).getLibraryVariants().all((Action)new Action<LibraryVariant>(this, matchedConfigurations){
                        final /* synthetic */ apply.1 this$0;
                        final /* synthetic */ List $matchedConfigurations;

                        public final void execute(LibraryVariant libraryVariant) {
                            block0: {
                                AndroidPlugin androidPlugin = this.this$0.this$0;
                                ProGuardAndroidExtension proGuardAndroidExtension = this.this$0.$proguardBlock;
                                Intrinsics.checkExpressionValueIsNotNull((Object)proGuardAndroidExtension, (String)"proguardBlock");
                                LibraryVariant libraryVariant2 = libraryVariant;
                                Intrinsics.checkExpressionValueIsNotNull((Object)libraryVariant2, (String)"libraryVariant");
                                BaseVariant baseVariant = (BaseVariant)libraryVariant2;
                                TaskProvider taskProvider = this.this$0.$collectConsumerRulesTask;
                                Intrinsics.checkExpressionValueIsNotNull((Object)taskProvider, (String)"collectConsumerRulesTask");
                                VariantConfiguration variantConfiguration = AndroidPlugin.access$setupVariant(androidPlugin, proGuardAndroidExtension, baseVariant, taskProvider, this.this$0.$project);
                                if (variantConfiguration == null) break block0;
                                VariantConfiguration variantConfiguration2 = variantConfiguration;
                                boolean bl = false;
                                boolean bl2 = false;
                                VariantConfiguration it = variantConfiguration2;
                                boolean bl3 = false;
                                this.$matchedConfigurations.add(it);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$matchedConfigurations = list;
                        }
                    });
                }
                Iterable $this$forEach$iv = (Iterable)this.$proguardBlock.getConfigurations();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    VariantConfiguration it2 = (VariantConfiguration)element$iv;
                    boolean bl2 = false;
                    AndroidPlugin.access$checkConfigurationFile(this.this$0, this.$project, it2.getConfigurations());
                }
                object = SetsKt.minus((Set)((Set)this.$proguardBlock.getConfigurations()), (Iterable)matchedConfigurations);
                boolean bl3 = false;
                boolean bl4 = false;
                Object $this$apply = object;
                boolean bl5 = false;
                Collection collection = (Collection)$this$apply;
                boolean bl6 = false;
                if (!collection.isEmpty()) {
                    switch ($this$apply.size()) {
                        case 1: {
                            throw (Throwable)new GradleException("The configured variant '" + ((VariantConfiguration)CollectionsKt.first((Iterable)((Iterable)$this$apply))).getName() + "' does not exist");
                        }
                    }
                    throw (Throwable)new GradleException("The configured variants " + CollectionsKt.joinToString$default((Iterable)((Iterable)$this$apply), (CharSequence)"', '", (CharSequence)"'", (CharSequence)"'", (int)0, null, (Function1)apply.4.1.INSTANCE, (int)24, null) + " do not exist");
                }
            }
            {
                this.this$0 = androidPlugin;
                this.$proguardBlock = proGuardAndroidExtension;
                this.$collectConsumerRulesTask = taskProvider;
                this.$project = project;
            }
        });
    }

    private final void configureAapt(Project project) {
        TaskProvider createDirectoryTask = project.getTasks().register("prepareProguardConfigDirectory", PrepareProguardConfigDirectoryTask.class);
        project.getTasks().withType(LinkApplicationAndroidResourcesTask.class, (Action)new Action<LinkApplicationAndroidResourcesTask>(createDirectoryTask){
            final /* synthetic */ TaskProvider $createDirectoryTask;

            public final void execute(LinkApplicationAndroidResourcesTask it) {
                it.dependsOn(new Object[]{this.$createDirectoryTask});
            }
            {
                this.$createDirectoryTask = taskProvider;
            }
        });
        if (!AndroidPluginKt.getAaptAdditionalParameters(this.androidExtension).contains("--proguard")) {
            Collection<String> collection = AndroidPluginKt.getAaptAdditionalParameters(this.androidExtension);
            Object[] objectArray = new String[2];
            objectArray[0] = "--proguard";
            StringBuilder stringBuilder = new StringBuilder();
            File file = project.getBuildDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.buildDir");
            objectArray[1] = stringBuilder.append(file.getAbsolutePath()).append("/intermediates/proguard/configs/aapt_rules.pro").toString();
            collection.addAll(CollectionsKt.listOf((Object[])objectArray));
        }
        if (!AndroidPluginKt.getAaptAdditionalParameters(this.androidExtension).contains("--proguard-conditional-keep-rules")) {
            AndroidPluginKt.getAaptAdditionalParameters(this.androidExtension).add("--proguard-conditional-keep-rules");
        }
    }

    private final VariantConfiguration setupVariant(ProGuardAndroidExtension proguardBlock, BaseVariant variant, TaskProvider<Task> collectConsumerRulesTask, Project project) {
        Iterable iterable = (Iterable)proguardBlock.getConfigurations();
        String string = variant.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variant.name");
        VariantConfiguration matchingConfiguration = AndroidPluginKt.findVariantConfiguration((Iterable<VariantConfiguration>)iterable, string);
        if (matchingConfiguration != null) {
            this.verifyNotMinified(variant);
            this.disableAaptOutputCaching(project, variant);
            TaskFactoryUtils.dependsOn(collectConsumerRulesTask, (TaskProvider[])new TaskProvider[]{this.createCollectConsumerRulesTask(project, variant, this.createConsumerRulesConfiguration(project, variant), new File(project.getBuildDir() + "/intermediates/proguard/configs"))});
        }
        return matchingConfiguration;
    }

    private final TaskProvider<CollectConsumerRulesTask> createCollectConsumerRulesTask(Project project, BaseVariant variant, Configuration inputConfiguration, File outputDir) {
        TaskContainer taskContainer = project.getTasks();
        StringBuilder stringBuilder = new StringBuilder().append(COLLECT_CONSUMER_RULES_TASK_NAME);
        String string = variant.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variant.name");
        TaskProvider taskProvider = taskContainer.register(stringBuilder.append(StringsKt.capitalize((String)string)).toString(), CollectConsumerRulesTask.class, (Action)new Action<CollectConsumerRulesTask>(inputConfiguration, outputDir, variant){
            final /* synthetic */ Configuration $inputConfiguration;
            final /* synthetic */ File $outputDir;
            final /* synthetic */ BaseVariant $variant;

            public final void execute(CollectConsumerRulesTask it) {
                it.setConsumerRulesConfiguration(this.$inputConfiguration);
                it.setOutputFile(new File(new File(this.$outputDir, this.$variant.getDirName()), "consumer-rules.pro"));
                it.dependsOn(new Object[]{this.$inputConfiguration.getBuildDependencies()});
            }
            {
                this.$inputConfiguration = configuration;
                this.$outputDir = file;
                this.$variant = baseVariant;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)taskProvider, (String)"project.tasks.register(C\u2026ldDependencies)\n        }");
        return taskProvider;
    }

    private final Configuration createConsumerRulesConfiguration(Project project, BaseVariant variant) {
        Object object = project.getConfigurations().create(variant.getName() + "ProGuardConsumerRulesArtifacts", (Action)new Action<Configuration>(this, variant){
            final /* synthetic */ AndroidPlugin this$0;
            final /* synthetic */ BaseVariant $variant;

            public final void execute(Configuration it) {
                Configuration configuration = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"it");
                configuration.setCanBeResolved(true);
                it.setCanBeConsumed(false);
                it.setTransitive(true);
                it.extendsFrom(new Configuration[]{this.$variant.getRuntimeConfiguration()});
                Configuration configuration2 = this.$variant.getRuntimeConfiguration();
                Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"variant.runtimeConfiguration");
                AndroidPlugin.access$copyConfigurationAttributes(this.this$0, it, configuration2);
                it.getAttributes().attribute(AndroidPlugin.access$getATTRIBUTE_ARTIFACT_TYPE$cp(), (Object)"proguard-consumer-rules");
            }
            {
                this.this$0 = androidPlugin;
                this.$variant = baseVariant;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"project.configurations.c\u2026CONSUMER_RULES)\n        }");
        return (Configuration)object;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkConfigurationFile(Project project, List<? extends ProGuardConfiguration> files) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = files;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof UserProGuardConfiguration)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UserProGuardConfiguration it = (UserProGuardConfiguration)element$iv;
            boolean bl = false;
            File file = project.file((Object)it.getPath());
            if (file.exists()) continue;
            StringBuilder stringBuilder = new StringBuilder().append("ProGuard configuration file ");
            File file2 = file;
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
            throw (Throwable)new GradleException(stringBuilder.append(file2.getAbsolutePath()).append(" was set but does not exist.").toString());
        }
    }

    private final void verifyNotMinified(BaseVariant variant) {
        if (variant.getBuildType().isMinifyEnabled()) {
            throw (Throwable)new GradleException("The option 'minifyEnabled' is set to 'true' for variant '" + variant.getName() + "', but should be 'false' for variants processed by ProGuard");
        }
    }

    private final void copyConfigurationAttributes(Configuration destConfiguration, Configuration srcConfiguration) {
        Set set = srcConfiguration.getAttributes().keySet();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"srcConfiguration.attributes.keySet()");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Attribute attribute = (Attribute)element$iv;
            boolean bl = false;
            Object attributeValue = srcConfiguration.getAttributes().getAttribute(attribute);
            Attribute attribute2 = attribute;
            if (attribute2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.attributes.Attribute<kotlin.Any>");
            }
            destConfiguration.getAttributes().attribute(attribute2, attributeValue);
        }
    }

    private final void registerDependencyTransforms(Project project) {
        project.getDependencies().registerTransform(ArchiveConsumerRulesTransform.class, (Action)registerDependencyTransforms.1.INSTANCE);
        project.getDependencies().registerTransform(ArchiveConsumerRulesTransform.class, (Action)registerDependencyTransforms.2.INSTANCE);
        project.getDependencies().registerTransform(AndroidConsumerRulesTransform.class, (Action)registerDependencyTransforms.3.INSTANCE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void disableAaptOutputCaching(Project project, BaseVariant variant) {
        Task processResourcesTask;
        if (!project.hasProperty("org.gradle.caching")) return;
        Object object = project.findProperty("org.gradle.caching");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        String string = (String)object;
        boolean bl = false;
        String string2 = string;
        boolean bl2 = false;
        if (!Boolean.parseBoolean(string2)) return;
        boolean bl3 = true;
        boolean cachingEnabled = bl3;
        if (!cachingEnabled) return;
        TaskContainer taskContainer = project.getTasks();
        StringBuilder stringBuilder = new StringBuilder().append("process");
        String string3 = variant.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"variant.name");
        Task task = processResourcesTask = (Task)taskContainer.findByName(stringBuilder.append(StringsKt.capitalize((String)string3)).append("Resources").toString());
        Task task2 = task;
        if (task == null) return;
        TaskOutputs taskOutputs = task2.getOutputs();
        task2 = taskOutputs;
        if (taskOutputs == null) return;
        task2.doNotCacheIf("We need to regenerate the aapt_rules.pro file, sorry!", (Spec)new Spec<Task>(project, variant){
            final /* synthetic */ Project $project;
            final /* synthetic */ BaseVariant $variant;

            public final boolean isSatisfiedBy(Task it) {
                this.$project.getLogger().debug("Disabling AAPT caching for " + this.$variant.getName());
                StringBuilder stringBuilder = new StringBuilder();
                File file = this.$project.getBuildDir();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.buildDir");
                return !new File(stringBuilder.append(file.getAbsolutePath()).append("/intermediates/proguard/configs/aapt_rules.pro").toString()).exists();
            }
            {
                this.$project = project;
                this.$variant = baseVariant;
            }
        });
    }

    private final void warnOldProguardVersion(Project project) {
        Class<?> proguardTask;
        if (AndroidPluginKt.getAgpVersion().getMajor() >= 7) {
            return;
        }
        String message = "An older version of ProGuard has been detected on the classpath which can clash with ProGuard Gradle Plugin.\nThis is likely due to a transitive dependency introduced by Android Gradle plugin.\n\nPlease update your configuration to exclude the old version of ProGuard, for example:\n\nbuildscript {\n    // ... \n    dependencies {\n        // ...\n        classpath(\"com.android.tools.build:gradle:x.y.z\") {\n            exclude group: \"net.sf.proguard\", module: \"proguard-gradle\"\n            // or for kotlin (build.gradle.kts):\n            // exclude(group = \"net.sf.proguard\", module = \"proguard-gradle\")\n        }\n   }\n}";
        Class<?> clazz = proguardTask = Class.forName("proguard.gradle.ProGuardTask");
        Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"proguardTask");
        Method[] methodArray = clazz.getMethods();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodArray, (String)"proguardTask.methods");
        Method[] $this$count$iv = methodArray;
        boolean $i$f$count = false;
        int count$iv = 0;
        Method[] methodArray2 = $this$count$iv;
        int n = methodArray2.length;
        for (int i = 0; i < n; ++i) {
            Method element$iv;
            Method it = element$iv = methodArray2[i];
            boolean bl = false;
            Method method = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"it");
            if (!Intrinsics.areEqual((Object)method.getName(), (Object)"extraJar")) continue;
            ++count$iv;
        }
        if (count$iv == 0) {
            throw (Throwable)new GradleException(message);
        }
        Project project2 = project.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project.rootProject");
        ScriptHandler scriptHandler = project2.getBuildscript();
        Intrinsics.checkExpressionValueIsNotNull((Object)scriptHandler, (String)"project.rootProject.buildscript");
        scriptHandler.getConfigurations().all((Action)new Action<Configuration>(project, message){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $message;

            /*
             * Unable to fully structure code
             */
            public final void execute(Configuration it) {
                block4: {
                    block3: {
                        v0 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"it");
                        v1 = v0.getResolvedConfiguration();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it.resolvedConfiguration");
                        v2 = v1.getResolvedArtifacts();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it.resolvedConfiguration.resolvedArtifacts");
                        var2_2 = v2;
                        var3_3 = false;
                        var4_4 = var2_2;
                        var5_6 = false;
                        for (T var7_10 : var4_4) {
                            it = (ResolvedArtifact)var7_10;
                            $i$a$-find-AndroidPlugin$warnOldProguardVersion$2$1 = false;
                            v3 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
                            v4 = v3.getModuleVersion();
                            Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"it.moduleVersion");
                            v5 = v4.getId();
                            Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"it.moduleVersion.id");
                            v6 = v5.getModule();
                            Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"it.moduleVersion.id.module");
                            if (!v6.getGroup().equals("net.sf.proguard")) ** GOTO lbl-1000
                            v7 = it.getModuleVersion();
                            Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"it.moduleVersion");
                            v8 = v7.getId();
                            Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"it.moduleVersion.id");
                            v9 = v8.getModule();
                            Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"it.moduleVersion.id.module");
                            if (v9.getName().equals("proguard-gradle")) {
                                v10 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v10 = false;
                            }
                            if (!v10) continue;
                            v11 = var7_10;
                            break block3;
                        }
                        v11 = null;
                    }
                    v12 = v11;
                    if (v12 == null) break block4;
                    var2_2 = v12;
                    var3_3 = false;
                    var4_5 = false;
                    it = var2_2;
                    $i$a$-let-AndroidPlugin$warnOldProguardVersion$2$2 = false;
                    this.$project.getLogger().warn(this.$message);
                }
            }
            {
                this.$project = project;
                this.$message = string;
            }
        });
    }

    public AndroidPlugin(@NotNull BaseExtension androidExtension) {
        Intrinsics.checkParameterIsNotNull((Object)androidExtension, (String)"androidExtension");
        this.androidExtension = androidExtension;
    }

    static {
        Companion = new Companion(null);
        ATTRIBUTE_ARTIFACT_TYPE = Attribute.of((String)"artifactType", String.class);
    }

    public static final /* synthetic */ BaseExtension access$getAndroidExtension$p(AndroidPlugin $this) {
        return $this.androidExtension;
    }

    public static final /* synthetic */ VariantConfiguration access$setupVariant(AndroidPlugin $this, ProGuardAndroidExtension proguardBlock, BaseVariant variant, TaskProvider collectConsumerRulesTask, Project project) {
        return $this.setupVariant(proguardBlock, variant, (TaskProvider<Task>)collectConsumerRulesTask, project);
    }

    public static final /* synthetic */ void access$checkConfigurationFile(AndroidPlugin $this, Project project, List files) {
        $this.checkConfigurationFile(project, files);
    }

    public static final /* synthetic */ void access$copyConfigurationAttributes(AndroidPlugin $this, Configuration destConfiguration, Configuration srcConfiguration) {
        $this.copyConfigurationAttributes(destConfiguration, srcConfiguration);
    }

    public static final /* synthetic */ Attribute access$getATTRIBUTE_ARTIFACT_TYPE$cp() {
        return ATTRIBUTE_ARTIFACT_TYPE;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R2\u0010\u0005\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00040\u0004 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00040\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lproguard/gradle/plugin/android/AndroidPlugin$Companion;", "", "()V", "ARTIFACT_TYPE_CONSUMER_RULES", "", "ATTRIBUTE_ARTIFACT_TYPE", "Lorg/gradle/api/attributes/Attribute;", "kotlin.jvm.PlatformType", "COLLECT_CONSUMER_RULES_TASK_NAME", "CONSUMER_RULES_PRO", "gradle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

