/*
 * Decompiled with CFR 0.152.
 */
package proguard.gradle.plugin.android;

import com.android.build.api.transform.Transform;
import com.android.build.gradle.AppExtension;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.api.ApplicationVariant;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.LibraryVariant;
import com.android.build.gradle.internal.res.LinkApplicationAndroidResourcesTask;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.transform.TransformSpec;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskOutputs;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import proguard.gradle.plugin.android.AndroidPlugin;
import proguard.gradle.plugin.android.AndroidPluginKt;
import proguard.gradle.plugin.android.AndroidProjectType;
import proguard.gradle.plugin.android.ProGuardTransform;
import proguard.gradle.plugin.android.dsl.ProGuardAndroidExtension;
import proguard.gradle.plugin.android.dsl.ProGuardConfiguration;
import proguard.gradle.plugin.android.dsl.UserProGuardConfiguration;
import proguard.gradle.plugin.android.dsl.VariantConfiguration;
import proguard.gradle.plugin.android.tasks.CollectConsumerRulesTask;
import proguard.gradle.plugin.android.tasks.ConsumerRuleFilterEntry;
import proguard.gradle.plugin.android.tasks.PrepareProguardConfigDirectoryTask;
import proguard.gradle.plugin.android.transforms.AndroidConsumerRulesTransform;
import proguard.gradle.plugin.android.transforms.ArchiveConsumerRulesTransform;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 (2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001(B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u001e\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J<\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u001e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J0\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u00132\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010&\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010'\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lproguard/gradle/plugin/android/AndroidPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "androidExtension", "Lcom/android/build/gradle/BaseExtension;", "(Lcom/android/build/gradle/BaseExtension;)V", "apply", "", "project", "checkConfigurationFile", "files", "", "Lproguard/gradle/plugin/android/dsl/ProGuardConfiguration;", "configureAapt", "copyConfigurationAttributes", "destConfiguration", "Lorg/gradle/api/artifacts/Configuration;", "srcConfiguration", "createCollectConsumerRulesTask", "Lorg/gradle/api/tasks/TaskProvider;", "Lproguard/gradle/plugin/android/tasks/CollectConsumerRulesTask;", "variant", "Lcom/android/build/gradle/api/BaseVariant;", "inputConfiguration", "consumerRuleFilter", "", "", "outputDir", "Ljava/io/File;", "createConsumerRulesConfiguration", "disableAaptOutputCaching", "registerDependencyTransforms", "setupVariant", "Lproguard/gradle/plugin/android/dsl/VariantConfiguration;", "proguardBlock", "Lproguard/gradle/plugin/android/dsl/ProGuardAndroidExtension;", "collectConsumerRulesTask", "Lorg/gradle/api/Task;", "verifyNotMinified", "warnOldProguardVersion", "Companion", "gradle"})
public final class AndroidPlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BaseExtension androidExtension;
    @NotNull
    public static final String COLLECT_CONSUMER_RULES_TASK_NAME = "collectConsumerRules";
    @NotNull
    private static final String CONSUMER_RULES_PRO = "consumer-rules.pro";
    @NotNull
    private static final String ARTIFACT_TYPE_CONSUMER_RULES = "proguard-consumer-rules";
    private static final Attribute<String> ATTRIBUTE_ARTIFACT_TYPE = Attribute.of((String)"artifactType", String.class);

    public AndroidPlugin(@NotNull BaseExtension androidExtension) {
        Intrinsics.checkNotNullParameter((Object)androidExtension, (String)"androidExtension");
        this.androidExtension = androidExtension;
    }

    public void apply(@NotNull Project project) {
        AndroidProjectType androidProjectType;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        TaskProvider collectConsumerRulesTask = project.getTasks().register(COLLECT_CONSUMER_RULES_TASK_NAME);
        this.registerDependencyTransforms(project);
        Object[] objectArray = new Object[]{project};
        ProGuardAndroidExtension proguardBlock = (ProGuardAndroidExtension)project.getExtensions().create("proguard", ProGuardAndroidExtension.class, objectArray);
        Object[] objectArray2 = this.androidExtension;
        if (objectArray2 instanceof AppExtension) {
            androidProjectType = AndroidProjectType.ANDROID_APPLICATION;
        } else if (objectArray2 instanceof LibraryExtension) {
            androidProjectType = AndroidProjectType.ANDROID_LIBRARY;
        } else {
            throw new GradleException("The ProGuard Gradle plugin can only be used on Android application and library projects");
        }
        AndroidProjectType projectType = androidProjectType;
        this.configureAapt(project);
        this.warnOldProguardVersion(project);
        Intrinsics.checkNotNullExpressionValue((Object)proguardBlock, (String)"proguardBlock");
        Transform transform2 = new ProGuardTransform(project, proguardBlock, projectType, this.androidExtension);
        objectArray2 = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)collectConsumerRulesTask, (String)"collectConsumerRulesTask");
        objectArray2[0] = collectConsumerRulesTask;
        this.androidExtension.registerTransform(transform2, objectArray2);
        project.afterEvaluate(arg_0 -> AndroidPlugin.apply$lambda-6(proguardBlock, this, collectConsumerRulesTask, project, arg_0));
    }

    private final void configureAapt(Project project) {
        TaskProvider createDirectoryTask = project.getTasks().register("prepareProguardConfigDirectory", PrepareProguardConfigDirectoryTask.class);
        project.getTasks().withType(LinkApplicationAndroidResourcesTask.class, arg_0 -> AndroidPlugin.configureAapt$lambda-7(createDirectoryTask, arg_0));
        if (!AndroidPluginKt.getAaptAdditionalParameters(this.androidExtension).contains("--proguard")) {
            Object[] objectArray = new String[]{"--proguard", Intrinsics.stringPlus((String)project.getBuildDir().getAbsolutePath(), (Object)"/intermediates/proguard/configs/aapt_rules.pro")};
            AndroidPluginKt.getAaptAdditionalParameters(this.androidExtension).addAll(CollectionsKt.listOf((Object[])objectArray));
        }
        if (!AndroidPluginKt.getAaptAdditionalParameters(this.androidExtension).contains("--proguard-conditional-keep-rules")) {
            AndroidPluginKt.getAaptAdditionalParameters(this.androidExtension).add("--proguard-conditional-keep-rules");
        }
    }

    private final VariantConfiguration setupVariant(ProGuardAndroidExtension proguardBlock, BaseVariant variant, TaskProvider<Task> collectConsumerRulesTask, Project project) {
        Iterable iterable = (Iterable)proguardBlock.getConfigurations();
        TaskProvider[] taskProviderArray = variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)taskProviderArray, (String)"variant.name");
        VariantConfiguration matchingConfiguration = AndroidPluginKt.findVariantConfiguration((Iterable<VariantConfiguration>)iterable, (String)taskProviderArray);
        if (matchingConfiguration != null) {
            this.verifyNotMinified(variant);
            this.disableAaptOutputCaching(project, variant);
            taskProviderArray = new TaskProvider[]{this.createCollectConsumerRulesTask(project, variant, this.createConsumerRulesConfiguration(project, variant), matchingConfiguration.getConsumerRuleFilter(), new File(project.getBuildDir() + "/intermediates/proguard/configs"))};
            TaskFactoryUtils.dependsOn(collectConsumerRulesTask, (TaskProvider[])taskProviderArray);
        }
        return matchingConfiguration;
    }

    private final TaskProvider<CollectConsumerRulesTask> createCollectConsumerRulesTask(Project project, BaseVariant variant, Configuration inputConfiguration, List<String> consumerRuleFilter, File outputDir) {
        TaskContainer taskContainer = project.getTasks();
        String string = variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variant.name");
        TaskProvider taskProvider = taskContainer.register(Intrinsics.stringPlus((String)COLLECT_CONSUMER_RULES_TASK_NAME, (Object)StringsKt.capitalize((String)string)), CollectConsumerRulesTask.class, arg_0 -> AndroidPlugin.createCollectConsumerRulesTask$lambda-9(inputConfiguration, consumerRuleFilter, outputDir, variant, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"project.tasks.register(C\u2026ldDependencies)\n        }");
        return taskProvider;
    }

    private final Configuration createConsumerRulesConfiguration(Project project, BaseVariant variant) {
        Object object = project.getConfigurations().create(Intrinsics.stringPlus((String)variant.getName(), (Object)"ProGuardConsumerRulesArtifacts"), arg_0 -> AndroidPlugin.createConsumerRulesConfiguration$lambda-10(variant, this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.configurations.c\u2026CONSUMER_RULES)\n        }");
        return (Configuration)object;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkConfigurationFile(Project project, List<? extends ProGuardConfiguration> files) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = files;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof UserProGuardConfiguration)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UserProGuardConfiguration it = (UserProGuardConfiguration)element$iv;
            boolean bl = false;
            File file = project.file((Object)it.getPath());
            if (file.exists()) continue;
            throw new GradleException("ProGuard configuration file " + file.getAbsolutePath() + " was set but does not exist.");
        }
    }

    private final void verifyNotMinified(BaseVariant variant) {
        if (variant.getBuildType().isMinifyEnabled()) {
            throw new GradleException("The option 'minifyEnabled' is set to 'true' for variant '" + variant.getName() + "', but should be 'false' for variants processed by ProGuard");
        }
    }

    private final void copyConfigurationAttributes(Configuration destConfiguration, Configuration srcConfiguration) {
        Set set = srcConfiguration.getAttributes().keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"srcConfiguration.attributes.keySet()");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Attribute attribute = (Attribute)element$iv;
            boolean bl = false;
            Object attributeValue = srcConfiguration.getAttributes().getAttribute(attribute);
            Attribute attribute2 = attribute;
            if (attribute2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.attributes.Attribute<kotlin.Any>");
            }
            destConfiguration.getAttributes().attribute(attribute2, attributeValue);
        }
    }

    private final void registerDependencyTransforms(Project project) {
        project.getDependencies().registerTransform(ArchiveConsumerRulesTransform.class, AndroidPlugin::registerDependencyTransforms$lambda-13);
        project.getDependencies().registerTransform(ArchiveConsumerRulesTransform.class, AndroidPlugin::registerDependencyTransforms$lambda-14);
        project.getDependencies().registerTransform(AndroidConsumerRulesTransform.class, AndroidPlugin::registerDependencyTransforms$lambda-15);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void disableAaptOutputCaching(Project project, BaseVariant variant) {
        Task processResourcesTask;
        if (!project.hasProperty("org.gradle.caching")) return;
        Object object = project.findProperty("org.gradle.caching");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        if (!Boolean.parseBoolean((String)object)) return;
        boolean bl = true;
        boolean cachingEnabled = bl;
        if (!cachingEnabled) return;
        TaskContainer taskContainer = project.getTasks();
        StringBuilder stringBuilder = new StringBuilder().append("process");
        String string = variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variant.name");
        Task task = processResourcesTask = (Task)taskContainer.findByName(stringBuilder.append(StringsKt.capitalize((String)string)).append("Resources").toString());
        if (task == null) return;
        TaskOutputs taskOutputs = task.getOutputs();
        if (taskOutputs == null) return;
        taskOutputs.doNotCacheIf("We need to regenerate the aapt_rules.pro file, sorry!", arg_0 -> AndroidPlugin.disableAaptOutputCaching$lambda-16(project, variant, arg_0));
    }

    private final void warnOldProguardVersion(Project project) {
        if (AndroidPluginKt.getAgpVersion().getMajorVersion() >= 7) {
            return;
        }
        String message = "An older version of ProGuard has been detected on the classpath which can clash with ProGuard Gradle Plugin.\nThis is likely due to a transitive dependency introduced by Android Gradle plugin.\n\nPlease update your configuration to exclude the old version of ProGuard, for example:\n\nbuildscript {\n    // ... \n    dependencies {\n        // ...\n        classpath(\"com.android.tools.build:gradle:x.y.z\") {\n            exclude group: \"net.sf.proguard\", module: \"proguard-gradle\"\n            // or for kotlin (build.gradle.kts):\n            // exclude(group = \"net.sf.proguard\", module = \"proguard-gradle\")\n        }\n   }\n}";
        Class<?> proguardTask = Class.forName("proguard.gradle.ProGuardTask");
        Method[] methodArray = proguardTask.getMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"proguardTask.methods");
        Object[] $this$count$iv = methodArray;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (Object element$iv : $this$count$iv) {
            Method it = (Method)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)"extraJar")) continue;
            ++count$iv;
        }
        if (count$iv == 0) {
            throw new GradleException(message);
        }
        project.getRootProject().getBuildscript().getConfigurations().all(arg_0 -> AndroidPlugin.warnOldProguardVersion$lambda-20(project, message, arg_0));
    }

    private static final void apply$lambda-6$lambda-1(AndroidPlugin this$0, ProGuardAndroidExtension $proguardBlock, TaskProvider $collectConsumerRulesTask, Project $project, List $matchedConfigurations, ApplicationVariant applicationVariant) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$matchedConfigurations, (String)"$matchedConfigurations");
        Intrinsics.checkNotNullExpressionValue((Object)$proguardBlock, (String)"proguardBlock");
        Intrinsics.checkNotNullExpressionValue((Object)applicationVariant, (String)"applicationVariant");
        BaseVariant baseVariant = (BaseVariant)applicationVariant;
        Intrinsics.checkNotNullExpressionValue((Object)$collectConsumerRulesTask, (String)"collectConsumerRulesTask");
        VariantConfiguration variantConfiguration = this$0.setupVariant($proguardBlock, baseVariant, (TaskProvider<Task>)$collectConsumerRulesTask, $project);
        if (variantConfiguration != null) {
            VariantConfiguration it = variantConfiguration;
            boolean bl = false;
            $matchedConfigurations.add(it);
        }
    }

    private static final void apply$lambda-6$lambda-3(AndroidPlugin this$0, ProGuardAndroidExtension $proguardBlock, TaskProvider $collectConsumerRulesTask, Project $project, List $matchedConfigurations, LibraryVariant libraryVariant) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$matchedConfigurations, (String)"$matchedConfigurations");
        Intrinsics.checkNotNullExpressionValue((Object)$proguardBlock, (String)"proguardBlock");
        Intrinsics.checkNotNullExpressionValue((Object)libraryVariant, (String)"libraryVariant");
        BaseVariant baseVariant = (BaseVariant)libraryVariant;
        Intrinsics.checkNotNullExpressionValue((Object)$collectConsumerRulesTask, (String)"collectConsumerRulesTask");
        VariantConfiguration variantConfiguration = this$0.setupVariant($proguardBlock, baseVariant, (TaskProvider<Task>)$collectConsumerRulesTask, $project);
        if (variantConfiguration != null) {
            VariantConfiguration it = variantConfiguration;
            boolean bl = false;
            $matchedConfigurations.add(it);
        }
    }

    private static final void apply$lambda-6(ProGuardAndroidExtension $proguardBlock, AndroidPlugin this$0, TaskProvider $collectConsumerRulesTask, Project $project, Project it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        if ($proguardBlock.getConfigurations().isEmpty()) {
            throw new GradleException("There are no configured variants in the 'proguard' block");
        }
        List matchedConfigurations = new ArrayList();
        Object object = this$0.androidExtension;
        if (object instanceof AppExtension) {
            ((AppExtension)this$0.androidExtension).getApplicationVariants().all(arg_0 -> AndroidPlugin.apply$lambda-6$lambda-1(this$0, $proguardBlock, $collectConsumerRulesTask, $project, matchedConfigurations, arg_0));
        } else if (object instanceof LibraryExtension) {
            ((LibraryExtension)this$0.androidExtension).getLibraryVariants().all(arg_0 -> AndroidPlugin.apply$lambda-6$lambda-3(this$0, $proguardBlock, $collectConsumerRulesTask, $project, matchedConfigurations, arg_0));
        }
        Iterable $this$forEach$iv = (Iterable)$proguardBlock.getConfigurations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VariantConfiguration it2 = (VariantConfiguration)element$iv;
            boolean bl = false;
            this$0.checkConfigurationFile($project, it2.getConfigurations());
        }
        Object $this$apply_u24lambda_u2d6_u24lambda_u2d5 = object = SetsKt.minus((Set)((Set)$proguardBlock.getConfigurations()), (Iterable)matchedConfigurations);
        boolean bl = false;
        if (!((Collection)$this$apply_u24lambda_u2d6_u24lambda_u2d5).isEmpty()) {
            if ($this$apply_u24lambda_u2d6_u24lambda_u2d5.size() == 1) {
                throw new GradleException("The configured variant '" + ((VariantConfiguration)CollectionsKt.first((Iterable)((Iterable)$this$apply_u24lambda_u2d6_u24lambda_u2d5))).getName() + "' does not exist");
            }
            throw new GradleException("The configured variants " + CollectionsKt.joinToString$default((Iterable)((Iterable)$this$apply_u24lambda_u2d6_u24lambda_u2d5), (CharSequence)"', '", (CharSequence)"'", (CharSequence)"'", (int)0, null, (Function1)apply.1.4.1.INSTANCE, (int)24, null) + " do not exist");
        }
    }

    private static final void configureAapt$lambda-7(TaskProvider $createDirectoryTask, LinkApplicationAndroidResourcesTask it) {
        Object[] objectArray = new Object[]{$createDirectoryTask};
        it.dependsOn(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ConsumerRuleFilterEntry> createCollectConsumerRulesTask$parseConsumerRuleFilter(List<String> consumerRuleFilter) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = consumerRuleFilter;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void filter;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            char[] cArray = new char[]{':'};
            List splits = StringsKt.split$default((CharSequence)((CharSequence)filter), (char[])cArray, (boolean)false, (int)0, (int)6, null);
            if (splits.size() != 2) {
                throw new GradleException("Invalid consumer rule filter entry: " + (String)filter + "\nExpected an entry of the form: <group>:<module>");
            }
            collection.add(new ConsumerRuleFilterEntry((String)splits.get(0), (String)splits.get(1)));
        }
        return (List)destination$iv$iv;
    }

    private static final void createCollectConsumerRulesTask$lambda-9(Configuration $inputConfiguration, List $consumerRuleFilter, File $outputDir, BaseVariant $variant, CollectConsumerRulesTask it) {
        Intrinsics.checkNotNullParameter((Object)$inputConfiguration, (String)"$inputConfiguration");
        Intrinsics.checkNotNullParameter((Object)$consumerRuleFilter, (String)"$consumerRuleFilter");
        Intrinsics.checkNotNullParameter((Object)$outputDir, (String)"$outputDir");
        Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
        it.setConsumerRulesConfiguration($inputConfiguration);
        it.setConsumerRuleFilter(AndroidPlugin.createCollectConsumerRulesTask$parseConsumerRuleFilter($consumerRuleFilter));
        it.setOutputFile(new File(new File($outputDir, $variant.getDirName()), CONSUMER_RULES_PRO));
        Object[] objectArray = new Object[]{$inputConfiguration.getBuildDependencies()};
        it.dependsOn(objectArray);
    }

    private static final void createConsumerRulesConfiguration$lambda-10(BaseVariant $variant, AndroidPlugin this$0, Configuration it) {
        Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        it.setCanBeResolved(true);
        it.setCanBeConsumed(false);
        it.setTransitive(true);
        Configuration configuration = new Configuration[]{$variant.getRuntimeConfiguration()};
        it.extendsFrom((Configuration[])configuration);
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        configuration = $variant.getRuntimeConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"variant.runtimeConfiguration");
        this$0.copyConfigurationAttributes(it, configuration);
        it.getAttributes().attribute(ATTRIBUTE_ARTIFACT_TYPE, (Object)ARTIFACT_TYPE_CONSUMER_RULES);
    }

    private static final void registerDependencyTransforms$lambda-13(TransformSpec it) {
        it.getFrom().attribute(ATTRIBUTE_ARTIFACT_TYPE, (Object)"aar");
        it.getTo().attribute(ATTRIBUTE_ARTIFACT_TYPE, (Object)ARTIFACT_TYPE_CONSUMER_RULES);
    }

    private static final void registerDependencyTransforms$lambda-14(TransformSpec it) {
        it.getFrom().attribute(ATTRIBUTE_ARTIFACT_TYPE, (Object)"jar");
        it.getTo().attribute(ATTRIBUTE_ARTIFACT_TYPE, (Object)ARTIFACT_TYPE_CONSUMER_RULES);
    }

    private static final void registerDependencyTransforms$lambda-15(TransformSpec it) {
        it.getFrom().attribute(ATTRIBUTE_ARTIFACT_TYPE, (Object)"android-consumer-proguard-rules");
        it.getTo().attribute(ATTRIBUTE_ARTIFACT_TYPE, (Object)ARTIFACT_TYPE_CONSUMER_RULES);
    }

    private static final boolean disableAaptOutputCaching$lambda-16(Project $project, BaseVariant $variant, Task it) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
        $project.getLogger().debug(Intrinsics.stringPlus((String)"Disabling AAPT caching for ", (Object)$variant.getName()));
        return !new File(Intrinsics.stringPlus((String)$project.getBuildDir().getAbsolutePath(), (Object)"/intermediates/proguard/configs/aapt_rules.pro")).exists();
    }

    private static final void warnOldProguardVersion$lambda-20(Project $project, String $message, Configuration it) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
            Set set = it.getResolvedConfiguration().getResolvedArtifacts();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"it.resolvedConfiguration.resolvedArtifacts");
            for (Object t : (Iterable)set) {
                ResolvedArtifact it2 = (ResolvedArtifact)t;
                boolean bl = false;
                if (!(it2.getModuleVersion().getId().getModule().getGroup().equals("net.sf.proguard") && it2.getModuleVersion().getId().getModule().getName().equals("proguard-gradle"))) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        ResolvedArtifact resolvedArtifact = v0;
        if (resolvedArtifact != null) {
            ResolvedArtifact it3 = resolvedArtifact;
            boolean bl = false;
            $project.getLogger().warn($message);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R2\u0010\u0005\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00040\u0004 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00040\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lproguard/gradle/plugin/android/AndroidPlugin$Companion;", "", "()V", "ARTIFACT_TYPE_CONSUMER_RULES", "", "ATTRIBUTE_ARTIFACT_TYPE", "Lorg/gradle/api/attributes/Attribute;", "kotlin.jvm.PlatformType", "COLLECT_CONSUMER_RULES_TASK_NAME", "CONSUMER_RULES_PRO", "gradle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

