/*
 * Decompiled with CFR 0.152.
 */
package proguard.gradle.plugin.android;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.SecondaryFile;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.api.variant.VariantInfo;
import com.android.build.gradle.BaseExtension;
import com.android.builder.core.LibraryRequest;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import proguard.gradle.ProGuardTask;
import proguard.gradle.plugin.android.AndroidPluginKt;
import proguard.gradle.plugin.android.AndroidProjectType;
import proguard.gradle.plugin.android.dsl.ProGuardAndroidExtension;
import proguard.gradle.plugin.android.dsl.ProGuardConfiguration;
import proguard.gradle.plugin.android.dsl.UserProGuardConfiguration;
import proguard.gradle.plugin.android.dsl.VariantConfiguration;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J4\u0010\u000f\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011j\u0002`\u00130\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0016J\b\u0010\u001f\u001a\u00020\u001bH\u0016J\u0010\u0010 \u001a\n\u0012\u0006\b\u0000\u0012\u00020\"0!H\u0016J\u0010\u0010#\u001a\n\u0012\u0006\b\u0000\u0012\u00020\"0!H\u0016J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0016J\b\u0010'\u001a\u00020\fH\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lproguard/gradle/plugin/android/ProGuardTransform;", "Lcom/android/build/api/transform/Transform;", "project", "Lorg/gradle/api/Project;", "proguardBlock", "Lproguard/gradle/plugin/android/dsl/ProGuardAndroidExtension;", "projectType", "Lproguard/gradle/plugin/android/AndroidProjectType;", "androidExtension", "Lcom/android/build/gradle/BaseExtension;", "(Lorg/gradle/api/Project;Lproguard/gradle/plugin/android/dsl/ProGuardAndroidExtension;Lproguard/gradle/plugin/android/AndroidProjectType;Lcom/android/build/gradle/BaseExtension;)V", "applyToVariant", "", "variant", "Lcom/android/build/api/variant/VariantInfo;", "createIOEntries", "", "Lkotlin/Pair;", "Ljava/io/File;", "Lproguard/gradle/plugin/android/ProGuardIOEntry;", "inputs", "", "Lcom/android/build/api/transform/TransformInput;", "outputProvider", "Lcom/android/build/api/transform/TransformOutputProvider;", "createLibraryJars", "getAaptRulesFile", "", "getInputTypes", "", "Lcom/android/build/api/transform/QualifiedContent$DefaultContentType;", "getName", "getReferencedScopes", "", "Lcom/android/build/api/transform/QualifiedContent$Scope;", "getScopes", "getSecondaryFiles", "", "Lcom/android/build/api/transform/SecondaryFile;", "isIncremental", "transform", "", "transformInvocation", "Lcom/android/build/api/transform/TransformInvocation;", "gradle"})
public final class ProGuardTransform
extends Transform {
    @NotNull
    private final Project project;
    @NotNull
    private final ProGuardAndroidExtension proguardBlock;
    @NotNull
    private final AndroidProjectType projectType;
    @NotNull
    private final BaseExtension androidExtension;

    public ProGuardTransform(@NotNull Project project, @NotNull ProGuardAndroidExtension proguardBlock, @NotNull AndroidProjectType projectType, @NotNull BaseExtension androidExtension) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)proguardBlock, (String)"proguardBlock");
        Intrinsics.checkNotNullParameter((Object)((Object)projectType), (String)"projectType");
        Intrinsics.checkNotNullParameter((Object)androidExtension, (String)"androidExtension");
        this.project = project;
        this.proguardBlock = proguardBlock;
        this.projectType = projectType;
        this.androidExtension = androidExtension;
    }

    /*
     * WARNING - void declaration
     */
    public void transform(@NotNull TransformInvocation transformInvocation) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)transformInvocation, (String)"transformInvocation");
        String string = transformInvocation.getContext().getVariantName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"transformInvocation.context.variantName");
        String variantName = string;
        VariantConfiguration variantConfiguration = AndroidPluginKt.findVariantConfiguration((Iterable<VariantConfiguration>)((Iterable)this.proguardBlock.getConfigurations()), variantName);
        if (variantConfiguration == null) {
            throw new RuntimeException(Intrinsics.stringPlus((String)"Invalid configuration: ", (Object)variantName));
        }
        VariantConfiguration variantBlock = variantConfiguration;
        ProGuardTask proguardTask = (ProGuardTask)this.project.getTasks().create(Intrinsics.stringPlus((String)"proguardTask", (Object)StringsKt.capitalize((String)variantName)), ProGuardTask.class);
        Collection collection = transformInvocation.getInputs();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"transformInvocation.inputs");
        Collection collection2 = collection;
        collection = transformInvocation.getOutputProvider();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"transformInvocation.outputProvider");
        Object $this$forEach$iv = (Object[])this.createIOEntries(collection2, (TransformOutputProvider)collection);
        boolean $i$f$forEach = false;
        for (Object t : $this$forEach$iv) {
            Pair it = (Pair)t;
            boolean bl = false;
            proguardTask.injars(it.getFirst());
            proguardTask.outjars(it.getSecond());
        }
        $this$forEach$iv = new QualifiedContent.DefaultContentType[]{QualifiedContent.DefaultContentType.CLASSES, QualifiedContent.DefaultContentType.RESOURCES};
        Set set = SetsKt.setOf((Object[])$this$forEach$iv);
        $this$forEach$iv = new QualifiedContent.Scope[]{QualifiedContent.Scope.PROJECT};
        proguardTask.extraJar(transformInvocation.getOutputProvider().getContentLocation("extra.jar", set, SetsKt.mutableSetOf((Object[])$this$forEach$iv), Format.JAR));
        $this$forEach$iv = transformInvocation.getReferencedInputs();
        Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv, (String)"transformInvocation.referencedInputs");
        proguardTask.libraryjars(this.createLibraryJars((Collection<? extends TransformInput>)$this$forEach$iv));
        proguardTask.configuration(this.project.getTasks().getByPath(Intrinsics.stringPlus((String)"collectConsumerRules", (Object)StringsKt.capitalize((String)variantName))).getOutputs().getFiles());
        $this$forEach$iv = variantBlock.getConfigurations();
        ProGuardTask proGuardTask = proguardTask;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection collection3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ProGuardConfiguration proGuardConfiguration = (ProGuardConfiguration)item$iv$iv;
            Collection collection4 = collection3;
            boolean bl = false;
            collection4.add(this.project.file((Object)it.getPath()));
        }
        proGuardTask.configuration((List)collection3);
        String aaptRulesFile = this.getAaptRulesFile();
        if (aaptRulesFile != null && new File(aaptRulesFile).exists()) {
            proguardTask.configuration(aaptRulesFile);
        } else {
            this.project.getLogger().warn("AAPT rules file not found: you may need to apply some extra keep rules for classes referenced from resources in your own ProGuard configuration.");
        }
        File mappingDir = new File(this.project.getBuildDir().getAbsolutePath() + "/outputs/proguard/" + variantName + "/mapping");
        if (!mappingDir.exists()) {
            mappingDir.mkdirs();
        }
        proguardTask.printmapping(new File(mappingDir, "mapping.txt"));
        proguardTask.printseeds(new File(mappingDir, "seeds.txt"));
        proguardTask.printusage(new File(mappingDir, "usage.txt"));
        proguardTask.android();
        proguardTask.proguard();
    }

    @NotNull
    public String getName() {
        return "ProguardTransform";
    }

    @NotNull
    public Set<QualifiedContent.DefaultContentType> getInputTypes() {
        Object[] objectArray = new QualifiedContent.DefaultContentType[]{QualifiedContent.DefaultContentType.CLASSES, QualifiedContent.DefaultContentType.RESOURCES};
        return SetsKt.setOf((Object[])objectArray);
    }

    @NotNull
    public Set<? super QualifiedContent.Scope> getScopes() {
        Set set;
        switch (WhenMappings.$EnumSwitchMapping$0[this.projectType.ordinal()]) {
            case 1: {
                Object[] objectArray = new QualifiedContent.Scope[]{QualifiedContent.Scope.PROJECT, QualifiedContent.Scope.SUB_PROJECTS, QualifiedContent.Scope.EXTERNAL_LIBRARIES};
                set = SetsKt.mutableSetOf((Object[])objectArray);
                break;
            }
            case 2: {
                Object[] objectArray = new QualifiedContent.Scope[]{QualifiedContent.Scope.PROJECT};
                set = SetsKt.mutableSetOf((Object[])objectArray);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return set;
    }

    @NotNull
    public Set<? super QualifiedContent.Scope> getReferencedScopes() {
        Set set;
        switch (WhenMappings.$EnumSwitchMapping$0[this.projectType.ordinal()]) {
            case 1: {
                Object[] objectArray = new QualifiedContent.Scope[]{QualifiedContent.Scope.PROVIDED_ONLY};
                set = SetsKt.mutableSetOf((Object[])objectArray);
                break;
            }
            case 2: {
                Object[] objectArray = new QualifiedContent.Scope[]{QualifiedContent.Scope.PROVIDED_ONLY, QualifiedContent.Scope.EXTERNAL_LIBRARIES, QualifiedContent.Scope.SUB_PROJECTS};
                set = SetsKt.mutableSetOf((Object[])objectArray);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return set;
    }

    public boolean isIncremental() {
        return false;
    }

    public boolean applyToVariant(@Nullable VariantInfo variant) {
        VariantConfiguration variantConfiguration;
        VariantInfo variantInfo = variant;
        if (variantInfo == null) {
            variantConfiguration = null;
        } else {
            VariantInfo it = variantInfo;
            boolean bl = false;
            variantConfiguration = AndroidPluginKt.findVariantConfiguration((Iterable<VariantConfiguration>)((Iterable)this.proguardBlock.getConfigurations()), it);
        }
        return variantConfiguration != null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<SecondaryFile> getSecondaryFiles() {
        Set set;
        void $this$mapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Object list$iv$iv;
        VariantConfiguration it;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = (Iterable)this.proguardBlock.getConfigurations();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (VariantConfiguration)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.getConfigurations();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filterIsInstance = false;
        $this$flatMapTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof UserProGuardConfiguration)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (UserProGuardConfiguration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new SecondaryFile(this.project.file((Object)((ProGuardConfiguration)((Object)it)).getPath()), false));
        }
        Set $this$getSecondaryFiles_u24lambda_u2d6 = set = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
        boolean bl = false;
        String string = this.getAaptRulesFile();
        if (string != null) {
            String it2 = string;
            boolean bl2 = false;
            $this$getSecondaryFiles_u24lambda_u2d6.add(new SecondaryFile(this.project.file((Object)it2), false));
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<File, File>> createIOEntries(Collection<? extends TransformInput> inputs, TransformOutputProvider outputProvider) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = inputs;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            JarInput it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            TransformInput input = (TransformInput)element$iv$iv;
            boolean bl = false;
            Collection collection2 = input.getDirectoryInputs();
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"input.directoryInputs");
            Iterable $this$map$iv = collection2;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                DirectoryInput directoryInput = (DirectoryInput)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                collection.add(ProGuardTransform.createIOEntries$createEntry(outputProvider, (QualifiedContent)it, Format.DIRECTORY));
            }
            Collection collection3 = (List)destination$iv$iv2;
            $this$map$iv = input.getJarInputs();
            Intrinsics.checkNotNullExpressionValue((Object)$this$map$iv, (String)"input.jarInputs");
            collection = collection3;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (JarInput)item$iv$iv;
                Collection collection4 = destination$iv$iv2;
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                collection4.add(ProGuardTransform.createIOEntries$createEntry(outputProvider, (QualifiedContent)it, Format.JAR));
            }
            Iterable list$iv$iv = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv2));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> createLibraryJars(Collection<? extends TransformInput> inputs) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object list$iv$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = inputs;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            JarInput it;
            Collection collection;
            Iterable $this$mapTo$iv$iv2;
            TransformInput input = (TransformInput)element$iv$iv;
            boolean bl = false;
            Collection collection2 = input.getDirectoryInputs();
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"input.directoryInputs");
            Iterable $this$map$iv2 = collection2;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                DirectoryInput directoryInput = (DirectoryInput)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(it.getFile());
            }
            Collection collection3 = (List)destination$iv$iv2;
            $this$map$iv2 = input.getJarInputs();
            Intrinsics.checkNotNullExpressionValue((Object)$this$map$iv2, (String)"input.jarInputs");
            collection = collection3;
            $i$f$map = false;
            $this$mapTo$iv$iv2 = $this$map$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                it = (JarInput)item$iv$iv;
                Collection collection4 = destination$iv$iv2;
                boolean bl3 = false;
                collection4.add(it.getFile());
            }
            list$iv$iv = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv2));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = this.androidExtension.getLibraryRequests();
        Collection collection = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)CollectionsKt.listOf((Object)new File(this.androidExtension.getSdkDirectory(), "platforms/" + this.androidExtension.getCompileSdkVersion() + "/android.jar")));
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            list$iv$iv = (LibraryRequest)item$iv$iv;
            Collection collection5 = destination$iv$iv;
            boolean bl = false;
            collection5.add(new File(this.androidExtension.getSdkDirectory(), "platforms/" + this.androidExtension.getCompileSdkVersion() + "/optional/" + it.getName() + ".jar"));
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final String getAaptRulesFile() {
        Object v1;
        block4: {
            List list;
            Iterable $this$zipWithNext$iv = AndroidPluginKt.getAaptAdditionalParameters(this.androidExtension);
            boolean $i$f$zipWithNext = false;
            Iterator iterator$iv = $this$zipWithNext$iv.iterator();
            if (!iterator$iv.hasNext()) {
                list = CollectionsKt.emptyList();
            } else {
                List result$iv = new ArrayList();
                Object current$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void param;
                    void cmd;
                    Object next$iv = iterator$iv.next();
                    String string = (String)next$iv;
                    String string2 = (String)current$iv;
                    List list2 = result$iv;
                    boolean bl = false;
                    list2.add(Intrinsics.areEqual((Object)cmd, (Object)"--proguard") ? param : null);
                    current$iv = next$iv;
                }
                list = result$iv;
            }
            Iterable $this$firstOrNull$iv = CollectionsKt.filterNotNull((Iterable)list);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!new File(it).exists()) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        return v1;
    }

    private static final Pair<File, File> createIOEntries$createEntry(TransformOutputProvider $outputProvider, QualifiedContent input, Format format) {
        File file = input.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"input.file");
        File file2 = file;
        file = $outputProvider.getContentLocation(input.getName(), input.getContentTypes(), input.getScopes(), format).getCanonicalFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"outputProvider.getConten\u2026es, format).canonicalFile");
        return new Pair((Object)file2, (Object)file);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AndroidProjectType.values().length];
            nArray[AndroidProjectType.ANDROID_APPLICATION.ordinal()] = 1;
            nArray[AndroidProjectType.ANDROID_LIBRARY.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

