/*
 * Decompiled with CFR 0.152.
 */
package proguard.gradle.plugin.android;

import com.android.build.api.transform.Transform;
import com.android.build.gradle.AppExtension;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.api.ApplicationVariant;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.LibraryVariant;
import com.android.build.gradle.internal.res.LinkApplicationAndroidResourcesTask;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskOutputs;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import proguard.gradle.plugin.android.AndroidPlugin;
import proguard.gradle.plugin.android.AndroidPluginKt;
import proguard.gradle.plugin.android.AndroidProjectType;
import proguard.gradle.plugin.android.ProGuardTransform;
import proguard.gradle.plugin.android.dsl.ProGuardAndroidExtension;
import proguard.gradle.plugin.android.dsl.ProGuardConfiguration;
import proguard.gradle.plugin.android.dsl.UserProGuardConfiguration;
import proguard.gradle.plugin.android.dsl.VariantConfiguration;
import proguard.gradle.plugin.android.tasks.CollectConsumerRulesTask;
import proguard.gradle.plugin.android.tasks.ConsumerRuleFilterEntry;
import proguard.gradle.plugin.android.tasks.PrepareProguardConfigDirectoryTask;
import proguard.gradle.plugin.android.transforms.AndroidConsumerRulesTransform;
import proguard.gradle.plugin.android.transforms.ArchiveConsumerRulesTransform;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 (2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001(B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u001e\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J<\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u001e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J0\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u00132\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010&\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010'\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lproguard/gradle/plugin/android/AndroidPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "androidExtension", "Lcom/android/build/gradle/BaseExtension;", "(Lcom/android/build/gradle/BaseExtension;)V", "apply", "", "project", "checkConfigurationFile", "files", "", "Lproguard/gradle/plugin/android/dsl/ProGuardConfiguration;", "configureAapt", "copyConfigurationAttributes", "destConfiguration", "Lorg/gradle/api/artifacts/Configuration;", "srcConfiguration", "createCollectConsumerRulesTask", "Lorg/gradle/api/tasks/TaskProvider;", "Lproguard/gradle/plugin/android/tasks/CollectConsumerRulesTask;", "variant", "Lcom/android/build/gradle/api/BaseVariant;", "inputConfiguration", "consumerRuleFilter", "", "", "outputDir", "Ljava/io/File;", "createConsumerRulesConfiguration", "disableAaptOutputCaching", "registerDependencyTransforms", "setupVariant", "Lproguard/gradle/plugin/android/dsl/VariantConfiguration;", "proguardBlock", "Lproguard/gradle/plugin/android/dsl/ProGuardAndroidExtension;", "collectConsumerRulesTask", "Lorg/gradle/api/Task;", "verifyNotMinified", "warnOldProguardVersion", "Companion", "gradle"})
public final class AndroidPlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BaseExtension androidExtension;
    @NotNull
    public static final String COLLECT_CONSUMER_RULES_TASK_NAME = "collectConsumerRules";
    @NotNull
    private static final String CONSUMER_RULES_PRO = "consumer-rules.pro";
    @NotNull
    private static final String ARTIFACT_TYPE_CONSUMER_RULES = "proguard-consumer-rules";
    private static final Attribute<String> ATTRIBUTE_ARTIFACT_TYPE = Attribute.of((String)"artifactType", String.class);

    public AndroidPlugin(@NotNull BaseExtension androidExtension) {
        Intrinsics.checkNotNullParameter((Object)androidExtension, (String)"androidExtension");
        this.androidExtension = androidExtension;
    }

    public void apply(@NotNull Project project) {
        AndroidProjectType androidProjectType;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        TaskProvider collectConsumerRulesTask = project.getTasks().register(COLLECT_CONSUMER_RULES_TASK_NAME);
        this.registerDependencyTransforms(project);
        Object[] objectArray = new Object[]{project};
        ProGuardAndroidExtension proguardBlock = (ProGuardAndroidExtension)project.getExtensions().create("proguard", ProGuardAndroidExtension.class, objectArray);
        Object[] objectArray2 = this.androidExtension;
        if (objectArray2 instanceof AppExtension) {
            androidProjectType = AndroidProjectType.ANDROID_APPLICATION;
        } else if (objectArray2 instanceof LibraryExtension) {
            androidProjectType = AndroidProjectType.ANDROID_LIBRARY;
        } else {
            throw new GradleException("The ProGuard Gradle plugin can only be used on Android application and library projects");
        }
        AndroidProjectType projectType = androidProjectType;
        this.configureAapt(project);
        this.warnOldProguardVersion(project);
        Intrinsics.checkNotNullExpressionValue((Object)proguardBlock, (String)"proguardBlock");
        Transform transform2 = new ProGuardTransform(project, proguardBlock, projectType, this.androidExtension);
        objectArray2 = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)collectConsumerRulesTask, (String)"collectConsumerRulesTask");
        objectArray2[0] = collectConsumerRulesTask;
        this.androidExtension.registerTransform(transform2, objectArray2);
        project.afterEvaluate(arg_0 -> AndroidPlugin.apply$lambda$0((Function1)new Function1<Project, Unit>(proguardBlock, this, (TaskProvider<Task>)collectConsumerRulesTask, project){
            final /* synthetic */ ProGuardAndroidExtension $proguardBlock;
            final /* synthetic */ AndroidPlugin this$0;
            final /* synthetic */ TaskProvider<Task> $collectConsumerRulesTask;
            final /* synthetic */ Project $project;
            {
                this.$proguardBlock = $proguardBlock;
                this.this$0 = $receiver;
                this.$collectConsumerRulesTask = $collectConsumerRulesTask;
                this.$project = $project;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(Project it) {
                void $this$forEach$iv;
                if (this.$proguardBlock.getConfigurations().isEmpty()) {
                    throw new GradleException("There are no configured variants in the 'proguard' block");
                }
                List matchedConfigurations = new ArrayList<E>();
                Object object = AndroidPlugin.access$getAndroidExtension$p(this.this$0);
                if (object instanceof AppExtension) {
                    ((AppExtension)AndroidPlugin.access$getAndroidExtension$p(this.this$0)).getApplicationVariants().all(arg_0 -> apply.1.invoke$lambda$0((Function1)new Function1<ApplicationVariant, Unit>(this.this$0, this.$proguardBlock, this.$collectConsumerRulesTask, this.$project, (List<VariantConfiguration>)matchedConfigurations){
                        final /* synthetic */ AndroidPlugin this$0;
                        final /* synthetic */ ProGuardAndroidExtension $proguardBlock;
                        final /* synthetic */ TaskProvider<Task> $collectConsumerRulesTask;
                        final /* synthetic */ Project $project;
                        final /* synthetic */ List<VariantConfiguration> $matchedConfigurations;
                        {
                            this.this$0 = $receiver;
                            this.$proguardBlock = $proguardBlock;
                            this.$collectConsumerRulesTask = $collectConsumerRulesTask;
                            this.$project = $project;
                            this.$matchedConfigurations = $matchedConfigurations;
                            super(1);
                        }

                        public final void invoke(ApplicationVariant applicationVariant) {
                            block0: {
                                ProGuardAndroidExtension proGuardAndroidExtension = this.$proguardBlock;
                                Intrinsics.checkNotNullExpressionValue((Object)proGuardAndroidExtension, (String)"proguardBlock");
                                Intrinsics.checkNotNullExpressionValue((Object)applicationVariant, (String)"applicationVariant");
                                BaseVariant baseVariant = (BaseVariant)applicationVariant;
                                TaskProvider<Task> taskProvider = this.$collectConsumerRulesTask;
                                Intrinsics.checkNotNullExpressionValue(taskProvider, (String)"collectConsumerRulesTask");
                                VariantConfiguration variantConfiguration = AndroidPlugin.access$setupVariant(this.this$0, proGuardAndroidExtension, baseVariant, taskProvider, this.$project);
                                if (variantConfiguration == null) break block0;
                                VariantConfiguration variantConfiguration2 = variantConfiguration;
                                List<VariantConfiguration> list = this.$matchedConfigurations;
                                VariantConfiguration it = variantConfiguration2;
                                boolean bl = false;
                                list.add(it);
                            }
                        }
                    }, arg_0));
                } else if (object instanceof LibraryExtension) {
                    ((LibraryExtension)AndroidPlugin.access$getAndroidExtension$p(this.this$0)).getLibraryVariants().all(arg_0 -> apply.1.invoke$lambda$1((Function1)new Function1<LibraryVariant, Unit>(this.this$0, this.$proguardBlock, this.$collectConsumerRulesTask, this.$project, (List<VariantConfiguration>)matchedConfigurations){
                        final /* synthetic */ AndroidPlugin this$0;
                        final /* synthetic */ ProGuardAndroidExtension $proguardBlock;
                        final /* synthetic */ TaskProvider<Task> $collectConsumerRulesTask;
                        final /* synthetic */ Project $project;
                        final /* synthetic */ List<VariantConfiguration> $matchedConfigurations;
                        {
                            this.this$0 = $receiver;
                            this.$proguardBlock = $proguardBlock;
                            this.$collectConsumerRulesTask = $collectConsumerRulesTask;
                            this.$project = $project;
                            this.$matchedConfigurations = $matchedConfigurations;
                            super(1);
                        }

                        public final void invoke(LibraryVariant libraryVariant) {
                            block0: {
                                ProGuardAndroidExtension proGuardAndroidExtension = this.$proguardBlock;
                                Intrinsics.checkNotNullExpressionValue((Object)proGuardAndroidExtension, (String)"proguardBlock");
                                Intrinsics.checkNotNullExpressionValue((Object)libraryVariant, (String)"libraryVariant");
                                BaseVariant baseVariant = (BaseVariant)libraryVariant;
                                TaskProvider<Task> taskProvider = this.$collectConsumerRulesTask;
                                Intrinsics.checkNotNullExpressionValue(taskProvider, (String)"collectConsumerRulesTask");
                                VariantConfiguration variantConfiguration = AndroidPlugin.access$setupVariant(this.this$0, proGuardAndroidExtension, baseVariant, taskProvider, this.$project);
                                if (variantConfiguration == null) break block0;
                                VariantConfiguration variantConfiguration2 = variantConfiguration;
                                List<VariantConfiguration> list = this.$matchedConfigurations;
                                VariantConfiguration it = variantConfiguration2;
                                boolean bl = false;
                                list.add(it);
                            }
                        }
                    }, arg_0));
                }
                object = (Iterable)this.$proguardBlock.getConfigurations();
                AndroidPlugin androidPlugin = this.this$0;
                Project project = this.$project;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    VariantConfiguration it2 = (VariantConfiguration)element$iv;
                    boolean bl = false;
                    AndroidPlugin.access$checkConfigurationFile(androidPlugin, project, it2.getConfigurations());
                }
                Object $this$invoke_u24lambda_u243 = object = SetsKt.minus((Set)((Set)this.$proguardBlock.getConfigurations()), (Iterable)matchedConfigurations);
                boolean bl = false;
                if (!((Collection)$this$invoke_u24lambda_u243).isEmpty()) {
                    if ($this$invoke_u24lambda_u243.size() == 1) {
                        throw new GradleException("The configured variant '" + ((VariantConfiguration)CollectionsKt.first((Iterable)((Iterable)$this$invoke_u24lambda_u243))).getName() + "' does not exist");
                    }
                    throw new GradleException("The configured variants " + CollectionsKt.joinToString$default((Iterable)((Iterable)$this$invoke_u24lambda_u243), (CharSequence)"', '", (CharSequence)"'", (CharSequence)"'", (int)0, null, (Function1)apply.4.1.INSTANCE, (int)24, null) + " do not exist");
                }
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }

            private static final void invoke$lambda$1(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }, arg_0));
    }

    private final void configureAapt(Project project) {
        TaskProvider createDirectoryTask = project.getTasks().register("prepareProguardConfigDirectory", PrepareProguardConfigDirectoryTask.class);
        project.getTasks().withType(LinkApplicationAndroidResourcesTask.class, arg_0 -> AndroidPlugin.configureAapt$lambda$1((Function1)new Function1<LinkApplicationAndroidResourcesTask, Unit>((TaskProvider<PrepareProguardConfigDirectoryTask>)createDirectoryTask){
            final /* synthetic */ TaskProvider<PrepareProguardConfigDirectoryTask> $createDirectoryTask;
            {
                this.$createDirectoryTask = $createDirectoryTask;
                super(1);
            }

            public final void invoke(LinkApplicationAndroidResourcesTask it) {
                Object[] objectArray = new Object[]{this.$createDirectoryTask};
                it.dependsOn(objectArray);
            }
        }, arg_0));
        if (!AndroidPluginKt.getAaptAdditionalParameters(this.androidExtension).contains("--proguard")) {
            Collection<String> collection = AndroidPluginKt.getAaptAdditionalParameters(this.androidExtension);
            Object[] objectArray = new String[2];
            objectArray[0] = "--proguard";
            File file = project.getBuildDir();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.buildDir");
            objectArray[1] = FilesKt.resolve((File)file, (String)"intermediates/proguard/configs/aapt_rules.pro").getAbsolutePath();
            collection.addAll(CollectionsKt.listOf((Object[])objectArray));
        }
        if (!AndroidPluginKt.getAaptAdditionalParameters(this.androidExtension).contains("--proguard-conditional-keep-rules")) {
            AndroidPluginKt.getAaptAdditionalParameters(this.androidExtension).add("--proguard-conditional-keep-rules");
        }
    }

    private final VariantConfiguration setupVariant(ProGuardAndroidExtension proguardBlock, BaseVariant variant, TaskProvider<Task> collectConsumerRulesTask, Project project) {
        Iterable iterable = (Iterable)proguardBlock.getConfigurations();
        String string = variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variant.name");
        VariantConfiguration matchingConfiguration = AndroidPluginKt.findVariantConfiguration((Iterable<VariantConfiguration>)iterable, string);
        if (matchingConfiguration != null) {
            this.verifyNotMinified(variant);
            this.disableAaptOutputCaching(project, variant);
            TaskProvider[] taskProviderArray = new TaskProvider[1];
            Configuration configuration = this.createConsumerRulesConfiguration(project, variant);
            List<String> list = matchingConfiguration.getConsumerRuleFilter();
            File file = project.getBuildDir();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.buildDir");
            taskProviderArray[0] = this.createCollectConsumerRulesTask(project, variant, configuration, list, FilesKt.resolve((File)file, (String)"intermediates/proguard/configs"));
            TaskFactoryUtils.dependsOn(collectConsumerRulesTask, (TaskProvider[])taskProviderArray);
        }
        return matchingConfiguration;
    }

    private final TaskProvider<CollectConsumerRulesTask> createCollectConsumerRulesTask(Project project, BaseVariant variant, Configuration inputConfiguration, List<String> consumerRuleFilter, File outputDir) {
        TaskContainer taskContainer = project.getTasks();
        StringBuilder stringBuilder = new StringBuilder().append(COLLECT_CONSUMER_RULES_TASK_NAME);
        String string = variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variant.name");
        TaskProvider taskProvider = taskContainer.register(stringBuilder.append(StringsKt.capitalize((String)string)).toString(), CollectConsumerRulesTask.class, arg_0 -> AndroidPlugin.createCollectConsumerRulesTask$lambda$3((Function1)new Function1<CollectConsumerRulesTask, Unit>(inputConfiguration, consumerRuleFilter, outputDir, variant){
            final /* synthetic */ Configuration $inputConfiguration;
            final /* synthetic */ List<String> $consumerRuleFilter;
            final /* synthetic */ File $outputDir;
            final /* synthetic */ BaseVariant $variant;
            {
                this.$inputConfiguration = $inputConfiguration;
                this.$consumerRuleFilter = $consumerRuleFilter;
                this.$outputDir = $outputDir;
                this.$variant = $variant;
                super(1);
            }

            public final void invoke(CollectConsumerRulesTask it) {
                it.setConsumerRulesConfiguration(this.$inputConfiguration);
                it.setConsumerRuleFilter(AndroidPlugin.access$createCollectConsumerRulesTask$parseConsumerRuleFilter(this.$consumerRuleFilter));
                it.setOutputFile(new File(new File(this.$outputDir, this.$variant.getDirName()), "consumer-rules.pro"));
                Object[] objectArray = new Object[]{this.$inputConfiguration.getBuildDependencies()};
                it.dependsOn(objectArray);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"variant: BaseVariant,\n  \u2026ldDependencies)\n        }");
        return taskProvider;
    }

    private final Configuration createConsumerRulesConfiguration(Project project, BaseVariant variant) {
        Object object = project.getConfigurations().create(variant.getName() + "ProGuardConsumerRulesArtifacts", arg_0 -> AndroidPlugin.createConsumerRulesConfiguration$lambda$4((Function1)new Function1<Configuration, Unit>(variant, this){
            final /* synthetic */ BaseVariant $variant;
            final /* synthetic */ AndroidPlugin this$0;
            {
                this.$variant = $variant;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Configuration it) {
                it.setCanBeResolved(true);
                it.setCanBeConsumed(false);
                it.setTransitive(true);
                Configuration[] configurationArray = new Configuration[]{this.$variant.getRuntimeConfiguration()};
                it.extendsFrom(configurationArray);
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                Configuration configuration = this.$variant.getRuntimeConfiguration();
                Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"variant.runtimeConfiguration");
                AndroidPlugin.access$copyConfigurationAttributes(this.this$0, it, configuration);
                it.getAttributes().attribute(AndroidPlugin.access$getATTRIBUTE_ARTIFACT_TYPE$cp(), (Object)"proguard-consumer-rules");
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"private fun createConsum\u2026CONSUMER_RULES)\n        }");
        return (Configuration)object;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkConfigurationFile(Project project, List<? extends ProGuardConfiguration> files) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = files;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof UserProGuardConfiguration)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UserProGuardConfiguration it = (UserProGuardConfiguration)element$iv;
            boolean bl = false;
            File file = project.file((Object)it.getPath());
            if (file.exists()) continue;
            throw new GradleException("ProGuard configuration file " + file.getAbsolutePath() + " was set but does not exist.");
        }
    }

    private final void verifyNotMinified(BaseVariant variant) {
        if (variant.getBuildType().isMinifyEnabled()) {
            throw new GradleException("The option 'minifyEnabled' is set to 'true' for variant '" + variant.getName() + "', but should be 'false' for variants processed by ProGuard");
        }
    }

    private final void copyConfigurationAttributes(Configuration destConfiguration, Configuration srcConfiguration) {
        Set set = srcConfiguration.getAttributes().keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"srcConfiguration.attributes.keySet()");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Attribute attribute = (Attribute)element$iv;
            boolean bl = false;
            Object attributeValue = srcConfiguration.getAttributes().getAttribute(attribute);
            AttributeContainer attributeContainer = destConfiguration.getAttributes();
            Intrinsics.checkNotNull((Object)attribute, (String)"null cannot be cast to non-null type org.gradle.api.attributes.Attribute<kotlin.Any>");
            attributeContainer.attribute(attribute, attributeValue);
        }
    }

    private final void registerDependencyTransforms(Project project) {
        project.getDependencies().registerTransform(ArchiveConsumerRulesTransform.class, arg_0 -> AndroidPlugin.registerDependencyTransforms$lambda$7(registerDependencyTransforms.1.INSTANCE, arg_0));
        project.getDependencies().registerTransform(ArchiveConsumerRulesTransform.class, arg_0 -> AndroidPlugin.registerDependencyTransforms$lambda$8(registerDependencyTransforms.2.INSTANCE, arg_0));
        project.getDependencies().registerTransform(AndroidConsumerRulesTransform.class, arg_0 -> AndroidPlugin.registerDependencyTransforms$lambda$9(registerDependencyTransforms.3.INSTANCE, arg_0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void disableAaptOutputCaching(Project project, BaseVariant variant) {
        Task processResourcesTask;
        if (!project.hasProperty("org.gradle.caching")) return;
        Object object = project.findProperty("org.gradle.caching");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        if (!Boolean.parseBoolean((String)object)) return;
        boolean bl = true;
        boolean cachingEnabled = bl;
        if (!cachingEnabled) return;
        TaskContainer taskContainer = project.getTasks();
        StringBuilder stringBuilder = new StringBuilder().append("process");
        String string = variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variant.name");
        Task task = processResourcesTask = (Task)taskContainer.findByName(stringBuilder.append(StringsKt.capitalize((String)string)).append("Resources").toString());
        Task task2 = task;
        if (task == null) return;
        TaskOutputs taskOutputs = task2.getOutputs();
        task2 = taskOutputs;
        if (taskOutputs == null) return;
        task2.doNotCacheIf("We need to regenerate the aapt_rules.pro file, sorry!", arg_0 -> AndroidPlugin.disableAaptOutputCaching$lambda$10((Function1)new Function1<Task, Boolean>(project, variant){
            final /* synthetic */ Project $project;
            final /* synthetic */ BaseVariant $variant;
            {
                this.$project = $project;
                this.$variant = $variant;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Task it) {
                this.$project.getLogger().debug("Disabling AAPT caching for " + this.$variant.getName());
                File file = this.$project.getBuildDir();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.buildDir");
                return !FilesKt.resolve((File)file, (String)"intermediates/proguard/configs/aapt_rules.pro").exists();
            }
        }, arg_0));
    }

    private final void warnOldProguardVersion(Project project) {
        if (AndroidPluginKt.getAgpVersion().getMajorVersion() >= 7) {
            return;
        }
        String message = "An older version of ProGuard has been detected on the classpath which can clash with ProGuard Gradle Plugin.\nThis is likely due to a transitive dependency introduced by Android Gradle plugin.\n\nPlease update your configuration to exclude the old version of ProGuard, for example:\n\nbuildscript {\n    // ... \n    dependencies {\n        // ...\n        classpath(\"com.android.tools.build:gradle:x.y.z\") {\n            exclude group: \"net.sf.proguard\", module: \"proguard-gradle\"\n            // or for kotlin (build.gradle.kts):\n            // exclude(group = \"net.sf.proguard\", module = \"proguard-gradle\")\n        }\n   }\n}";
        Class<?> proguardTask = Class.forName("proguard.gradle.ProGuardTask");
        Method[] methodArray = proguardTask.getMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"proguardTask.methods");
        Object[] $this$count$iv = methodArray;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (Object element$iv : $this$count$iv) {
            Method it = (Method)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)"extraJar")) continue;
            ++count$iv;
        }
        if (count$iv == 0) {
            throw new GradleException(message);
        }
        project.getRootProject().getBuildscript().getConfigurations().all(arg_0 -> AndroidPlugin.warnOldProguardVersion$lambda$12((Function1)new Function1<Configuration, Unit>(project, message){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $message;
            {
                this.$project = $project;
                this.$message = $message;
                super(1);
            }

            public final void invoke(Configuration it) {
                block2: {
                    Object v1;
                    Iterable iterable;
                    block1: {
                        Set set = it.getResolvedConfiguration().getResolvedArtifacts();
                        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"it.resolvedConfiguration.resolvedArtifacts");
                        iterable = set;
                        for (T t : iterable) {
                            ResolvedArtifact it2 = (ResolvedArtifact)t;
                            boolean bl = false;
                            if (!(it2.getModuleVersion().getId().getModule().getGroup().equals("net.sf.proguard") && it2.getModuleVersion().getId().getModule().getName().equals("proguard-gradle"))) continue;
                            v1 = t;
                            break block1;
                        }
                        v1 = null;
                    }
                    ResolvedArtifact resolvedArtifact = v1;
                    if (resolvedArtifact == null) break block2;
                    ResolvedArtifact resolvedArtifact2 = resolvedArtifact;
                    iterable = this.$project;
                    String string = this.$message;
                    ResolvedArtifact it3 = resolvedArtifact2;
                    boolean bl = false;
                    iterable.getLogger().warn(string);
                }
            }
        }, arg_0));
    }

    private static final void apply$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configureAapt$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ConsumerRuleFilterEntry> createCollectConsumerRulesTask$parseConsumerRuleFilter(List<String> consumerRuleFilter) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = consumerRuleFilter;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void filter;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            char[] cArray = new char[]{':'};
            List splits = StringsKt.split$default((CharSequence)((CharSequence)filter), (char[])cArray, (boolean)false, (int)0, (int)6, null);
            if (splits.size() != 2) {
                throw new GradleException("Invalid consumer rule filter entry: " + (String)filter + "\nExpected an entry of the form: <group>:<module>");
            }
            collection.add(new ConsumerRuleFilterEntry((String)splits.get(0), (String)splits.get(1)));
        }
        return (List)destination$iv$iv;
    }

    private static final void createCollectConsumerRulesTask$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void createConsumerRulesConfiguration$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void registerDependencyTransforms$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void registerDependencyTransforms$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void registerDependencyTransforms$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean disableAaptOutputCaching$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void warnOldProguardVersion$lambda$12(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ BaseExtension access$getAndroidExtension$p(AndroidPlugin $this) {
        return $this.androidExtension;
    }

    public static final /* synthetic */ VariantConfiguration access$setupVariant(AndroidPlugin $this, ProGuardAndroidExtension proguardBlock, BaseVariant variant, TaskProvider collectConsumerRulesTask, Project project) {
        return $this.setupVariant(proguardBlock, variant, (TaskProvider<Task>)collectConsumerRulesTask, project);
    }

    public static final /* synthetic */ void access$checkConfigurationFile(AndroidPlugin $this, Project project, List files) {
        $this.checkConfigurationFile(project, files);
    }

    public static final /* synthetic */ List access$createCollectConsumerRulesTask$parseConsumerRuleFilter(List consumerRuleFilter) {
        return AndroidPlugin.createCollectConsumerRulesTask$parseConsumerRuleFilter(consumerRuleFilter);
    }

    public static final /* synthetic */ void access$copyConfigurationAttributes(AndroidPlugin $this, Configuration destConfiguration, Configuration srcConfiguration) {
        $this.copyConfigurationAttributes(destConfiguration, srcConfiguration);
    }

    public static final /* synthetic */ Attribute access$getATTRIBUTE_ARTIFACT_TYPE$cp() {
        return ATTRIBUTE_ARTIFACT_TYPE;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R2\u0010\u0005\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00040\u0004 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00040\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lproguard/gradle/plugin/android/AndroidPlugin$Companion;", "", "()V", "ARTIFACT_TYPE_CONSUMER_RULES", "", "ATTRIBUTE_ARTIFACT_TYPE", "Lorg/gradle/api/attributes/Attribute;", "kotlin.jvm.PlatformType", "COLLECT_CONSUMER_RULES_TASK_NAME", "CONSUMER_RULES_PRO", "gradle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

