/*
 * Decompiled with CFR 0.152.
 */
package proguard.gradle.plugin.android;

import com.android.build.api.transform.Transform;
import com.android.build.gradle.AppExtension;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.TestedExtension;
import com.android.build.gradle.api.ApplicationVariant;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.LibraryVariant;
import com.android.build.gradle.internal.res.LinkApplicationAndroidResourcesTask;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.transform.TransformSpec;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskOutputs;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import proguard.gradle.plugin.android.AndroidPluginKt;
import proguard.gradle.plugin.android.AndroidProjectType;
import proguard.gradle.plugin.android.ProGuardTransform;
import proguard.gradle.plugin.android.dsl.ProGuardAndroidExtension;
import proguard.gradle.plugin.android.dsl.ProGuardConfiguration;
import proguard.gradle.plugin.android.dsl.UserProGuardConfiguration;
import proguard.gradle.plugin.android.dsl.VariantConfiguration;
import proguard.gradle.plugin.android.tasks.CollectConsumerRulesTask;
import proguard.gradle.plugin.android.tasks.ConsumerRuleFilterEntry;
import proguard.gradle.plugin.android.tasks.PrepareProguardConfigDirectoryTask;
import proguard.gradle.plugin.android.transforms.AndroidConsumerRulesTransform;
import proguard.gradle.plugin.android.transforms.ArchiveConsumerRulesTransform;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 )2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001)B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0002J0\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\t\u001a\u00020\u0002H\u0002J<\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00122\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010\u001e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\u0010\u0010\"\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\u0017H\u0002J\u0010\u0010&\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0002J\u0018\u0010'\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010(\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lproguard/gradle/plugin/android/AndroidPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "androidExtension", "Lcom/android/build/gradle/BaseExtension;", "<init>", "(Lcom/android/build/gradle/BaseExtension;)V", "apply", "", "project", "configureAapt", "setupVariant", "Lproguard/gradle/plugin/android/dsl/VariantConfiguration;", "proguardBlock", "Lproguard/gradle/plugin/android/dsl/ProGuardAndroidExtension;", "variant", "Lcom/android/build/gradle/api/BaseVariant;", "collectConsumerRulesTask", "Lorg/gradle/api/tasks/TaskProvider;", "Lorg/gradle/api/Task;", "createCollectConsumerRulesTask", "Lproguard/gradle/plugin/android/tasks/CollectConsumerRulesTask;", "inputConfiguration", "Lorg/gradle/api/artifacts/Configuration;", "consumerRuleFilter", "", "", "outputDir", "Ljava/io/File;", "createConsumerRulesConfiguration", "checkConfigurationFile", "files", "", "Lproguard/gradle/plugin/android/dsl/ProGuardConfiguration;", "verifyNotMinified", "copyConfigurationAttributes", "destConfiguration", "srcConfiguration", "registerDependencyTransforms", "disableAaptOutputCaching", "warnOldProguardVersion", "Companion", "gradle"})
@SourceDebugExtension(value={"SMAP\nAndroidPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidPlugin.kt\nproguard/gradle/plugin/android/AndroidPlugin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,342:1\n808#2,11:343\n1863#2,2:354\n1863#2,2:356\n1863#2,2:361\n1557#2:363\n1628#2,3:364\n12734#3,3:358\n*S KotlinDebug\n*F\n+ 1 AndroidPlugin.kt\nproguard/gradle/plugin/android/AndroidPlugin\n*L\n203#1:343,11\n203#1:354,2\n222#1:356,2\n96#1:361,2\n168#1:363\n168#1:364,3\n285#1:358,3\n*E\n"})
public final class AndroidPlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BaseExtension androidExtension;
    @NotNull
    public static final String COLLECT_CONSUMER_RULES_TASK_NAME = "collectConsumerRules";
    @NotNull
    private static final String CONSUMER_RULES_PRO = "consumer-rules.pro";
    @NotNull
    private static final String ARTIFACT_TYPE_CONSUMER_RULES = "proguard-consumer-rules";
    private static final Attribute<String> ATTRIBUTE_ARTIFACT_TYPE = Attribute.of((String)"artifactType", String.class);

    public AndroidPlugin(@NotNull BaseExtension androidExtension) {
        Intrinsics.checkNotNullParameter((Object)androidExtension, (String)"androidExtension");
        this.androidExtension = androidExtension;
    }

    public void apply(@NotNull Project project) {
        AndroidProjectType androidProjectType;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        TaskProvider collectConsumerRulesTask = project.getTasks().register(COLLECT_CONSUMER_RULES_TASK_NAME);
        this.registerDependencyTransforms(project);
        Object[] objectArray = new Object[]{project};
        ProGuardAndroidExtension proguardBlock = (ProGuardAndroidExtension)project.getExtensions().create("proguard", ProGuardAndroidExtension.class, objectArray);
        Object[] objectArray2 = this.androidExtension;
        if (objectArray2 instanceof AppExtension) {
            androidProjectType = AndroidProjectType.ANDROID_APPLICATION;
        } else if (objectArray2 instanceof LibraryExtension) {
            androidProjectType = AndroidProjectType.ANDROID_LIBRARY;
        } else {
            throw new GradleException("The ProGuard Gradle plugin can only be used on Android application and library projects");
        }
        AndroidProjectType projectType = androidProjectType;
        this.configureAapt(project);
        this.warnOldProguardVersion(project);
        Intrinsics.checkNotNull((Object)proguardBlock);
        Transform transform = new ProGuardTransform(project, proguardBlock, projectType, this.androidExtension);
        objectArray2 = new Object[1];
        Intrinsics.checkNotNull((Object)collectConsumerRulesTask);
        objectArray2[0] = collectConsumerRulesTask;
        this.androidExtension.registerTransform(transform, objectArray2);
        project.afterEvaluate(arg_0 -> AndroidPlugin.apply$lambda$10(arg_0 -> AndroidPlugin.apply$lambda$9(proguardBlock, this, collectConsumerRulesTask, project, arg_0), arg_0));
    }

    private final void configureAapt(Project project) {
        TaskProvider createDirectoryTask = project.getTasks().register("prepareProguardConfigDirectory", PrepareProguardConfigDirectoryTask.class);
        project.getTasks().withType(LinkApplicationAndroidResourcesTask.class, arg_0 -> AndroidPlugin.configureAapt$lambda$12(arg_0 -> AndroidPlugin.configureAapt$lambda$11(createDirectoryTask, arg_0), arg_0));
        if (!AndroidPluginKt.getAaptAdditionalParameters(this.androidExtension).contains("--proguard")) {
            Collection<String> collection = AndroidPluginKt.getAaptAdditionalParameters(this.androidExtension);
            Object[] objectArray = new String[2];
            objectArray[0] = "--proguard";
            File file = project.getBuildDir();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getBuildDir(...)");
            objectArray[1] = FilesKt.resolve((File)file, (String)"intermediates/proguard/configs/aapt_rules.pro").getAbsolutePath();
            collection.addAll(CollectionsKt.listOf((Object[])objectArray));
        }
        if (!AndroidPluginKt.getAaptAdditionalParameters(this.androidExtension).contains("--proguard-conditional-keep-rules")) {
            AndroidPluginKt.getAaptAdditionalParameters(this.androidExtension).add("--proguard-conditional-keep-rules");
        }
    }

    private final VariantConfiguration setupVariant(ProGuardAndroidExtension proguardBlock, BaseVariant variant, TaskProvider<Task> collectConsumerRulesTask, Project project) {
        Iterable iterable = (Iterable)proguardBlock.getConfigurations();
        String string = variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        VariantConfiguration matchingConfiguration = AndroidPluginKt.findVariantConfiguration((Iterable<VariantConfiguration>)iterable, string);
        if (matchingConfiguration != null) {
            this.verifyNotMinified(variant);
            this.disableAaptOutputCaching(project, variant);
            TaskProvider[] taskProviderArray = new TaskProvider[1];
            Configuration configuration = this.createConsumerRulesConfiguration(project, variant);
            List<String> list = matchingConfiguration.getConsumerRuleFilter();
            File file = project.getBuildDir();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getBuildDir(...)");
            taskProviderArray[0] = this.createCollectConsumerRulesTask(project, variant, configuration, list, FilesKt.resolve((File)file, (String)"intermediates/proguard/configs"));
            TaskFactoryUtils.dependsOn(collectConsumerRulesTask, (TaskProvider[])taskProviderArray);
        }
        return matchingConfiguration;
    }

    private final TaskProvider<CollectConsumerRulesTask> createCollectConsumerRulesTask(Project project, BaseVariant variant, Configuration inputConfiguration, List<String> consumerRuleFilter, File outputDir) {
        TaskContainer taskContainer = project.getTasks();
        StringBuilder stringBuilder = new StringBuilder().append(COLLECT_CONSUMER_RULES_TASK_NAME);
        String string = variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        TaskProvider taskProvider = taskContainer.register(stringBuilder.append(StringsKt.capitalize((String)string)).toString(), CollectConsumerRulesTask.class, arg_0 -> AndroidPlugin.createCollectConsumerRulesTask$lambda$15(arg_0 -> AndroidPlugin.createCollectConsumerRulesTask$lambda$14(inputConfiguration, consumerRuleFilter, outputDir, variant, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
        return taskProvider;
    }

    private final Configuration createConsumerRulesConfiguration(Project project, BaseVariant variant) {
        Object object = project.getConfigurations().create(variant.getName() + "ProGuardConsumerRulesArtifacts", arg_0 -> AndroidPlugin.createConsumerRulesConfiguration$lambda$17(arg_0 -> AndroidPlugin.createConsumerRulesConfiguration$lambda$16(variant, this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(...)");
        return (Configuration)object;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkConfigurationFile(Project project, List<? extends ProGuardConfiguration> files) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = files;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof UserProGuardConfiguration)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UserProGuardConfiguration it = (UserProGuardConfiguration)element$iv;
            boolean bl = false;
            File file = project.file((Object)it.getPath());
            if (file.exists()) continue;
            throw new GradleException("ProGuard configuration file " + file.getAbsolutePath() + " was set but does not exist.");
        }
    }

    private final void verifyNotMinified(BaseVariant variant) {
        if (variant.getBuildType().isMinifyEnabled()) {
            throw new GradleException("The option 'minifyEnabled' is set to 'true' for variant '" + variant.getName() + "', but should be 'false' for variants processed by ProGuard");
        }
    }

    private final void copyConfigurationAttributes(Configuration destConfiguration, Configuration srcConfiguration) {
        Set set = srcConfiguration.getAttributes().keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"keySet(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Attribute attribute = (Attribute)element$iv;
            boolean bl = false;
            Object attributeValue = srcConfiguration.getAttributes().getAttribute(attribute);
            AttributeContainer attributeContainer = destConfiguration.getAttributes();
            Intrinsics.checkNotNull((Object)attribute, (String)"null cannot be cast to non-null type org.gradle.api.attributes.Attribute<kotlin.Any>");
            attributeContainer.attribute(attribute, attributeValue);
        }
    }

    private final void registerDependencyTransforms(Project project) {
        project.getDependencies().registerTransform(ArchiveConsumerRulesTransform.class, arg_0 -> AndroidPlugin.registerDependencyTransforms$lambda$21(AndroidPlugin::registerDependencyTransforms$lambda$20, arg_0));
        project.getDependencies().registerTransform(ArchiveConsumerRulesTransform.class, arg_0 -> AndroidPlugin.registerDependencyTransforms$lambda$23(AndroidPlugin::registerDependencyTransforms$lambda$22, arg_0));
        project.getDependencies().registerTransform(AndroidConsumerRulesTransform.class, arg_0 -> AndroidPlugin.registerDependencyTransforms$lambda$25(AndroidPlugin::registerDependencyTransforms$lambda$24, arg_0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void disableAaptOutputCaching(Project project, BaseVariant variant) {
        Task processResourcesTask;
        if (!project.hasProperty("org.gradle.caching")) return;
        Object object = project.findProperty("org.gradle.caching");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        if (!Boolean.parseBoolean((String)object)) return;
        boolean bl = true;
        boolean cachingEnabled = bl;
        if (!cachingEnabled) return;
        TaskContainer taskContainer = project.getTasks();
        StringBuilder stringBuilder = new StringBuilder().append("process");
        String string = variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Task task = processResourcesTask = (Task)taskContainer.findByName(stringBuilder.append(StringsKt.capitalize((String)string)).append("Resources").toString());
        Task task2 = task;
        if (task == null) return;
        TaskOutputs taskOutputs = task2.getOutputs();
        task2 = taskOutputs;
        if (taskOutputs == null) return;
        task2.doNotCacheIf("We need to regenerate the aapt_rules.pro file, sorry!", arg_0 -> AndroidPlugin.disableAaptOutputCaching$lambda$27(arg_0 -> AndroidPlugin.disableAaptOutputCaching$lambda$26(project, variant, arg_0), arg_0));
    }

    private final void warnOldProguardVersion(Project project) {
        if (AndroidPluginKt.getAgpVersion().getMajorVersion() >= 7) {
            return;
        }
        String message = "An older version of ProGuard has been detected on the classpath which can clash with ProGuard Gradle Plugin.\nThis is likely due to a transitive dependency introduced by Android Gradle plugin.\n\nPlease update your configuration to exclude the old version of ProGuard, for example:\n\nbuildscript {\n    // ... \n    dependencies {\n        // ...\n        classpath(\"com.android.tools.build:gradle:x.y.z\") {\n            exclude group: \"net.sf.proguard\", module: \"proguard-gradle\"\n            // or for kotlin (build.gradle.kts):\n            // exclude(group = \"net.sf.proguard\", module = \"proguard-gradle\")\n        }\n   }\n}";
        Class<?> proguardTask = Class.forName("proguard.gradle.ProGuardTask");
        Method[] methodArray = proguardTask.getMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getMethods(...)");
        Object[] $this$count$iv = methodArray;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (Object element$iv : $this$count$iv) {
            Method it = (Method)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)"extraJar")) continue;
            ++count$iv;
        }
        if (count$iv == 0) {
            throw new GradleException(message);
        }
        project.getRootProject().getBuildscript().getConfigurations().all(arg_0 -> AndroidPlugin.warnOldProguardVersion$lambda$32(arg_0 -> AndroidPlugin.warnOldProguardVersion$lambda$31(project, message, arg_0), arg_0));
    }

    private static final Unit apply$lambda$9$lambda$1(AndroidPlugin this$0, ProGuardAndroidExtension $proguardBlock, TaskProvider $collectConsumerRulesTask, Project $project, List $matchedConfigurations, ApplicationVariant applicationVariant) {
        block0: {
            Intrinsics.checkNotNull((Object)$proguardBlock);
            Intrinsics.checkNotNull((Object)applicationVariant);
            BaseVariant baseVariant = (BaseVariant)applicationVariant;
            Intrinsics.checkNotNull((Object)$collectConsumerRulesTask);
            VariantConfiguration variantConfiguration = this$0.setupVariant($proguardBlock, baseVariant, (TaskProvider<Task>)$collectConsumerRulesTask, $project);
            if (variantConfiguration == null) break block0;
            VariantConfiguration it = variantConfiguration;
            boolean bl = false;
            $matchedConfigurations.add(it);
        }
        return Unit.INSTANCE;
    }

    private static final void apply$lambda$9$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit apply$lambda$9$lambda$4(AndroidPlugin this$0, ProGuardAndroidExtension $proguardBlock, TaskProvider $collectConsumerRulesTask, Project $project, List $matchedConfigurations, LibraryVariant libraryVariant) {
        block0: {
            Intrinsics.checkNotNull((Object)$proguardBlock);
            Intrinsics.checkNotNull((Object)libraryVariant);
            BaseVariant baseVariant = (BaseVariant)libraryVariant;
            Intrinsics.checkNotNull((Object)$collectConsumerRulesTask);
            VariantConfiguration variantConfiguration = this$0.setupVariant($proguardBlock, baseVariant, (TaskProvider<Task>)$collectConsumerRulesTask, $project);
            if (variantConfiguration == null) break block0;
            VariantConfiguration it = variantConfiguration;
            boolean bl = false;
            $matchedConfigurations.add(it);
        }
        return Unit.INSTANCE;
    }

    private static final void apply$lambda$9$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final CharSequence apply$lambda$9$lambda$8$lambda$7(VariantConfiguration it) {
        return it.getName();
    }

    private static final Unit apply$lambda$9(ProGuardAndroidExtension $proguardBlock, AndroidPlugin this$0, TaskProvider $collectConsumerRulesTask, Project $project, Project it) {
        if ($proguardBlock.getConfigurations().isEmpty()) {
            throw new GradleException("There are no configured variants in the 'proguard' block");
        }
        List matchedConfigurations = new ArrayList();
        Object object = (TestedExtension)this$0.androidExtension;
        if (object instanceof AppExtension) {
            ((AppExtension)this$0.androidExtension).getApplicationVariants().all(arg_0 -> AndroidPlugin.apply$lambda$9$lambda$2(arg_0 -> AndroidPlugin.apply$lambda$9$lambda$1(this$0, $proguardBlock, $collectConsumerRulesTask, $project, matchedConfigurations, arg_0), arg_0));
        } else if (object instanceof LibraryExtension) {
            ((LibraryExtension)this$0.androidExtension).getLibraryVariants().all(arg_0 -> AndroidPlugin.apply$lambda$9$lambda$5(arg_0 -> AndroidPlugin.apply$lambda$9$lambda$4(this$0, $proguardBlock, $collectConsumerRulesTask, $project, matchedConfigurations, arg_0), arg_0));
        }
        Iterable $this$forEach$iv = (Iterable)$proguardBlock.getConfigurations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VariantConfiguration it2 = (VariantConfiguration)element$iv;
            boolean bl = false;
            this$0.checkConfigurationFile($project, it2.getConfigurations());
        }
        Object $this$apply_u24lambda_u249_u24lambda_u248 = object = SetsKt.minus((Set)((Set)$proguardBlock.getConfigurations()), (Iterable)matchedConfigurations);
        boolean bl = false;
        if (!((Collection)$this$apply_u24lambda_u249_u24lambda_u248).isEmpty()) {
            if ($this$apply_u24lambda_u249_u24lambda_u248.size() == 1) {
                throw new GradleException("The configured variant '" + ((VariantConfiguration)CollectionsKt.first((Iterable)((Iterable)$this$apply_u24lambda_u249_u24lambda_u248))).getName() + "' does not exist");
            }
            throw new GradleException("The configured variants " + CollectionsKt.joinToString$default((Iterable)((Iterable)$this$apply_u24lambda_u249_u24lambda_u248), (CharSequence)"', '", (CharSequence)"'", (CharSequence)"'", (int)0, null, AndroidPlugin::apply$lambda$9$lambda$8$lambda$7, (int)24, null) + " do not exist");
        }
        return Unit.INSTANCE;
    }

    private static final void apply$lambda$10(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit configureAapt$lambda$11(TaskProvider $createDirectoryTask, LinkApplicationAndroidResourcesTask it) {
        Object[] objectArray = new Object[]{$createDirectoryTask};
        it.dependsOn(objectArray);
        return Unit.INSTANCE;
    }

    private static final void configureAapt$lambda$12(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ConsumerRuleFilterEntry> createCollectConsumerRulesTask$parseConsumerRuleFilter(List<String> consumerRuleFilter) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = consumerRuleFilter;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void filter;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            char[] cArray = new char[]{':'};
            List splits = StringsKt.split$default((CharSequence)((CharSequence)filter), (char[])cArray, (boolean)false, (int)0, (int)6, null);
            if (splits.size() != 2) {
                throw new GradleException("Invalid consumer rule filter entry: " + (String)filter + "\nExpected an entry of the form: <group>:<module>");
            }
            collection.add(new ConsumerRuleFilterEntry((String)splits.get(0), (String)splits.get(1)));
        }
        return (List)destination$iv$iv;
    }

    private static final Unit createCollectConsumerRulesTask$lambda$14(Configuration $inputConfiguration, List $consumerRuleFilter, File $outputDir, BaseVariant $variant, CollectConsumerRulesTask it) {
        it.setConsumerRulesConfiguration($inputConfiguration);
        it.setConsumerRuleFilter(AndroidPlugin.createCollectConsumerRulesTask$parseConsumerRuleFilter($consumerRuleFilter));
        it.setOutputFile(new File(new File($outputDir, $variant.getDirName()), CONSUMER_RULES_PRO));
        Object[] objectArray = new Object[]{$inputConfiguration.getBuildDependencies()};
        it.dependsOn(objectArray);
        return Unit.INSTANCE;
    }

    private static final void createCollectConsumerRulesTask$lambda$15(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit createConsumerRulesConfiguration$lambda$16(BaseVariant $variant, AndroidPlugin this$0, Configuration it) {
        it.setCanBeResolved(true);
        it.setCanBeConsumed(false);
        it.setTransitive(true);
        Configuration[] configurationArray = new Configuration[]{$variant.getRuntimeConfiguration()};
        it.extendsFrom(configurationArray);
        Intrinsics.checkNotNull((Object)it);
        Configuration configuration = $variant.getRuntimeConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"getRuntimeConfiguration(...)");
        this$0.copyConfigurationAttributes(it, configuration);
        it.getAttributes().attribute(ATTRIBUTE_ARTIFACT_TYPE, (Object)ARTIFACT_TYPE_CONSUMER_RULES);
        return Unit.INSTANCE;
    }

    private static final void createConsumerRulesConfiguration$lambda$17(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit registerDependencyTransforms$lambda$20(TransformSpec it) {
        it.getFrom().attribute(ATTRIBUTE_ARTIFACT_TYPE, (Object)"aar");
        it.getTo().attribute(ATTRIBUTE_ARTIFACT_TYPE, (Object)ARTIFACT_TYPE_CONSUMER_RULES);
        return Unit.INSTANCE;
    }

    private static final void registerDependencyTransforms$lambda$21(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit registerDependencyTransforms$lambda$22(TransformSpec it) {
        it.getFrom().attribute(ATTRIBUTE_ARTIFACT_TYPE, (Object)"jar");
        it.getTo().attribute(ATTRIBUTE_ARTIFACT_TYPE, (Object)ARTIFACT_TYPE_CONSUMER_RULES);
        return Unit.INSTANCE;
    }

    private static final void registerDependencyTransforms$lambda$23(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit registerDependencyTransforms$lambda$24(TransformSpec it) {
        it.getFrom().attribute(ATTRIBUTE_ARTIFACT_TYPE, (Object)"android-consumer-proguard-rules");
        it.getTo().attribute(ATTRIBUTE_ARTIFACT_TYPE, (Object)ARTIFACT_TYPE_CONSUMER_RULES);
        return Unit.INSTANCE;
    }

    private static final void registerDependencyTransforms$lambda$25(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean disableAaptOutputCaching$lambda$26(Project $project, BaseVariant $variant, Task it) {
        $project.getLogger().debug("Disabling AAPT caching for " + $variant.getName());
        File file = $project.getBuildDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getBuildDir(...)");
        return !FilesKt.resolve((File)file, (String)"intermediates/proguard/configs/aapt_rules.pro").exists();
    }

    private static final boolean disableAaptOutputCaching$lambda$27(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit warnOldProguardVersion$lambda$31(Project $project, String $message, Configuration it) {
        block2: {
            Object v1;
            block1: {
                Set set = it.getResolvedConfiguration().getResolvedArtifacts();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getResolvedArtifacts(...)");
                Iterable iterable = set;
                for (Object t : iterable) {
                    ResolvedArtifact it2 = (ResolvedArtifact)t;
                    boolean bl = false;
                    if (!(it2.getModuleVersion().getId().getModule().getGroup().equals("net.sf.proguard") && it2.getModuleVersion().getId().getModule().getName().equals("proguard-gradle"))) continue;
                    v1 = t;
                    break block1;
                }
                v1 = null;
            }
            ResolvedArtifact resolvedArtifact = v1;
            if (resolvedArtifact == null) break block2;
            ResolvedArtifact it3 = resolvedArtifact;
            boolean bl = false;
            $project.getLogger().warn($message);
        }
        return Unit.INSTANCE;
    }

    private static final void warnOldProguardVersion$lambda$32(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R2\u0010\b\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00050\u0005 \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lproguard/gradle/plugin/android/AndroidPlugin$Companion;", "", "<init>", "()V", "COLLECT_CONSUMER_RULES_TASK_NAME", "", "CONSUMER_RULES_PRO", "ARTIFACT_TYPE_CONSUMER_RULES", "ATTRIBUTE_ARTIFACT_TYPE", "Lorg/gradle/api/attributes/Attribute;", "kotlin.jvm.PlatformType", "gradle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

