/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.service.ha;

import com.guardtime.ksi.service.ConfigurationListener;
import com.guardtime.ksi.service.ha.ConsolidatedResult;
import com.guardtime.ksi.service.ha.HAConfigurationConsolidationException;
import com.guardtime.ksi.service.ha.SubServiceConfListener;
import com.guardtime.ksi.util.Util;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractHAConfigurationListener<T>
implements ConfigurationListener<T> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<ConfigurationListener<T>> consolidatedConfListeners = new ArrayList<ConfigurationListener<T>>();
    ConsolidatedResult<T> lastConsolidatedConfiguration;
    private final Object lock = new Object();

    AbstractHAConfigurationListener() {
    }

    protected abstract T consolidate(T var1, T var2);

    abstract List<SubServiceConfListener<T>> getSubServiceConfListeners();

    void registerListener(ConfigurationListener<T> listener) {
        Util.notNull(listener, (String)"Consolidated configuration listener");
        this.consolidatedConfListeners.add(listener);
        if (this.lastConsolidatedConfiguration != null) {
            this.updateListener(listener);
        }
    }

    public void updated(T configuration) {
        this.recalculateConfiguration();
    }

    public void updateFailed(Throwable reason) {
        this.recalculateConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalculateConfiguration() {
        boolean listenersNeedUpdate;
        Object newConsolidatedConfiguration = null;
        ConsolidatedResult<T> oldConsolidatedConfiguration = this.lastConsolidatedConfiguration;
        Object object = this.lock;
        synchronized (object) {
            for (SubServiceConfListener<T> serviceConfListener : this.getSubServiceConfListeners()) {
                if (!serviceConfListener.isAccountedFor()) continue;
                newConsolidatedConfiguration = this.consolidate(serviceConfListener.getLastConfiguration(), newConsolidatedConfiguration);
            }
            this.resetLastConsolidatedConfiguration(newConsolidatedConfiguration);
            listenersNeedUpdate = !Util.equals(this.lastConsolidatedConfiguration, oldConsolidatedConfiguration);
        }
        if (listenersNeedUpdate) {
            this.logger.info("HA service configuration changed. Old configuration: {}. New configuration: {}.", oldConsolidatedConfiguration, this.lastConsolidatedConfiguration);
            this.updateListeners();
        }
    }

    private void updateListeners() {
        for (ConfigurationListener<T> listener : this.consolidatedConfListeners) {
            this.updateListener(listener);
        }
    }

    private void updateListener(ConfigurationListener<T> listener) {
        if (this.lastConsolidatedConfiguration.wasSuccessful()) {
            listener.updated(this.lastConsolidatedConfiguration.getResult());
        } else {
            listener.updateFailed(this.lastConsolidatedConfiguration.getException());
        }
    }

    private void resetLastConsolidatedConfiguration(T newConsolidatedConfiguration) {
        this.lastConsolidatedConfiguration = newConsolidatedConfiguration == null ? new ConsolidatedResult(new HAConfigurationConsolidationException()) : new ConsolidatedResult<T>(newConsolidatedConfiguration);
    }
}

