/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.service.ha;

import com.guardtime.ksi.concurrency.DefaultExecutorServiceProvider;
import com.guardtime.ksi.exceptions.KSIException;
import com.guardtime.ksi.pdu.ExtenderConfiguration;
import com.guardtime.ksi.pdu.ExtensionResponse;
import com.guardtime.ksi.service.ConfigurationListener;
import com.guardtime.ksi.service.Future;
import com.guardtime.ksi.service.KSIExtendingClientServiceAdapter;
import com.guardtime.ksi.service.KSIExtendingService;
import com.guardtime.ksi.service.client.KSIExtenderClient;
import com.guardtime.ksi.service.ha.ExtendingHAServiceConfigurationListener;
import com.guardtime.ksi.service.ha.ExtendingTask;
import com.guardtime.ksi.service.ha.ServiceCallFuture;
import com.guardtime.ksi.service.ha.ServiceCallsTask;
import com.guardtime.ksi.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendingHAService
implements KSIExtendingService {
    private static final Logger logger = LoggerFactory.getLogger(ExtendingHAService.class);
    private final List<KSIExtendingService> subservices;
    private final ExecutorService executorService;
    private final ExtendingHAServiceConfigurationListener haConfListener;

    private ExtendingHAService(List<KSIExtendingService> subservices, ExecutorService executorService) {
        this.subservices = Collections.unmodifiableList(subservices);
        this.executorService = executorService;
        this.haConfListener = new ExtendingHAServiceConfigurationListener(this.subservices);
    }

    public Future<ExtensionResponse> extend(Date aggregationTime, Date publicationTime) throws KSIException {
        Util.notNull((Object)aggregationTime, (String)"aggregationTime");
        List<KSIExtendingService> services = this.subservices;
        ArrayList tasks = new ArrayList(services.size());
        for (KSIExtendingService service : services) {
            tasks.add(new ExtendingTask(service, aggregationTime, publicationTime));
        }
        return new ServiceCallFuture<ExtensionResponse>(this.executorService.submit(new ServiceCallsTask(this.executorService, tasks)));
    }

    public List<KSIExtendingService> getSubExtendingServices() {
        return this.subservices;
    }

    public void registerExtenderConfigurationListener(ConfigurationListener<ExtenderConfiguration> listener) {
        this.haConfListener.registerListener(listener);
    }

    public Future<ExtenderConfiguration> getExtendingConfiguration() {
        return this.haConfListener.getExtensionConfiguration();
    }

    public void close() {
        for (KSIExtendingService service : this.subservices) {
            try {
                service.close();
            }
            catch (IOException e) {
                logger.error("Failed to close subservice", (Throwable)e);
            }
        }
    }

    public static class Builder {
        private List<KSIExtendingService> services = new ArrayList<KSIExtendingService>();
        private ExecutorService executorService = DefaultExecutorServiceProvider.getExecutorService();

        public Builder addClients(List<KSIExtenderClient> clients) {
            Util.notNull(clients, (String)"ExtendingHAService.Builder.clients");
            this.services.addAll(this.clientsToServices(clients));
            return this;
        }

        public Builder addServices(List<KSIExtendingService> services) {
            Util.notNull(services, (String)"ExtendingHAService.Builder.services");
            this.services.addAll(services);
            return this;
        }

        public Builder setExecutorService(ExecutorService executorService) {
            Util.notNull((Object)executorService, (String)"ExtendingHAService.Builder.executorService");
            this.executorService = executorService;
            return this;
        }

        public ExtendingHAService build() {
            List<KSIExtendingService> subservices = Collections.unmodifiableList(this.services);
            if (subservices.isEmpty()) {
                throw new IllegalArgumentException("Can not initialize ExtendingHAService without any subservices");
            }
            if (subservices.size() > 3) {
                throw new IllegalArgumentException("ExtendingHAService can not be initialized with more than 3 subservices");
            }
            return new ExtendingHAService(subservices, this.executorService);
        }

        private List<KSIExtendingService> clientsToServices(List<KSIExtenderClient> clients) {
            ArrayList<KSIExtendingService> services = new ArrayList<KSIExtendingService>(clients.size());
            for (KSIExtenderClient client : clients) {
                services.add((KSIExtendingService)new KSIExtendingClientServiceAdapter(client));
            }
            return services;
        }
    }
}

