/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.service.ha;

import com.guardtime.ksi.pdu.ExtenderConfiguration;
import com.guardtime.ksi.service.ha.HAConfUtil;
import com.guardtime.ksi.util.Util;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExtendingHAServiceConfiguration
implements ExtenderConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ExtendingHAServiceConfiguration.class);
    private static final Date JAN_01_2006_00_00_00 = new Date(1136073600000L);
    private static final int MIN_MAX_REQS = 0;
    private static final int MAX_MAX_REQS = 16000;
    private final Long maxRequests;
    private final List<String> parents;
    private final Date calFirstTime;
    private final Date calLastTime;

    ExtendingHAServiceConfiguration(ExtenderConfiguration configuration) {
        Util.notNull((Object)configuration, (String)"ExtendingHAServiceConfiguration configuration to copy");
        this.maxRequests = this.normalizeMaxRequests(configuration.getMaximumRequests());
        this.calFirstTime = this.normalizeCalFirstTime(configuration.getCalendarFirstTime(), configuration.getCalendarLastTime());
        this.calLastTime = this.normalizeCalLastTime(configuration.getCalendarLastTime(), configuration.getCalendarFirstTime());
        this.parents = configuration.getParents();
    }

    ExtendingHAServiceConfiguration(ExtenderConfiguration c1, ExtenderConfiguration c2) {
        Util.notNull((Object)c1, (String)"ExtendingHAServiceConfiguration first configuration to consolidate");
        Util.notNull((Object)c2, (String)"ExtendingHAServiceConfiguration second configuration to consolidate");
        Long c1MaxReqs = this.normalizeMaxRequests(c1.getMaximumRequests());
        Long c2MaxReqs = this.normalizeMaxRequests(c2.getMaximumRequests());
        this.maxRequests = HAConfUtil.isBigger(c1MaxReqs, c2MaxReqs) ? c2MaxReqs : c1MaxReqs;
        Date c1CalFirstTime = this.normalizeCalFirstTime(c1.getCalendarFirstTime(), c1.getCalendarLastTime());
        Date c2CalFirstTime = this.normalizeCalFirstTime(c2.getCalendarFirstTime(), c2.getCalendarLastTime());
        this.calFirstTime = HAConfUtil.isBefore(c1CalFirstTime, c2CalFirstTime) ? c2CalFirstTime : c1CalFirstTime;
        Date c1CalLastTime = this.normalizeCalLastTime(c1.getCalendarLastTime(), c1.getCalendarFirstTime());
        Date c2CalLastTime = this.normalizeCalLastTime(c2.getCalendarLastTime(), c2.getCalendarFirstTime());
        this.calLastTime = HAConfUtil.isAfter(c1CalLastTime, c2CalLastTime) ? c2CalLastTime : c1.getCalendarLastTime();
        List c1Parents = c1.getParents();
        List c2Parents = c2.getParents();
        this.parents = c1Parents == null ? c2Parents : c1Parents;
    }

    public Long getMaximumRequests() {
        return this.maxRequests;
    }

    public List<String> getParents() {
        return this.parents;
    }

    public Date getCalendarFirstTime() {
        return this.calFirstTime;
    }

    public Date getCalendarLastTime() {
        return this.calLastTime;
    }

    private Long normalizeMaxRequests(Long maxRequests) {
        if (this.isMaxRequestsSane(maxRequests)) {
            return maxRequests;
        }
        logger.warn("Received max requests '{}' from an extender. Will not use it as only values between {} and {} are considered sane.", new Object[]{maxRequests, 0, 16000});
        return null;
    }

    private Date normalizeCalFirstTime(Date calFirstTime, Date calLastTime) {
        if (this.isCalFirstTimeSane(calFirstTime, calLastTime)) {
            return calFirstTime;
        }
        logger.warn("Received calendar first time '{}' from an extender. Will not use it as it is not sane. Calendar first time has to be after {} and before calendar last time ({}).", new Object[]{calFirstTime, JAN_01_2006_00_00_00, calLastTime});
        return null;
    }

    private Date normalizeCalLastTime(Date calLastTime, Date calFirstTime) {
        if (this.isCalLastTimeSane(calLastTime, calFirstTime)) {
            return calLastTime;
        }
        logger.warn("Received calendar last time '{}' from an extender. Will not use it as it is not sane. Calendar last time has to be after {} and after calendar first time ({}).", new Object[]{calLastTime, JAN_01_2006_00_00_00, calFirstTime});
        return null;
    }

    private boolean isMaxRequestsSane(Long maxRequests) {
        return maxRequests == null || maxRequests > 0L && maxRequests <= 16000L;
    }

    private boolean isCalFirstTimeSane(Date calFirstTime, Date calLastTime) {
        return calFirstTime == null && calLastTime == null || calFirstTime != null && calLastTime != null && calFirstTime.after(JAN_01_2006_00_00_00) && !calFirstTime.after(calLastTime);
    }

    private boolean isCalLastTimeSane(Date calLastTime, Date calFirstTime) {
        return calFirstTime == null && calLastTime == null || calFirstTime != null && calLastTime != null && calLastTime.after(JAN_01_2006_00_00_00) && !calLastTime.before(calFirstTime);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExtenderConfiguration)) {
            return false;
        }
        ExtenderConfiguration that = (ExtenderConfiguration)o;
        return Util.equals((Object)this.getCalendarFirstTime(), (Object)that.getCalendarFirstTime()) && Util.equals((Object)this.getCalendarLastTime(), (Object)that.getCalendarLastTime()) && Util.equals((Object)this.getMaximumRequests(), (Object)that.getMaximumRequests()) && Util.equalsIgnoreOrder(this.getParents(), (Collection)that.getParents());
    }

    public String toString() {
        return "ExtendingHAServiceConfiguration{maxRequests=" + this.maxRequests + ", parents=" + this.parents + ", calFirstTime=" + this.calFirstTime + ", calLastTime=" + this.calLastTime + '}';
    }
}

