/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.service.ha;

import com.guardtime.ksi.pdu.ExtenderConfiguration;
import com.guardtime.ksi.service.Future;
import com.guardtime.ksi.service.KSIExtendingService;
import com.guardtime.ksi.service.ha.AbstractHAConfigurationListener;
import com.guardtime.ksi.service.ha.ConsolidatedResult;
import com.guardtime.ksi.service.ha.ExtendingHAServiceConfiguration;
import com.guardtime.ksi.service.ha.HAConfFuture;
import com.guardtime.ksi.service.ha.SubServiceConfListener;
import java.util.ArrayList;
import java.util.List;

class ExtendingHAServiceConfigurationListener
extends AbstractHAConfigurationListener<ExtenderConfiguration> {
    private final List<SubServiceConfListener<ExtenderConfiguration>> subServiceConfListeners = new ArrayList<SubServiceConfListener<ExtenderConfiguration>>();
    private final List<KSIExtendingService> subservices;

    ExtendingHAServiceConfigurationListener(List<KSIExtendingService> subservices) {
        this.subservices = subservices;
        for (KSIExtendingService subservice : subservices) {
            SubServiceConfListener<ExtenderConfiguration> listener = new SubServiceConfListener<ExtenderConfiguration>(subservice.toString(), this);
            subservice.registerExtenderConfigurationListener(listener);
            this.subServiceConfListeners.add(listener);
        }
    }

    @Override
    protected ExtenderConfiguration consolidate(ExtenderConfiguration c1, ExtenderConfiguration c2) {
        boolean c2Exists;
        boolean c1Exists = c1 != null;
        boolean bl = c2Exists = c2 != null;
        if (c1Exists && c2Exists) {
            return new ExtendingHAServiceConfiguration(c1, c2);
        }
        if (c1Exists) {
            return new ExtendingHAServiceConfiguration(c1);
        }
        if (c2Exists) {
            return new ExtendingHAServiceConfiguration(c2);
        }
        return null;
    }

    @Override
    List<SubServiceConfListener<ExtenderConfiguration>> getSubServiceConfListeners() {
        return this.subServiceConfListeners;
    }

    Future<ExtenderConfiguration> getExtensionConfiguration() {
        return new HAConfFuture<ExtenderConfiguration>(this.invokeSubserviceConfUpdates(), new HAConfFuture.ConfResultSupplier<ConsolidatedResult<ExtenderConfiguration>>(){

            @Override
            public ConsolidatedResult<ExtenderConfiguration> get() {
                return ExtendingHAServiceConfigurationListener.this.lastConsolidatedConfiguration;
            }
        });
    }

    private List<Future<ExtenderConfiguration>> invokeSubserviceConfUpdates() {
        ArrayList<Future<ExtenderConfiguration>> confFutures = new ArrayList<Future<ExtenderConfiguration>>();
        for (KSIExtendingService service : this.subservices) {
            confFutures.add((Future<ExtenderConfiguration>)service.getExtendingConfiguration());
        }
        return confFutures;
    }
}

