/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.service.ha;

import com.guardtime.ksi.exceptions.KSIException;
import com.guardtime.ksi.service.Future;
import com.guardtime.ksi.service.ha.ConsolidatedResult;
import java.util.Collection;

class HAConfFuture<T>
implements Future<T> {
    private final Collection<Future<T>> confFutures;
    private final ConfResultSupplier<ConsolidatedResult<T>> lastConsolidatedConfigurationSupplier;
    private ConsolidatedResult<T> consolidationResult;

    HAConfFuture(Collection<Future<T>> confFutures, ConfResultSupplier<ConsolidatedResult<T>> confResultSupplier) {
        this.confFutures = confFutures;
        this.lastConsolidatedConfigurationSupplier = confResultSupplier;
    }

    public synchronized T getResult() throws KSIException {
        if (this.consolidationResult == null) {
            this.waitForAllResponses();
            this.consolidationResult = this.lastConsolidatedConfigurationSupplier.get();
        }
        if (this.consolidationResult.wasSuccessful()) {
            return this.consolidationResult.getResult();
        }
        throw new KSIException("Configuration consolidation failed in HA service", this.consolidationResult.getException());
    }

    private void waitForAllResponses() {
        for (Future<T> confFuture : this.confFutures) {
            try {
                confFuture.getResult();
            }
            catch (Exception exception) {}
        }
    }

    public synchronized boolean isFinished() {
        if (this.consolidationResult == null) {
            for (Future<T> confFuture : this.confFutures) {
                if (confFuture.isFinished()) continue;
                return false;
            }
        }
        return true;
    }

    static interface ConfResultSupplier<T> {
        public T get();
    }
}

