/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.service.ha;

import com.guardtime.ksi.exceptions.KSIException;
import com.guardtime.ksi.hashing.DataHash;
import com.guardtime.ksi.pdu.AggregationResponse;
import com.guardtime.ksi.pdu.AggregatorConfiguration;
import com.guardtime.ksi.pdu.ExtenderConfiguration;
import com.guardtime.ksi.pdu.ExtensionResponse;
import com.guardtime.ksi.service.ConfigurationListener;
import com.guardtime.ksi.service.Future;
import com.guardtime.ksi.service.KSIExtendingService;
import com.guardtime.ksi.service.KSISigningService;
import com.guardtime.ksi.service.client.KSIExtenderClient;
import com.guardtime.ksi.service.client.KSISigningClient;
import com.guardtime.ksi.service.ha.ExtendingHAService;
import com.guardtime.ksi.service.ha.SigningHAService;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;

public class HAService
implements KSISigningService,
KSIExtendingService {
    private final SigningHAService signingHAService;
    private final ExtendingHAService extendingHAService;

    private HAService(SigningHAService signingHAService, ExtendingHAService extendingHAService) {
        this.signingHAService = signingHAService;
        this.extendingHAService = extendingHAService;
    }

    public Future<AggregationResponse> sign(DataHash dataHash, Long level) throws KSIException {
        return this.signingHAService.sign(dataHash, level);
    }

    public Future<ExtensionResponse> extend(Date aggregationTime, Date publicationTime) throws KSIException {
        return this.extendingHAService.extend(aggregationTime, publicationTime);
    }

    public void registerAggregatorConfigurationListener(ConfigurationListener<AggregatorConfiguration> listener) {
        this.signingHAService.registerAggregatorConfigurationListener(listener);
    }

    public Future<AggregatorConfiguration> getAggregationConfiguration() {
        return this.signingHAService.getAggregationConfiguration();
    }

    public void registerExtenderConfigurationListener(ConfigurationListener<ExtenderConfiguration> listener) {
        this.extendingHAService.registerExtenderConfigurationListener(listener);
    }

    public Future<ExtenderConfiguration> getExtendingConfiguration() {
        return this.extendingHAService.getExtendingConfiguration();
    }

    public List<KSISigningService> getSubSigningServices() {
        return this.signingHAService.getSubSigningServices();
    }

    public List<KSIExtendingService> getSubExtendingServices() {
        return this.extendingHAService.getSubExtendingServices();
    }

    public void close() {
        this.signingHAService.close();
        this.extendingHAService.close();
    }

    public String toString() {
        return "HAService{SigningHAService='" + this.signingHAService + "', 'ExtendingHAService" + this.extendingHAService + "'}";
    }

    public static class Builder {
        private final SigningHAService.Builder signingHAServiceBuilder = new SigningHAService.Builder();
        private final ExtendingHAService.Builder extenderHAServiceBuilder = new ExtendingHAService.Builder();

        public Builder addSigningClients(List<KSISigningClient> clients) {
            this.signingHAServiceBuilder.addClients(clients);
            return this;
        }

        public Builder addSigningServices(List<KSISigningService> services) {
            this.signingHAServiceBuilder.addServices(services);
            return this;
        }

        public Builder addExtenderClients(List<KSIExtenderClient> clients) {
            this.extenderHAServiceBuilder.addClients(clients);
            return this;
        }

        public Builder addExtenderServices(List<KSIExtendingService> services) {
            this.extenderHAServiceBuilder.addServices(services);
            return this;
        }

        public Builder setExecutorService(ExecutorService executorService) {
            this.signingHAServiceBuilder.setExecutorService(executorService);
            this.extenderHAServiceBuilder.setExecutorService(executorService);
            return this;
        }

        public HAService build() {
            return new HAService(this.signingHAServiceBuilder.build(), this.extenderHAServiceBuilder.build());
        }
    }
}

