/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.service.ha;

import com.guardtime.ksi.concurrency.DefaultExecutorServiceProvider;
import com.guardtime.ksi.exceptions.KSIException;
import com.guardtime.ksi.hashing.DataHash;
import com.guardtime.ksi.pdu.AggregationResponse;
import com.guardtime.ksi.pdu.AggregatorConfiguration;
import com.guardtime.ksi.service.ConfigurationListener;
import com.guardtime.ksi.service.Future;
import com.guardtime.ksi.service.KSISigningClientServiceAdapter;
import com.guardtime.ksi.service.KSISigningService;
import com.guardtime.ksi.service.client.KSISigningClient;
import com.guardtime.ksi.service.ha.ServiceCallFuture;
import com.guardtime.ksi.service.ha.ServiceCallsTask;
import com.guardtime.ksi.service.ha.SigningHAServiceConfigurationListener;
import com.guardtime.ksi.service.ha.SigningTask;
import com.guardtime.ksi.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SigningHAService
implements KSISigningService {
    private static final Logger logger = LoggerFactory.getLogger(SigningHAService.class);
    private final List<KSISigningService> subservices;
    private final ExecutorService executorService;
    private final SigningHAServiceConfigurationListener haConfListener;

    private SigningHAService(List<KSISigningService> subservices, ExecutorService executorService) {
        this.executorService = executorService;
        this.subservices = subservices;
        this.haConfListener = new SigningHAServiceConfigurationListener(this.subservices);
    }

    public Future<AggregationResponse> sign(DataHash dataHash, Long level) throws KSIException {
        Util.notNull((Object)dataHash, (String)"dataHash");
        Util.notNull((Object)level, (String)"level");
        ArrayList tasks = new ArrayList(this.subservices.size());
        for (KSISigningService subservice : this.subservices) {
            tasks.add(new SigningTask(subservice, dataHash, level));
        }
        return new ServiceCallFuture<AggregationResponse>(this.executorService.submit(new ServiceCallsTask(this.executorService, tasks)));
    }

    public List<KSISigningService> getSubSigningServices() {
        return this.subservices;
    }

    public void registerAggregatorConfigurationListener(ConfigurationListener<AggregatorConfiguration> listener) {
        this.haConfListener.registerListener(listener);
    }

    public Future<AggregatorConfiguration> getAggregationConfiguration() {
        return this.haConfListener.getAggregationConfiguration();
    }

    public void close() {
        for (KSISigningService service : this.subservices) {
            try {
                service.close();
            }
            catch (IOException e) {
                logger.error("Failed to close subservice", (Throwable)e);
            }
        }
    }

    public String toString() {
        return "SigningHAService{subservices=" + this.subservices + "}";
    }

    public static class Builder {
        private List<KSISigningService> services = new ArrayList<KSISigningService>();
        private ExecutorService executorService = DefaultExecutorServiceProvider.getExecutorService();

        public Builder addClients(List<KSISigningClient> clients) {
            Util.notNull(clients, (String)"SigningHAService.Builder.clients");
            this.services.addAll(this.clientsToServices(clients));
            return this;
        }

        public Builder addServices(List<KSISigningService> services) {
            Util.notNull(services, (String)"SigningHAService.Builder.services");
            this.services.addAll(services);
            return this;
        }

        public Builder setExecutorService(ExecutorService executorService) {
            Util.notNull((Object)executorService, (String)"SigningHAService.Builder.executorService");
            this.executorService = executorService;
            return this;
        }

        public SigningHAService build() {
            List<KSISigningService> subservices = Collections.unmodifiableList(this.services);
            if (subservices.isEmpty()) {
                throw new IllegalArgumentException("Can not initialize SigningHAService without any subservices");
            }
            if (subservices.size() > 3) {
                throw new IllegalArgumentException("SigningHAService can not be initialized with more than 3 combined subservices or subclients");
            }
            return new SigningHAService(subservices, this.executorService);
        }

        private List<KSISigningService> clientsToServices(List<KSISigningClient> clients) {
            ArrayList<KSISigningService> services = new ArrayList<KSISigningService>(clients.size());
            for (KSISigningClient client : clients) {
                services.add((KSISigningService)new KSISigningClientServiceAdapter(client));
            }
            return services;
        }
    }
}

