/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.service.ha;

import com.guardtime.ksi.hashing.HashAlgorithm;
import com.guardtime.ksi.pdu.AggregatorConfiguration;
import com.guardtime.ksi.service.ha.HAConfUtil;
import com.guardtime.ksi.util.Util;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SigningHAServiceConfiguration
implements AggregatorConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(SigningHAServiceConfiguration.class);
    private static final int MIN_MAX_REQS = 0;
    private static final int MAX_MAX_REQS = 16000;
    private static final int MIN_MAX_LEVEL = 0;
    private static final int MAX_MAX_LEVEL = 20;
    private static final int MIN_AGGR_PERIOD = 100;
    private static final int MAX_AGGR_PERIOD = 20000;
    private final Long maxLevel;
    private final HashAlgorithm aggrAlgorithm;
    private final Long aggrPeriod;
    private final Long maxRequests;
    private final List<String> parents;

    SigningHAServiceConfiguration(AggregatorConfiguration configuration) {
        Util.notNull((Object)configuration, (String)"SigningHAServiceConfiguration configuration to copy");
        this.maxLevel = this.normalizeMaxLevel(configuration.getMaximumLevel());
        this.aggrPeriod = this.normalizeAggregationPeriod(configuration.getAggregationPeriod());
        this.maxRequests = this.normalizeMaxRequests(configuration.getMaximumRequests());
        this.aggrAlgorithm = configuration.getAggregationAlgorithm();
        this.parents = configuration.getParents();
    }

    SigningHAServiceConfiguration(AggregatorConfiguration c1, AggregatorConfiguration c2) {
        Util.notNull((Object)c1, (String)"SigningHAServiceConfiguration first configuration to consolidate");
        Util.notNull((Object)c2, (String)"SigningHAServiceConfiguration second configuration to consolidate");
        Long c1MaxLevel = this.normalizeMaxLevel(c1.getMaximumLevel());
        Long c2MaxLevel = this.normalizeMaxLevel(c2.getMaximumLevel());
        this.maxLevel = HAConfUtil.isBigger(c1MaxLevel, c2MaxLevel) ? c2MaxLevel : c1MaxLevel;
        Long c1AggrPeriod = this.normalizeAggregationPeriod(c1.getAggregationPeriod());
        Long c2AggrPeriod = this.normalizeAggregationPeriod(c2.getAggregationPeriod());
        this.aggrPeriod = HAConfUtil.isSmaller(c1AggrPeriod, c2AggrPeriod) ? c2AggrPeriod : c1AggrPeriod;
        Long c1MaxReqs = this.normalizeMaxRequests(c1.getMaximumRequests());
        Long c2MaxReqs = this.normalizeMaxRequests(c2.getMaximumRequests());
        this.maxRequests = HAConfUtil.isBigger(c1MaxReqs, c2MaxReqs) ? c2MaxReqs : c1MaxReqs;
        this.aggrAlgorithm = c1.getAggregationAlgorithm() == null ? c2.getAggregationAlgorithm() : c1.getAggregationAlgorithm();
        this.parents = c1.getParents() == null ? c2.getParents() : c1.getParents();
    }

    public Long getMaximumLevel() {
        return this.maxLevel;
    }

    public HashAlgorithm getAggregationAlgorithm() {
        return this.aggrAlgorithm;
    }

    public Long getAggregationPeriod() {
        return this.aggrPeriod;
    }

    public Long getMaximumRequests() {
        return this.maxRequests;
    }

    public List<String> getParents() {
        return this.parents;
    }

    private Long normalizeMaxRequests(Long maxRequests) {
        if (this.isMaxRequestsSane(maxRequests)) {
            return maxRequests;
        }
        logger.warn("Received max requests '{}' from an aggregator. Will not use it as only values between {} and {} are considered sane.", new Object[]{maxRequests, 0, 16000});
        return null;
    }

    private Long normalizeMaxLevel(Long maxLevel) {
        if (this.isMaxLevelSane(maxLevel)) {
            return maxLevel;
        }
        logger.warn("Received max level '{}' from an aggregator. Will not use it as only values between {} and {} are considered sane.", new Object[]{maxLevel, 0, 20});
        return null;
    }

    private Long normalizeAggregationPeriod(Long maxLevel) {
        if (this.isAggregationPeriodSane(maxLevel)) {
            return maxLevel;
        }
        logger.warn("Received aggregation period '{}' from an aggregator. Will not use it as only values between {} and {} are considered sane.", new Object[]{maxLevel, 100, 20000});
        return null;
    }

    private boolean isMaxRequestsSane(Long maxRequests) {
        return maxRequests == null || maxRequests > 0L && maxRequests <= 16000L;
    }

    private boolean isMaxLevelSane(Long maxLevel) {
        return maxLevel == null || maxLevel >= 0L && maxLevel <= 20L;
    }

    private boolean isAggregationPeriodSane(Long aggrPeriod) {
        return aggrPeriod == null || aggrPeriod >= 100L && aggrPeriod <= 20000L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AggregatorConfiguration)) {
            return false;
        }
        AggregatorConfiguration that = (AggregatorConfiguration)o;
        return Util.equals((Object)this.getAggregationAlgorithm(), (Object)that.getAggregationAlgorithm()) && Util.equals((Object)this.getAggregationPeriod(), (Object)that.getAggregationPeriod()) && Util.equals((Object)this.getMaximumLevel(), (Object)that.getMaximumLevel()) && Util.equals((Object)this.getMaximumRequests(), (Object)that.getMaximumRequests()) && Util.equalsIgnoreOrder(this.getParents(), (Collection)that.getParents());
    }

    public String toString() {
        return "SigningHAServiceConfiguration{maxLevel=" + this.maxLevel + ", aggrAlgorithm=" + this.aggrAlgorithm + ", aggrPeriod=" + this.aggrPeriod + ", maxRequests=" + this.maxRequests + ", parents=" + this.parents + '}';
    }
}

