/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.service.ha;

import com.guardtime.ksi.pdu.AggregatorConfiguration;
import com.guardtime.ksi.service.Future;
import com.guardtime.ksi.service.KSISigningService;
import com.guardtime.ksi.service.ha.AbstractHAConfigurationListener;
import com.guardtime.ksi.service.ha.ConsolidatedResult;
import com.guardtime.ksi.service.ha.HAConfFuture;
import com.guardtime.ksi.service.ha.SigningHAServiceConfiguration;
import com.guardtime.ksi.service.ha.SubServiceConfListener;
import java.util.ArrayList;
import java.util.List;

class SigningHAServiceConfigurationListener
extends AbstractHAConfigurationListener<AggregatorConfiguration> {
    private final List<SubServiceConfListener<AggregatorConfiguration>> subServiceConfListeners = new ArrayList<SubServiceConfListener<AggregatorConfiguration>>();
    private final List<KSISigningService> subservices;

    SigningHAServiceConfigurationListener(List<KSISigningService> subservices) {
        this.subservices = subservices;
        for (KSISigningService subservice : subservices) {
            SubServiceConfListener<AggregatorConfiguration> listener = new SubServiceConfListener<AggregatorConfiguration>(subservice.toString(), this);
            subservice.registerAggregatorConfigurationListener(listener);
            this.subServiceConfListeners.add(listener);
        }
    }

    @Override
    protected AggregatorConfiguration consolidate(AggregatorConfiguration c1, AggregatorConfiguration c2) {
        boolean c2Exists;
        boolean c1Exists = c1 != null;
        boolean bl = c2Exists = c2 != null;
        if (c1Exists && c2Exists) {
            return new SigningHAServiceConfiguration(c1, c2);
        }
        if (c1Exists) {
            return new SigningHAServiceConfiguration(c1);
        }
        if (c2Exists) {
            return new SigningHAServiceConfiguration(c2);
        }
        return null;
    }

    @Override
    List<SubServiceConfListener<AggregatorConfiguration>> getSubServiceConfListeners() {
        return this.subServiceConfListeners;
    }

    Future<AggregatorConfiguration> getAggregationConfiguration() {
        return new HAConfFuture<AggregatorConfiguration>(this.invokeSubServiceConfUpdates(), new HAConfFuture.ConfResultSupplier<ConsolidatedResult<AggregatorConfiguration>>(){

            @Override
            public ConsolidatedResult<AggregatorConfiguration> get() {
                return SigningHAServiceConfigurationListener.this.lastConsolidatedConfiguration;
            }
        });
    }

    private List<Future<AggregatorConfiguration>> invokeSubServiceConfUpdates() {
        ArrayList<Future<AggregatorConfiguration>> confFutures = new ArrayList<Future<AggregatorConfiguration>>();
        for (KSISigningService service : this.subservices) {
            confFutures.add((Future<AggregatorConfiguration>)service.getAggregationConfiguration());
        }
        return confFutures;
    }
}

