/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.service.ha;

import com.guardtime.ksi.hashing.DataHash;
import com.guardtime.ksi.pdu.AggregationResponse;
import com.guardtime.ksi.service.KSISigningService;
import com.guardtime.ksi.service.client.KSIClientException;
import java.util.concurrent.Callable;

class SigningTask
implements Callable<AggregationResponse> {
    private final KSISigningService service;
    private DataHash dataHash;
    private Long level;

    public SigningTask(KSISigningService service, DataHash dataHash, Long level) {
        this.service = service;
        this.dataHash = dataHash;
        this.level = level;
    }

    @Override
    public AggregationResponse call() throws KSIClientException {
        try {
            return (AggregationResponse)this.service.sign(this.dataHash, this.level).getResult();
        }
        catch (Exception e) {
            throw new KSIClientException("Signing via service '" + this.service + "' failed", (Throwable)e);
        }
    }
}

