/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.service.ha;

import com.guardtime.ksi.service.ConfigurationListener;
import com.guardtime.ksi.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SubServiceConfListener<T>
implements ConfigurationListener<T> {
    private static final Logger logger = LoggerFactory.getLogger(SubServiceConfListener.class);
    private final ConfigurationListener<T> parent;
    private final String clientId;
    private T lastConfiguration;

    SubServiceConfListener(String clientId, ConfigurationListener<T> parent) {
        Util.notNull((Object)clientId, (String)"SubServiceConfListener.clientId");
        Util.notNull(parent, (String)"SubServiceConfListener.parent");
        this.clientId = clientId;
        this.parent = parent;
    }

    boolean isAccountedFor() {
        return this.lastConfiguration != null;
    }

    T getLastConfiguration() {
        return this.lastConfiguration;
    }

    public void updated(T configuration) {
        this.lastConfiguration = configuration;
        this.parent.updated(configuration);
    }

    public void updateFailed(Throwable t) {
        this.lastConfiguration = null;
        logger.warn("SigningHAService " + this.clientId + " subclients configuration request failed.", t);
        this.parent.updateFailed(t);
    }
}

