/*
 * Decompiled with CFR 0.152.
 */
package com.guhungry.photomanipulator;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapRegionDecoder;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.os.Build;
import androidx.exifinterface.media.ExifInterface;
import com.guhungry.photomanipulator.factory.AndroidConcreteFactory;
import com.guhungry.photomanipulator.factory.AndroidFactory;
import com.guhungry.photomanipulator.model.CGRect;
import com.guhungry.photomanipulator.model.CGSize;
import com.guhungry.photomanipulator.model.FlipMode;
import com.guhungry.photomanipulator.model.RotationMode;
import com.guhungry.photomanipulator.model.TextStyle;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J4\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0007J\u0018\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J/\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001cJ\u0018\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020!H\u0007J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010$\u001a\u0004\u0018\u00010\u00152\u0006\u0010\n\u001a\u00020\u000bJ*\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\t2\u0006\u0010%\u001a\u00020\t2\u0006\u0010(\u001a\u00020)2\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0007J2\u0010*\u001a\u00020&2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010+\u001a\u00020,2\u0006\u0010(\u001a\u00020)2\u0006\u0010-\u001a\u00020.2\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0007Jk\u0010*\u001a\u00020&2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010+\u001a\u00020,2\u0006\u0010(\u001a\u00020)2\u0006\u0010/\u001a\u00020\u00042\u0006\u00100\u001a\u00020\u00062\n\b\u0002\u00101\u001a\u0004\u0018\u0001022\b\b\u0002\u00103\u001a\u0002042\b\b\u0002\u00105\u001a\u00020\u00062\n\b\u0002\u00106\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0007\u00a2\u0006\u0002\u00107J\u0010\u00108\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u00109\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020:H\u0007J\u0014\u0010;\u001a\u00020&*\u00020<2\u0006\u0010-\u001a\u00020.H\u0002J\u0014\u0010=\u001a\u00020&*\u00020<2\u0006\u0010-\u001a\u00020.H\u0002\u00a8\u0006>"}, d2={"Lcom/guhungry/photomanipulator/BitmapUtils;", "", "()V", "applyScale", "", "value", "", "sampleSize", "crop", "Landroid/graphics/Bitmap;", "input", "Ljava/io/InputStream;", "region", "Lcom/guhungry/photomanipulator/model/CGRect;", "outOptions", "Landroid/graphics/BitmapFactory$Options;", "cropAndResize", "cropSize", "targetSize", "Lcom/guhungry/photomanipulator/model/CGSize;", "matrix", "Landroid/graphics/Matrix;", "decodeSampleSize", "sourceSize", "findCropPosition", "rect", "factory", "Lcom/guhungry/photomanipulator/factory/AndroidFactory;", "findCropPosition$photomanipulator_release", "findCropScale", "flip", "image", "mode", "Lcom/guhungry/photomanipulator/model/FlipMode;", "getBitmapRegionDecoder", "Landroid/graphics/BitmapRegionDecoder;", "getCorrectOrientationMatrix", "overlay", "", "background", "position", "Landroid/graphics/PointF;", "printText", "text", "", "textStyle", "Lcom/guhungry/photomanipulator/model/TextStyle;", "color", "size", "font", "Landroid/graphics/Typeface;", "alignment", "Landroid/graphics/Paint$Align;", "thickness", "rotation", "(Landroid/graphics/Bitmap;Ljava/lang/String;Landroid/graphics/PointF;IFLandroid/graphics/Typeface;Landroid/graphics/Paint$Align;FLjava/lang/Float;Lcom/guhungry/photomanipulator/factory/AndroidFactory;)V", "readImageDimensions", "rotate", "Lcom/guhungry/photomanipulator/model/RotationMode;", "setTextBorder", "Landroid/graphics/Paint;", "setTextShadow", "photomanipulator_release"})
@SourceDebugExtension(value={"SMAP\nBitmapUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitmapUtils.kt\ncom/guhungry/photomanipulator/BitmapUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,275:1\n1#2:276\n1855#3,2:277\n*S KotlinDebug\n*F\n+ 1 BitmapUtils.kt\ncom/guhungry/photomanipulator/BitmapUtils\n*L\n201#1:277,2\n*E\n"})
public final class BitmapUtils {
    @NotNull
    public static final BitmapUtils INSTANCE = new BitmapUtils();

    private BitmapUtils() {
    }

    @JvmStatic
    @NotNull
    public static final CGSize readImageDimensions(@NotNull InputStream input) {
        BitmapFactory.Options options;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        BitmapFactory.Options $this$readImageDimensions_u24lambda_u240 = options = new BitmapFactory.Options();
        boolean bl = false;
        $this$readImageDimensions_u24lambda_u240.inJustDecodeBounds = true;
        BitmapFactory.Options options2 = options;
        BitmapFactory.decodeStream((InputStream)input, null, (BitmapFactory.Options)options2);
        return new CGSize(options2.outWidth, options2.outHeight);
    }

    private final int decodeSampleSize(CGSize sourceSize, CGSize targetSize) {
        int sampleSize = 1;
        if (sourceSize.getHeight() > targetSize.getHeight() || sourceSize.getWidth() > targetSize.getWidth()) {
            int halfHeight = sourceSize.getHeight() / 2;
            int halfWidth = sourceSize.getWidth() / 2;
            while (halfWidth / sampleSize >= targetSize.getWidth() && halfHeight / sampleSize >= targetSize.getHeight()) {
                sampleSize *= 2;
            }
        }
        return sampleSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final Bitmap crop(@NotNull InputStream input, @NotNull CGRect region, @NotNull BitmapFactory.Options outOptions) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        Intrinsics.checkNotNullParameter((Object)outOptions, (String)"outOptions");
        Closeable closeable = input;
        Throwable throwable = null;
        try {
            Bitmap bitmap;
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            BitmapRegionDecoder decoder = INSTANCE.getBitmapRegionDecoder(input);
            try {
                Bitmap bitmap2 = decoder.decodeRegion(region.toRect(), outOptions);
                Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"decoder.decodeRegion(region.toRect(), outOptions)");
                bitmap = bitmap2;
            }
            catch (Throwable throwable2) {
                try {
                    decoder.recycle();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            decoder.recycle();
            Bitmap bitmap3 = bitmap;
            return bitmap3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final BitmapRegionDecoder getBitmapRegionDecoder(InputStream input) {
        BitmapRegionDecoder bitmapRegionDecoder;
        if (Build.VERSION.SDK_INT >= 31) {
            BitmapRegionDecoder bitmapRegionDecoder2 = BitmapRegionDecoder.newInstance((InputStream)input);
            bitmapRegionDecoder = bitmapRegionDecoder2;
            Intrinsics.checkNotNull((Object)bitmapRegionDecoder2);
        } else {
            BitmapRegionDecoder bitmapRegionDecoder3 = BitmapRegionDecoder.newInstance((InputStream)input, (boolean)false);
            bitmapRegionDecoder = bitmapRegionDecoder3;
            Intrinsics.checkNotNull((Object)bitmapRegionDecoder3);
        }
        Intrinsics.checkNotNullExpressionValue((Object)bitmapRegionDecoder, (String)"if (Build.VERSION.SDK_IN\u2026input, false)!!\n        }");
        return bitmapRegionDecoder;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Bitmap cropAndResize(@NotNull InputStream input, @NotNull CGRect cropSize, @NotNull CGSize targetSize, @NotNull BitmapFactory.Options outOptions, @Nullable Matrix matrix) {
        Bitmap bitmap;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)cropSize, (String)"cropSize");
        Intrinsics.checkNotNullParameter((Object)targetSize, (String)"targetSize");
        Intrinsics.checkNotNullParameter((Object)outOptions, (String)"outOptions");
        outOptions.inSampleSize = INSTANCE.decodeSampleSize(cropSize.getSize(), targetSize);
        outOptions.inJustDecodeBounds = false;
        Bitmap bitmap2 = BitmapFactory.decodeStream((InputStream)input, null, (BitmapFactory.Options)outOptions);
        if (bitmap2 == null) {
            throw new IOException("Cannot decode bitmap: uri");
        }
        Bitmap bitmap3 = bitmap2;
        if (matrix != null) {
            Bitmap bitmap4;
            Bitmap it = bitmap4 = Bitmap.createBitmap((Bitmap)bitmap3, (int)0, (int)0, (int)bitmap3.getWidth(), (int)bitmap3.getHeight(), (Matrix)matrix, (boolean)true);
            boolean bl = false;
            bitmap3.recycle();
            bitmap = bitmap4;
        } else {
            bitmap = bitmap3;
        }
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"if (matrix != null) Bitm\u2026.recycle()  } else bitmap");
        Bitmap rotated = bitmap;
        CGRect crop = BitmapUtils.findCropPosition$photomanipulator_release$default(INSTANCE, cropSize, targetSize, outOptions.inSampleSize, null, 8, null);
        Matrix scaleMatrix = INSTANCE.findCropScale(crop, targetSize);
        Bitmap bitmap5 = Bitmap.createBitmap((Bitmap)rotated, (int)crop.getOrigin().x, (int)crop.getOrigin().y, (int)crop.getSize().getWidth(), (int)crop.getSize().getHeight(), (Matrix)scaleMatrix, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap5, (String)"createBitmap(rotated, cr\u2026eight, scaleMatrix, true)");
        return bitmap5;
    }

    public static /* synthetic */ Bitmap cropAndResize$default(InputStream inputStream, CGRect cGRect, CGSize cGSize, BitmapFactory.Options options, Matrix matrix, int n, Object object) {
        if ((n & 0x10) != 0) {
            matrix = null;
        }
        return BitmapUtils.cropAndResize(inputStream, cGRect, cGSize, options, matrix);
    }

    @NotNull
    public final CGRect findCropPosition$photomanipulator_release(@NotNull CGRect rect, @NotNull CGSize targetSize, int sampleSize, @NotNull AndroidFactory factory) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)targetSize, (String)"targetSize");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        float newWidth = 0.0f;
        float newHeight = 0.0f;
        float newX = 0.0f;
        float newY = 0.0f;
        float cropRectRatio = rect.getSize().ratio();
        float targetRatio = targetSize.ratio();
        if (cropRectRatio > targetRatio) {
            newWidth = (float)Math.floor((float)rect.getSize().getHeight() * targetRatio);
            newHeight = rect.getSize().getHeight();
            newX = (float)rect.getOrigin().x + ((float)rect.getSize().getWidth() - newWidth) / (float)2;
            newY = rect.getOrigin().y;
        } else {
            newWidth = rect.getSize().getWidth();
            newHeight = (float)Math.floor((float)rect.getSize().getWidth() / targetRatio);
            newX = rect.getOrigin().x;
            newY = (float)rect.getOrigin().y + ((float)rect.getSize().getHeight() - newHeight) / (float)2;
        }
        return new CGRect(this.applyScale(newX, sampleSize), this.applyScale(newY, sampleSize), this.applyScale(newWidth, sampleSize), this.applyScale(newHeight, sampleSize), factory);
    }

    public static /* synthetic */ CGRect findCropPosition$photomanipulator_release$default(BitmapUtils bitmapUtils, CGRect cGRect, CGSize cGSize, int n, AndroidFactory androidFactory, int n2, Object object) {
        if ((n2 & 8) != 0) {
            androidFactory = new AndroidConcreteFactory();
        }
        return bitmapUtils.findCropPosition$photomanipulator_release(cGRect, cGSize, n, androidFactory);
    }

    private final int applyScale(float value, int sampleSize) {
        return (int)Math.floor(value / (float)sampleSize);
    }

    private final Matrix findCropScale(CGRect rect, CGSize targetSize) {
        Matrix matrix;
        float targetRatio;
        float cropRectRatio = rect.getSize().ratio();
        float cropScale = cropRectRatio > (targetRatio = targetSize.ratio()) ? (float)targetSize.getHeight() / (float)rect.getSize().getHeight() : (float)targetSize.getWidth() / (float)rect.getSize().getWidth();
        Matrix $this$findCropScale_u24lambda_u243 = matrix = new Matrix();
        boolean bl = false;
        $this$findCropScale_u24lambda_u243.setScale(cropScale, cropScale);
        return matrix;
    }

    @JvmStatic
    @Deprecated(message="Use printText(Bitmap, String, PointF, TextStyle, AndroidFactory) instead")
    @JvmOverloads
    public static final void printText(@NotNull Bitmap image, @NotNull String text, @NotNull PointF position, int color, float size, @Nullable Typeface font, @NotNull Paint.Align alignment, float thickness, @Nullable Float rotation, @NotNull AndroidFactory factory) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)alignment, (String)"alignment");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        TextStyle style = new TextStyle(color, size, font, alignment, thickness, rotation, 0.0f, 0.0f, 0.0f, null, 960, null);
        BitmapUtils.printText(image, text, position, style, factory);
    }

    public static /* synthetic */ void printText$default(Bitmap bitmap, String string, PointF pointF, int n, float f, Typeface typeface, Paint.Align align, float f2, Float f3, AndroidFactory androidFactory, int n2, Object object) {
        if ((n2 & 0x20) != 0) {
            typeface = null;
        }
        if ((n2 & 0x40) != 0) {
            align = Paint.Align.LEFT;
        }
        if ((n2 & 0x80) != 0) {
            f2 = 0.0f;
        }
        if ((n2 & 0x100) != 0) {
            f3 = null;
        }
        if ((n2 & 0x200) != 0) {
            androidFactory = new AndroidConcreteFactory();
        }
        BitmapUtils.printText(bitmap, string, pointF, n, f, typeface, align, f2, f3, androidFactory);
    }

    @JvmStatic
    @JvmOverloads
    public static final void printText(@NotNull Bitmap image, @NotNull String text, @NotNull PointF position, @NotNull TextStyle textStyle, @NotNull AndroidFactory factory) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"textStyle");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        if (StringsKt.isBlank((CharSequence)text)) {
            return;
        }
        Canvas canvas = factory.makeCanvas(image);
        String[] $this$printText_u24lambda_u245 = stringArray = factory.makePaint();
        boolean bl = false;
        $this$printText_u24lambda_u245.setColor(textStyle.getColor());
        $this$printText_u24lambda_u245.setTextSize(textStyle.getSize());
        $this$printText_u24lambda_u245.setTextAlign(textStyle.getAlignment());
        $this$printText_u24lambda_u245.setAntiAlias(true);
        Typeface typeface = textStyle.getFont();
        if (typeface != null) {
            Typeface it = typeface;
            boolean bl2 = false;
            $this$printText_u24lambda_u245.setTypeface(it);
        }
        INSTANCE.setTextBorder((Paint)$this$printText_u24lambda_u245, textStyle);
        INSTANCE.setTextShadow((Paint)$this$printText_u24lambda_u245, textStyle);
        String[] paint = stringArray;
        float offset = 0.0f;
        offset = position.y + textStyle.getSize() / (float)2;
        canvas.save();
        Float f = textStyle.getRotation();
        canvas.rotate(-(f != null ? f.floatValue() : 0.0f), position.x, offset);
        $this$printText_u24lambda_u245 = new String[]{"\n"};
        Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)text, (String[])$this$printText_u24lambda_u245, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl3 = false;
            canvas.drawText(it, position.x, offset, (Paint)paint);
            offset += paint.descent() - paint.ascent();
        }
        canvas.restore();
    }

    public static /* synthetic */ void printText$default(Bitmap bitmap, String string, PointF pointF, TextStyle textStyle, AndroidFactory androidFactory, int n, Object object) {
        if ((n & 0x10) != 0) {
            androidFactory = new AndroidConcreteFactory();
        }
        BitmapUtils.printText(bitmap, string, pointF, textStyle, androidFactory);
    }

    private final void setTextBorder(Paint $this$setTextBorder, TextStyle textStyle) {
        if (textStyle.getThickness() <= 0.0f) {
            return;
        }
        $this$setTextBorder.setStyle(Paint.Style.STROKE);
        $this$setTextBorder.setStrokeWidth(textStyle.getThickness());
    }

    private final void setTextShadow(Paint $this$setTextShadow, TextStyle textStyle) {
        if (textStyle.getShadowColor() == null || textStyle.getShadowRadius() <= 0.0f) {
            return;
        }
        $this$setTextShadow.setShadowLayer(textStyle.getShadowRadius(), textStyle.getShadowOffsetX(), textStyle.getShadowOffsetY(), textStyle.getShadowColor().intValue());
    }

    @JvmStatic
    @JvmOverloads
    public static final void overlay(@NotNull Bitmap background, @NotNull Bitmap overlay, @NotNull PointF position, @NotNull AndroidFactory factory) {
        Paint paint;
        Intrinsics.checkNotNullParameter((Object)background, (String)"background");
        Intrinsics.checkNotNullParameter((Object)overlay, (String)"overlay");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Canvas canvas = factory.makeCanvas(background);
        Paint $this$overlay_u24lambda_u247 = paint = factory.makePaint();
        boolean bl = false;
        $this$overlay_u24lambda_u247.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_OVER));
        Paint paint2 = paint;
        canvas.drawBitmap(overlay, position.x, position.y, paint2);
    }

    public static /* synthetic */ void overlay$default(Bitmap bitmap, Bitmap bitmap2, PointF pointF, AndroidFactory androidFactory, int n, Object object) {
        if ((n & 8) != 0) {
            androidFactory = new AndroidConcreteFactory();
        }
        BitmapUtils.overlay(bitmap, bitmap2, pointF, androidFactory);
    }

    @JvmStatic
    @NotNull
    public static final Bitmap flip(@NotNull Bitmap image, @NotNull FlipMode mode) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        if (mode == FlipMode.None) {
            return image;
        }
        Matrix matrix = new Matrix();
        matrix.preScale(mode.getScaleX(), mode.getScaleY());
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)image, (int)0, (int)0, (int)image.getWidth(), (int)image.getHeight(), (Matrix)matrix, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(image, 0, 0\u2026etHeight(), matrix, true)");
        return bitmap;
    }

    @JvmStatic
    @NotNull
    public static final Bitmap rotate(@NotNull Bitmap image, @NotNull RotationMode mode) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        if (mode == RotationMode.None) {
            return image;
        }
        Matrix matrix = new Matrix();
        matrix.preRotate(mode.getDegrees());
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)image, (int)0, (int)0, (int)image.getWidth(), (int)image.getHeight(), (Matrix)matrix, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(image, 0, 0\u2026etHeight(), matrix, true)");
        return bitmap;
    }

    @Nullable
    public final Matrix getCorrectOrientationMatrix(@NotNull InputStream input) {
        Matrix matrix;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        ExifInterface exif = new ExifInterface(input);
        boolean isFlippedHorizontal = exif.isFlipped();
        int rotationDegrees = exif.getRotationDegrees();
        if (!isFlippedHorizontal && rotationDegrees == 0) {
            return null;
        }
        Matrix $this$getCorrectOrientationMatrix_u24lambda_u248 = matrix = new Matrix();
        boolean bl = false;
        $this$getCorrectOrientationMatrix_u24lambda_u248.postRotate((float)rotationDegrees);
        if (isFlippedHorizontal) {
            $this$getCorrectOrientationMatrix_u24lambda_u248.preScale(-1.0f, 1.0f);
        }
        return matrix;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Bitmap cropAndResize(@NotNull InputStream input, @NotNull CGRect cropSize, @NotNull CGSize targetSize, @NotNull BitmapFactory.Options outOptions) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)cropSize, (String)"cropSize");
        Intrinsics.checkNotNullParameter((Object)targetSize, (String)"targetSize");
        Intrinsics.checkNotNullParameter((Object)outOptions, (String)"outOptions");
        return BitmapUtils.cropAndResize$default(input, cropSize, targetSize, outOptions, null, 16, null);
    }

    @JvmStatic
    @Deprecated(message="Use printText(Bitmap, String, PointF, TextStyle, AndroidFactory) instead")
    @JvmOverloads
    public static final void printText(@NotNull Bitmap image, @NotNull String text, @NotNull PointF position, int color, float size, @Nullable Typeface font, @NotNull Paint.Align alignment, float thickness, @Nullable Float rotation) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)alignment, (String)"alignment");
        BitmapUtils.printText$default(image, text, position, color, size, font, alignment, thickness, rotation, null, 512, null);
    }

    @JvmStatic
    @Deprecated(message="Use printText(Bitmap, String, PointF, TextStyle, AndroidFactory) instead")
    @JvmOverloads
    public static final void printText(@NotNull Bitmap image, @NotNull String text, @NotNull PointF position, int color, float size, @Nullable Typeface font, @NotNull Paint.Align alignment, float thickness) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)alignment, (String)"alignment");
        BitmapUtils.printText$default(image, text, position, color, size, font, alignment, thickness, null, null, 768, null);
    }

    @JvmStatic
    @Deprecated(message="Use printText(Bitmap, String, PointF, TextStyle, AndroidFactory) instead")
    @JvmOverloads
    public static final void printText(@NotNull Bitmap image, @NotNull String text, @NotNull PointF position, int color, float size, @Nullable Typeface font, @NotNull Paint.Align alignment) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)alignment, (String)"alignment");
        BitmapUtils.printText$default(image, text, position, color, size, font, alignment, 0.0f, null, null, 896, null);
    }

    @JvmStatic
    @Deprecated(message="Use printText(Bitmap, String, PointF, TextStyle, AndroidFactory) instead")
    @JvmOverloads
    public static final void printText(@NotNull Bitmap image, @NotNull String text, @NotNull PointF position, int color, float size, @Nullable Typeface font) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        BitmapUtils.printText$default(image, text, position, color, size, font, null, 0.0f, null, null, 960, null);
    }

    @JvmStatic
    @Deprecated(message="Use printText(Bitmap, String, PointF, TextStyle, AndroidFactory) instead")
    @JvmOverloads
    public static final void printText(@NotNull Bitmap image, @NotNull String text, @NotNull PointF position, int color, float size) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        BitmapUtils.printText$default(image, text, position, color, size, null, null, 0.0f, null, null, 992, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void printText(@NotNull Bitmap image, @NotNull String text, @NotNull PointF position, @NotNull TextStyle textStyle) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"textStyle");
        BitmapUtils.printText$default(image, text, position, textStyle, null, 16, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void overlay(@NotNull Bitmap background, @NotNull Bitmap overlay, @NotNull PointF position) {
        Intrinsics.checkNotNullParameter((Object)background, (String)"background");
        Intrinsics.checkNotNullParameter((Object)overlay, (String)"overlay");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        BitmapUtils.overlay$default(background, overlay, position, null, 8, null);
    }
}

