/*
 * Decompiled with CFR 0.152.
 */
package com.guhungry.photomanipulator;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Base64;
import com.guhungry.photomanipulator.MimeUtils;
import com.guhungry.photomanipulator.factory.AndroidConcreteFactory;
import com.guhungry.photomanipulator.factory.AndroidFactory;
import com.guhungry.photomanipulator.helper.AndroidConcreteFile;
import com.guhungry.photomanipulator.helper.AndroidFile;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0004H\u0007J,\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J\"\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00042\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0007J2\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\t2\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006#"}, d2={"Lcom/guhungry/photomanipulator/FileUtils;", "", "()V", "BASE64_URI_PREFIX", "", "LOCAL_URI_PREFIXES", "", "[Ljava/lang/String;", "cachePath", "Ljava/io/File;", "context", "Landroid/content/Context;", "cleanDirectory", "", "directory", "prefix", "createTempFile", "mimeType", "file", "Lcom/guhungry/photomanipulator/helper/AndroidFile;", "isBase64Data", "", "uri", "isLocalUri", "openBitmapInputStream", "Ljava/io/InputStream;", "factory", "Lcom/guhungry/photomanipulator/factory/AndroidFactory;", "saveImageFile", "image", "Landroid/graphics/Bitmap;", "mime", "quality", "", "target", "photomanipulator_release"})
@SourceDebugExtension(value={"SMAP\nFileUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileUtils.kt\ncom/guhungry/photomanipulator/FileUtils\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,86:1\n12474#2,2:87\n13309#2,2:89\n*S KotlinDebug\n*F\n+ 1 FileUtils.kt\ncom/guhungry/photomanipulator/FileUtils\n*L\n24#1:87,2\n62#1:89,2\n*E\n"})
public final class FileUtils {
    @NotNull
    public static final FileUtils INSTANCE = new FileUtils();
    @NotNull
    private static final String[] LOCAL_URI_PREFIXES;
    @NotNull
    private static final String BASE64_URI_PREFIX = "data:";

    private FileUtils() {
    }

    private final boolean isLocalUri(String uri) {
        boolean bl;
        block1: {
            String[] $this$any$iv = LOCAL_URI_PREFIXES;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!StringsKt.startsWith$default((String)uri, (String)it, (boolean)false, (int)2, null)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    @NotNull
    public static final File createTempFile(@NotNull Context context, @NotNull String prefix, @Nullable String mimeType, @NotNull AndroidFile file) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file.createTempFile(prefix, MimeUtils.toExtension(mimeType), FileUtils.cachePath(context));
    }

    public static /* synthetic */ File createTempFile$default(Context context, String string, String string2, AndroidFile androidFile, int n, Object object) {
        if ((n & 8) != 0) {
            androidFile = new AndroidConcreteFile();
        }
        return FileUtils.createTempFile(context, string, string2, androidFile);
    }

    @JvmStatic
    @Nullable
    public static final File cachePath(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        File externalCacheDir = context.getExternalCacheDir();
        File internalCacheDir = context.getCacheDir();
        if (externalCacheDir == null && internalCacheDir == null) {
            throw new IOException("No cache directory available");
        }
        return externalCacheDir == null ? internalCacheDir : (internalCacheDir == null ? externalCacheDir : (externalCacheDir.getFreeSpace() > internalCacheDir.getFreeSpace() ? externalCacheDir : internalCacheDir));
    }

    @JvmStatic
    public static final void cleanDirectory(@NotNull File directory, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        File[] fileArray = directory.listFiles((arg_0, arg_1) -> FileUtils.cleanDirectory$lambda$1(prefix, arg_0, arg_1));
        if (fileArray != null) {
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                it.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void saveImageFile(@NotNull Bitmap image, @NotNull String mime, int quality, @NotNull File target, @NotNull AndroidFile file) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)mime, (String)"mime");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Closeable closeable = file.makeFileOutputStream(target);
        Throwable throwable = null;
        try {
            FileOutputStream it = (FileOutputStream)closeable;
            boolean bl = false;
            boolean bl2 = image.compress(MimeUtils.toCompressFormat(mime), quality, (OutputStream)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void saveImageFile$default(Bitmap bitmap, String string, int n, File file, AndroidFile androidFile, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            androidFile = new AndroidConcreteFile();
        }
        FileUtils.saveImageFile(bitmap, string, n, file, androidFile);
    }

    @JvmStatic
    @NotNull
    public static final InputStream openBitmapInputStream(@NotNull Context context, @NotNull String uri, @NotNull AndroidFactory factory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        if (INSTANCE.isBase64Data(uri)) {
            String string = uri.substring(StringsKt.indexOf$default((CharSequence)uri, (String)",", (int)0, (boolean)false, (int)6, null) + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String data = string;
            return new ByteArrayInputStream(Base64.decode((String)data, (int)0));
        }
        if (INSTANCE.isLocalUri(uri)) {
            InputStream inputStream = context.getContentResolver().openInputStream(factory.makeUri(uri));
            if (inputStream == null) {
                throw new IOException("Cannot open bitmap: " + uri);
            }
            return inputStream;
        }
        InputStream inputStream = new URL(uri).openConnection().getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"URL(uri).openConnection().getInputStream()");
        return inputStream;
    }

    public static /* synthetic */ InputStream openBitmapInputStream$default(Context context, String string, AndroidFactory androidFactory, int n, Object object) {
        if ((n & 4) != 0) {
            androidFactory = new AndroidConcreteFactory();
        }
        return FileUtils.openBitmapInputStream(context, string, androidFactory);
    }

    private final boolean isBase64Data(String uri) {
        return StringsKt.startsWith$default((String)uri, (String)BASE64_URI_PREFIX, (boolean)false, (int)2, null);
    }

    private static final boolean cleanDirectory$lambda$1(String $prefix, File file, String name) {
        Intrinsics.checkNotNullParameter((Object)$prefix, (String)"$prefix");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
        return StringsKt.startsWith$default((String)name, (String)$prefix, (boolean)false, (int)2, null);
    }

    static {
        String[] stringArray = new String[]{"file", "content", "android.resource"};
        LOCAL_URI_PREFIXES = stringArray;
    }
}

