/*
 * Decompiled with CFR 0.152.
 */
package com.guhungry.photomanipulator;

import android.graphics.Bitmap;
import android.os.Build;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0007J\u0012\u0010\n\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/guhungry/photomanipulator/MimeUtils;", "", "()V", "JPEG", "", "PNG", "WEBP", "toCompressFormat", "Landroid/graphics/Bitmap$CompressFormat;", "type", "toExtension", "photomanipulator_release"})
public final class MimeUtils {
    @NotNull
    public static final MimeUtils INSTANCE = new MimeUtils();
    @NotNull
    public static final String PNG = "image/png";
    @NotNull
    public static final String WEBP = "image/webp";
    @NotNull
    public static final String JPEG = "image/jpeg";

    private MimeUtils() {
    }

    @JvmStatic
    @NotNull
    public static final String toExtension(@Nullable String type) {
        String string = type;
        return Intrinsics.areEqual((Object)string, (Object)PNG) ? ".png" : (Intrinsics.areEqual((Object)string, (Object)WEBP) ? ".webp" : ".jpg");
    }

    @JvmStatic
    @NotNull
    public static final Bitmap.CompressFormat toCompressFormat(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Bitmap.CompressFormat formatWEBP = Build.VERSION.SDK_INT >= 30 ? Bitmap.CompressFormat.WEBP_LOSSY : Bitmap.CompressFormat.WEBP;
        String string = type;
        return Intrinsics.areEqual((Object)string, (Object)PNG) ? Bitmap.CompressFormat.PNG : (Intrinsics.areEqual((Object)string, (Object)WEBP) ? formatWEBP : Bitmap.CompressFormat.JPEG);
    }
}

