/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm;

import bitronix.tm.BitronixTransaction;
import bitronix.tm.BitronixTransactionManagerObjectFactory;
import bitronix.tm.Configuration;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.Version;
import bitronix.tm.internal.BitronixSystemException;
import bitronix.tm.internal.LogDebugCheck;
import bitronix.tm.internal.ThreadContext;
import bitronix.tm.internal.XAResourceManager;
import bitronix.tm.utils.ClassLoaderUtils;
import bitronix.tm.utils.Decoder;
import bitronix.tm.utils.InitializationException;
import bitronix.tm.utils.MonotonicClock;
import bitronix.tm.utils.Scheduler;
import bitronix.tm.utils.Service;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAException;

public class BitronixTransactionManager
implements TransactionManager,
UserTransaction,
Referenceable,
Service {
    private static final Logger log = Logger.getLogger(BitronixTransactionManager.class.toString());
    private static final String NO_TRANSACTION_TEXT = "no transaction started on this thread";
    private final SortedMap<BitronixTransaction, ClearContextSynchronization> inFlightTransactions;
    private volatile boolean shuttingDown;

    public BitronixTransactionManager() {
        try {
            this.shuttingDown = false;
            this.logVersion();
            Configuration configuration = TransactionManagerServices.getConfiguration();
            configuration.buildServerIdArray();
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("starting BitronixTransactionManager using " + configuration);
            }
            TransactionManagerServices.getJournal().open();
            TransactionManagerServices.getResourceLoader().init();
            TransactionManagerServices.getRecoverer().run();
            int backgroundRecoveryInterval = TransactionManagerServices.getConfiguration().getBackgroundRecoveryIntervalSeconds();
            if (backgroundRecoveryInterval < 1) {
                throw new InitializationException("invalid configuration value for backgroundRecoveryIntervalSeconds, found '" + backgroundRecoveryInterval + "' but it must be greater than 0");
            }
            this.inFlightTransactions = this.createInFlightTransactionsMap();
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("recovery will run in the background every " + backgroundRecoveryInterval + " second(s)");
            }
            Date nextExecutionDate = new Date(MonotonicClock.currentTimeMillis() + (long)backgroundRecoveryInterval * 1000L);
            TransactionManagerServices.getTaskScheduler().scheduleRecovery(TransactionManagerServices.getRecoverer(), nextExecutionDate);
        }
        catch (IOException ex) {
            throw new InitializationException("cannot open disk journal", ex);
        }
        catch (Exception ex) {
            TransactionManagerServices.getJournal().shutdown();
            TransactionManagerServices.getResourceLoader().shutdown();
            throw new InitializationException("initialization failed, cannot safely start the transaction manager", ex);
        }
    }

    private void logVersion() {
        log.info("Bitronix Transaction Manager version " + Version.getVersion());
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("JVM version " + System.getProperty("java.version"));
        }
    }

    private SortedMap<BitronixTransaction, ClearContextSynchronization> createInFlightTransactionsMap() throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        boolean debug = LogDebugCheck.isDebugEnabled();
        if (debug) {
            log.finer("Creating sorted memory storage for inflight transactions.");
        }
        Comparator timestampSortComparator = (t1, t2) -> {
            Long timestamp2;
            Long timestamp1 = t1.getResourceManager().getGtrid().extractTimestamp();
            int compareTo = timestamp1.compareTo(timestamp2 = Long.valueOf(t2.getResourceManager().getGtrid().extractTimestamp()));
            if (compareTo == 0 && !t1.getResourceManager().getGtrid().equals(t2.getResourceManager().getGtrid())) {
                return t1.getGtrid().compareTo(t2.getGtrid());
            }
            return compareTo;
        };
        if (debug) {
            log.finer("Attempting to use a concurrent sorted map of type 'ConcurrentSkipListMap' (from jre6 or custom supplied backport)");
        }
        try {
            SortedMap mapInstance = (SortedMap)ClassLoaderUtils.loadClass("java.util.concurrent.ConcurrentSkipListMap").getConstructor(Comparator.class).newInstance(timestampSortComparator);
            return mapInstance;
        }
        catch (ClassNotFoundException e) {
            if (debug) {
                log.log(Level.FINER, "Concurrent sorted map 'ConcurrentSkipListMap' is not available. Falling back to a synchronized TreeMap.", e);
            }
            return Collections.synchronizedSortedMap(new TreeMap(timestampSortComparator));
        }
    }

    public void begin() throws NotSupportedException, SystemException {
        BitronixTransaction currentTx;
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("beginning a new transaction");
        }
        if (this.isShuttingDown()) {
            throw new BitronixSystemException("cannot start a new transaction, transaction manager is shutting down");
        }
        if (LogDebugCheck.isDebugEnabled()) {
            this.dumpTransactionContexts();
        }
        if ((currentTx = this.getCurrentTransaction()) == null) {
            currentTx = this.createTransaction();
        }
        ThreadContext threadContext = ThreadContext.getContext();
        ClearContextSynchronization clearContextSynchronization = new ClearContextSynchronization(currentTx, threadContext);
        try {
            currentTx.getSynchronizationScheduler().add(clearContextSynchronization, Scheduler.ALWAYS_LAST_POSITION - 1);
            currentTx.setActive(threadContext.getTimeout());
            this.inFlightTransactions.put(currentTx, clearContextSynchronization);
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("begun new transaction at " + new Date(currentTx.getResourceManager().getGtrid().extractTimestamp()));
            }
        }
        catch (RuntimeException | SystemException ex) {
            clearContextSynchronization.afterCompletion(6);
            throw ex;
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException {
        BitronixTransaction currentTx = this.getCurrentTransaction();
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("committing transaction " + currentTx);
        }
        if (currentTx == null) {
            throw new IllegalStateException(NO_TRANSACTION_TEXT);
        }
        currentTx.commit();
    }

    public int getStatus() throws SystemException {
        BitronixTransaction currentTx = this.getCurrentTransaction();
        if (currentTx == null) {
            return 6;
        }
        return currentTx.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        return this.getCurrentTransaction();
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, SystemException {
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("resuming " + transaction);
        }
        if (transaction == null) {
            throw new InvalidTransactionException("resumed transaction cannot be null");
        }
        if (!(transaction instanceof BitronixTransaction)) {
            throw new InvalidTransactionException("resumed transaction must be an instance of BitronixTransaction");
        }
        BitronixTransaction tx = (BitronixTransaction)transaction;
        if (this.getCurrentTransaction() != null) {
            throw new IllegalStateException("a transaction is already running on this thread");
        }
        try {
            XAResourceManager resourceManager = tx.getResourceManager();
            resourceManager.resume();
            ThreadContext threadContext = ThreadContext.getContext();
            threadContext.setTransaction(tx);
            ((ClearContextSynchronization)this.inFlightTransactions.get(tx)).setThreadContext(threadContext);
        }
        catch (XAException ex) {
            String extraErrorDetails = TransactionManagerServices.getExceptionAnalyzer().extractExtraXAExceptionDetails(ex);
            throw new BitronixSystemException("cannot resume " + tx + ", error=" + Decoder.decodeXAExceptionErrorCode(ex) + (String)(extraErrorDetails == null ? "" : ", extra error=" + extraErrorDetails), ex);
        }
    }

    public void rollback() throws SystemException {
        BitronixTransaction currentTx = this.getCurrentTransaction();
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("rolling back transaction " + currentTx);
        }
        if (currentTx == null) {
            throw new IllegalStateException(NO_TRANSACTION_TEXT);
        }
        currentTx.rollback();
    }

    public void setRollbackOnly() throws SystemException {
        BitronixTransaction currentTx = this.getCurrentTransaction();
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("marking transaction as rollback only: " + currentTx);
        }
        if (currentTx == null) {
            throw new IllegalStateException(NO_TRANSACTION_TEXT);
        }
        currentTx.setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        if (seconds < 0) {
            throw new BitronixSystemException("cannot set a timeout to less than 0 second (was: " + seconds + "s)");
        }
        ThreadContext.getContext().setTimeout(seconds);
    }

    public Transaction suspend() throws SystemException {
        BitronixTransaction currentTx = this.getCurrentTransaction();
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("suspending transaction " + currentTx);
        }
        if (currentTx == null) {
            return null;
        }
        try {
            currentTx.getResourceManager().suspend();
            this.clearCurrentContextForSuspension();
            ((ClearContextSynchronization)this.inFlightTransactions.get(currentTx)).setThreadContext(null);
            return currentTx;
        }
        catch (XAException ex) {
            String extraErrorDetails = TransactionManagerServices.getExceptionAnalyzer().extractExtraXAExceptionDetails(ex);
            throw new BitronixSystemException("cannot suspend " + currentTx + ", error=" + Decoder.decodeXAExceptionErrorCode(ex) + (String)(extraErrorDetails == null ? "" : ", extra error=" + extraErrorDetails), ex);
        }
    }

    private void clearCurrentContextForSuspension() {
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("clearing current thread context: " + ThreadContext.getContext());
        }
        ThreadContext.getContext().clearTransaction();
    }

    private boolean isShuttingDown() {
        return this.shuttingDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpTransactionContexts() {
        if (!LogDebugCheck.isDebugEnabled()) {
            return;
        }
        SortedMap<BitronixTransaction, ClearContextSynchronization> sortedMap = this.inFlightTransactions;
        synchronized (sortedMap) {
            log.finer("dumping " + this.inFlightTransactions.size() + " transaction context(s)");
            for (BitronixTransaction tx : this.inFlightTransactions.keySet()) {
                log.finer(tx.toString());
            }
        }
    }

    public BitronixTransaction getCurrentTransaction() {
        return ThreadContext.getContext().getTransaction();
    }

    private BitronixTransaction createTransaction() {
        BitronixTransaction transaction = new BitronixTransaction();
        ThreadContext.getContext().setTransaction(transaction);
        return transaction;
    }

    @Override
    public Reference getReference() throws NamingException {
        return new Reference(BitronixTransactionManager.class.getName(), new StringRefAddr("TransactionManager", "BitronixTransactionManager"), BitronixTransactionManagerObjectFactory.class.getName(), null);
    }

    public int getInFlightTransactionCount() {
        return this.inFlightTransactions.size();
    }

    public long getOldestInFlightTransactionTimestamp() {
        try {
            BitronixTransaction oldestTransaction = this.inFlightTransactions.firstKey();
            long oldestTimestamp = oldestTransaction.getResourceManager().getGtrid().extractTimestamp();
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("oldest in-flight transaction's timestamp: " + oldestTimestamp);
            }
            return oldestTimestamp;
        }
        catch (NoSuchElementException e) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.log(Level.FINER, "oldest in-flight transaction's timestamp: -9223372036854775808", e);
            }
            return Long.MIN_VALUE;
        }
    }

    @Override
    public synchronized void shutdown() {
        if (this.isShuttingDown()) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("Transaction Manager has already shut down");
            }
            return;
        }
        log.info("shutting down Bitronix Transaction Manager");
        this.internalShutdown();
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("shutting down resource loader");
        }
        TransactionManagerServices.getResourceLoader().shutdown();
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("shutting down executor");
        }
        TransactionManagerServices.getExecutor().shutdown();
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("shutting down task scheduler");
        }
        TransactionManagerServices.getTaskScheduler().shutdown();
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("shutting down journal");
        }
        TransactionManagerServices.getJournal().shutdown();
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("shutting down recoverer");
        }
        TransactionManagerServices.getRecoverer().shutdown();
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("shutting down configuration");
        }
        TransactionManagerServices.getConfiguration().shutdown();
        TransactionManagerServices.clear();
        if (LogDebugCheck.isDebugEnabled()) {
            log.finer("shutdown ran successfully");
        }
    }

    private void internalShutdown() {
        this.shuttingDown = true;
        this.dumpTransactionContexts();
        int txCount = 0;
        try {
            txCount = this.inFlightTransactions.size();
            for (int seconds = TransactionManagerServices.getConfiguration().getGracefulShutdownInterval(); seconds > 0 && txCount > 0; --seconds) {
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("still " + txCount + " in-flight transactions, waiting... (" + seconds + " second(s) left)");
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                txCount = this.inFlightTransactions.size();
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "cannot get a list of in-flight transactions", ex);
        }
        if (txCount > 0) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("still " + txCount + " in-flight transactions, shutting down anyway");
                this.dumpTransactionContexts();
            }
        } else if (LogDebugCheck.isDebugEnabled()) {
            log.finer("all transactions finished, resuming shutdown");
        }
    }

    public String toString() {
        return "a BitronixTransactionManager with " + this.inFlightTransactions.size() + " in-flight transaction(s)";
    }

    private final class ClearContextSynchronization
    implements Synchronization {
        private final BitronixTransaction currentTx;
        private final AtomicReference<ThreadContext> threadContext;

        public ClearContextSynchronization(BitronixTransaction currentTx, ThreadContext threadContext) {
            this.currentTx = currentTx;
            this.threadContext = new AtomicReference<ThreadContext>(threadContext);
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            ThreadContext context = this.threadContext.get();
            if (context != null) {
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("clearing transaction from thread context: " + context);
                }
                context.clearTransaction();
            } else if (LogDebugCheck.isDebugEnabled()) {
                log.finer("thread context was null when clear context synchronization executed");
            }
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("removing transaction from in-flight transactions: " + this.currentTx);
            }
            BitronixTransactionManager.this.inFlightTransactions.remove(this.currentTx);
        }

        public void setThreadContext(ThreadContext threadContext) {
            this.threadContext.set(threadContext);
        }

        public String toString() {
            return "a ClearContextSynchronization for " + this.currentTx;
        }
    }
}

