/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm;

import bitronix.tm.BitronixTransaction;
import bitronix.tm.BitronixTransactionManager;
import bitronix.tm.BitronixTransactionSynchronizationRegistryObjectFactory;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.internal.BitronixRuntimeException;
import bitronix.tm.internal.LogDebugCheck;
import bitronix.tm.utils.Scheduler;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionSynchronizationRegistry;

public class BitronixTransactionSynchronizationRegistry
implements TransactionSynchronizationRegistry,
Referenceable {
    private static final Logger log = Logger.getLogger(BitronixTransactionSynchronizationRegistry.class.toString());
    private static final ThreadLocal<Map<Object, Object>> resourcesTl = ThreadLocal.withInitial(HashMap::new);
    private static final String CANT_GET_TRANSACTION = "cannot get current transaction status";
    private static final String NO_TRANSACTION_ON_THREAD = "no transaction started on current thread";
    private final BitronixTransactionManager transactionManager = TransactionManagerServices.getTransactionManager();

    public Object getTransactionKey() {
        try {
            if (this.currentTransaction() == null || this.currentTransaction().getStatus() == 6) {
                return null;
            }
            return this.currentTransaction().getGtrid();
        }
        catch (SystemException ex) {
            throw new BitronixRuntimeException(CANT_GET_TRANSACTION, ex);
        }
    }

    public void putResource(Object key, Object value) {
        try {
            if (key == null) {
                throw new NullPointerException("key cannot be null");
            }
            if (this.currentTransaction() == null || this.currentTransaction().getStatus() == 6) {
                throw new IllegalStateException(NO_TRANSACTION_ON_THREAD);
            }
            Object oldValue = this.getResources().put(key, value);
            if (oldValue == null && this.getResources().size() == 1) {
                if (LogDebugCheck.isDebugEnabled()) {
                    log.finer("first resource put in synchronization registry, registering a ClearRegistryResourcesSynchronization");
                }
                ClearRegistryResourcesSynchronization synchronization = new ClearRegistryResourcesSynchronization();
                this.currentTransaction().getSynchronizationScheduler().add(synchronization, Scheduler.ALWAYS_LAST_POSITION);
            }
        }
        catch (SystemException ex) {
            throw new BitronixRuntimeException(CANT_GET_TRANSACTION, ex);
        }
    }

    public Object getResource(Object key) {
        try {
            if (key == null) {
                throw new NullPointerException("key cannot be null");
            }
            if (this.currentTransaction() == null || this.currentTransaction().getStatus() == 6) {
                throw new IllegalStateException(NO_TRANSACTION_ON_THREAD);
            }
            return this.getResources().get(key);
        }
        catch (SystemException ex) {
            throw new BitronixRuntimeException(CANT_GET_TRANSACTION, ex);
        }
    }

    public void registerInterposedSynchronization(Synchronization synchronization) {
        try {
            if (this.currentTransaction() == null || this.currentTransaction().getStatus() == 6) {
                throw new IllegalStateException(NO_TRANSACTION_ON_THREAD);
            }
            if (this.currentTransaction().getStatus() == 7 || this.currentTransaction().getStatus() == 2 || this.currentTransaction().getStatus() == 8 || this.currentTransaction().getStatus() == 3 || this.currentTransaction().getStatus() == 9 || this.currentTransaction().getStatus() == 4) {
                throw new IllegalStateException("transaction is done, cannot register an interposed synchronization");
            }
            this.currentTransaction().getSynchronizationScheduler().add(synchronization, Scheduler.DEFAULT_POSITION - 1);
        }
        catch (SystemException ex) {
            throw new BitronixRuntimeException(CANT_GET_TRANSACTION, ex);
        }
    }

    public int getTransactionStatus() {
        try {
            if (this.currentTransaction() == null) {
                return 6;
            }
            return this.currentTransaction().getStatus();
        }
        catch (SystemException ex) {
            throw new BitronixRuntimeException(CANT_GET_TRANSACTION, ex);
        }
    }

    public void setRollbackOnly() {
        try {
            if (this.currentTransaction() == null || this.currentTransaction().getStatus() == 6) {
                throw new IllegalStateException(NO_TRANSACTION_ON_THREAD);
            }
            this.currentTransaction().setStatus(1);
        }
        catch (SystemException ex) {
            throw new BitronixRuntimeException("cannot get or set current transaction status", ex);
        }
    }

    public boolean getRollbackOnly() {
        try {
            if (this.currentTransaction() == null || this.currentTransaction().getStatus() == 6) {
                throw new IllegalStateException(NO_TRANSACTION_ON_THREAD);
            }
            return this.currentTransaction().getStatus() == 1;
        }
        catch (SystemException e) {
            throw new BitronixRuntimeException(CANT_GET_TRANSACTION, e);
        }
    }

    private Map<Object, Object> getResources() {
        return resourcesTl.get();
    }

    private BitronixTransaction currentTransaction() {
        return this.transactionManager.getCurrentTransaction();
    }

    @Override
    public Reference getReference() throws NamingException {
        return new Reference(BitronixTransactionManager.class.getName(), new StringRefAddr("TransactionSynchronizationRegistry", "BitronixTransactionSynchronizationRegistry"), BitronixTransactionSynchronizationRegistryObjectFactory.class.getName(), null);
    }

    private final class ClearRegistryResourcesSynchronization
    implements Synchronization {
        private ClearRegistryResourcesSynchronization() {
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            if (LogDebugCheck.isDebugEnabled()) {
                log.finer("clearing resources");
            }
            BitronixTransactionSynchronizationRegistry.this.getResources().clear();
        }
    }
}

