/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm;

import bitronix.tm.utils.Uid;
import javax.transaction.xa.Xid;

public class BitronixXid
implements Xid {
    public static final int FORMAT_ID = 1114926712;
    private final Uid globalTransactionId;
    private final Uid branchQualifier;
    private final int hashCodeValue;
    private final String toStringValue;

    public BitronixXid(Xid xid) {
        this(new Uid(xid.getGlobalTransactionId()), new Uid(xid.getBranchQualifier()));
    }

    public BitronixXid(Uid globalTransactionId, Uid branchQualifier) {
        this.globalTransactionId = globalTransactionId;
        this.branchQualifier = branchQualifier;
        this.toStringValue = this.precalculateToString();
        this.hashCodeValue = this.precalculateHashCode();
    }

    private String precalculateToString() {
        StringBuilder sb = new StringBuilder(288);
        sb.append("a Bitronix XID [");
        sb.append(this.globalTransactionId.toString());
        sb.append(" : ");
        sb.append(this.branchQualifier.toString());
        sb.append("]");
        return sb.toString();
    }

    private int precalculateHashCode() {
        int hashCode = 1114926712;
        if (this.globalTransactionId != null) {
            hashCode += this.globalTransactionId.hashCode();
        }
        if (this.branchQualifier != null) {
            hashCode += this.branchQualifier.hashCode();
        }
        return hashCode;
    }

    public int hashCode() {
        return this.hashCodeValue;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BitronixXid)) {
            return false;
        }
        BitronixXid otherXid = (BitronixXid)obj;
        return 1114926712 == otherXid.getFormatId() && this.globalTransactionId.equals(otherXid.getGlobalTransactionIdUid()) && this.branchQualifier.equals(otherXid.getBranchQualifierUid());
    }

    @Override
    public int getFormatId() {
        return 1114926712;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId.getArray();
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branchQualifier.getArray();
    }

    public Uid getGlobalTransactionIdUid() {
        return this.globalTransactionId;
    }

    public Uid getBranchQualifierUid() {
        return this.branchQualifier;
    }

    public String toString() {
        return this.toStringValue;
    }
}

